#! /usr/local/bin/R

############### InitParam.R #################
# These codes were written by Xiao-Qin Xia to initialize parameters for R CGI scripts
# Usually these parameters will be offered by CGI users. These codes will help to use default values in case user didn't offer values for necessary parameters. Default values should be offered before these codes like this:
#
# default.params <- list(
#	graphDir = "/home/xxia/public_html/cgi-bin/R_code/ResultsData_Output/Results_Charts/",
#	Final.Chart.Title = "Final_Results_Plot.png",
#	design = c(1, -1),
#	Num.of.Dup = 1,
#	Num.of.Diff.Samples = 2,
#	Num.of.Slide.Per.Exp = 2
#	)
#
# To use this script, just add a line:
# 	source('InitParams.R')
# below the default parameter list.
#
# A master python script can define parameters (that may be offered by user through web) for R. These parameters can be defined by R function 'assign' seperately, or be offered in a python dictionary - "user_params" (i.e. "user.params" in R), where both approaches are apply to a certain variable, the value offered by 'user_params' will dominate.


present.names <- ls()

# Read parameters from user offered list - user.params
r.names <- factor(c(present.names, "user.params"))
r.names.num <- tapply(r.names, r.names, length)

if (r.names.num[["user.params"]] == 2) {
	user.param.names <- names(user.params)
	#r.names <- factor(c(present.names, user.param.names))
	# r.names.num <- tapply(r.names, r.names, length)
	for (name in user.param.names) {
		#if (r.names.num[[name]] == 1) # use 2 here will override orignal parameters by user defined parameters seprately
		assign(name, user.params[[name]]) # now user parameters will always dominate.
		}
}
			
present.names <- ls()
# Complement with default parameters
default.param.names <- names(default.params)
r.names <- factor(c(present.names, "user.params", default.param.names))
r.names.num <- tapply(r.names, r.names, length)

for (name in default.param.names) 
	if (r.names.num[[name]] == 1)	assign(name, default.params[[name]])
		

