
# bgcorrect.methods: "mas", "none", "rma", "rma2"
# normalize.methods(Data): "constant", "contrasts", "invariantset", "loess",
#		"qspline", "quantiles", "quantiles.robust", "vsn" 
# pmcorrect.methods: "mas", "pmonly", "subtractmm"
# express.summary.stat.methods: "avgdiff", "liwong", "mas", "medianpolish", "playerout" 

# affy.method:"rma","mas5","dchip","userdefined"

# plots: "array.image","hist","MAplot","RNAdeg","boxplot","CGH"

default.params <- list(
	source.dir <- "sources",
	graphDir <- paste(getwd(),"/ResultsData_Output/Results_Charts/", sep=''), #note the tailing "/" !
	raw.data.dir <- "RawData_Input",
	result.data.dir <- "ResultsData_Output",
	chart.dir <- "ResultsData_Output/Results_Charts",

	design.file <- "RawData_Input/design.txt",
	location.file <- "RawData_Input/genes_chr_hpaii.txt",

	design.ch1<- c("ctrl","ctrl","exp1","exp1"),
	design.comp <- list(),
	simple.design <- TRUE, #TRUE, # should be calculated with web data
	contrast <- c("exp1-ctrl", "ctrl-exp1"),
	contrast.design <- list(c("exp1","ctrl"),c("ctrl","exp1")),

	use.targets.file <- FALSE,
	slides <- c('Sarah_2005_03_24_TH1_1.CEL', 'Sarah_2005_03_24_TH1_2.CEL', 'Sarah_2005_03_24_TR_1.CEL', 'Sarah_2005_03_24_TR_2.CEL'), # list of intensity files

	affy.method <- "rma", 

	#affy.bg.correct <- TRUE, 
	affy.bgcorrect.method <- "rma", 
	#affy.bgcorrect.param <- list(),
	#affy.normalize <- TRUE, 
	affy.normalize.method <- "constant", 
	#affy.normalize.param <- list(),
	affy.pmcorrect.method <- "pmonly", 
	#affy.pmcorrect.param <- list(),
	affy.summary.method <- "avgdiff", 
	#affy.summary.param <- list(), 
	affy.summary.subset <- NULL,
	affy.verbose <- FALSE,

	analysis <- "linear model analysis", #"normalization", # "linear model analysis"

	Output.Format <- c("SpotID"),
	result.norm.data <- "output.normalized.data.txt",
	result.analyzed.data <- "output.analyzed.data",

	plot.analyzed.results <- TRUE,
	plot.affy.image <- TRUE,
	plot.affy.hist <- TRUE,
	plot.affy.MAplot <- TRUE,
	plot.affy.RNAdeg <- TRUE,
	plot.affy.boxplot <- TRUE,
	plot.affy.CGH <- FALSE,

	title.affy.result <- "affy.result.chart",
	title.affy.image <- "affy.image",
	title.affy.hist <- "affy.hist",
	title.affy.MAplot <- "affy.MAplot",
	title.affy.RNAdeg <- "affy.RNAdeg",
	title.affy.boxplot <- "affy.boxplot",
	title.affy.CGH <- "affy.CGH.plot",
	
	genome.sorting <- FALSE, # CGH analysis
	genomes <- "human",
	genome.no <- 10,
	span <- 0.8, 
	chr.thre.1 <- 1.8,
	chr.thre.2 <- 0.001,
	chr.lim.1 <- 1.5, 
	chr.lim.2 <- 3,

	req_name <- ""
	)

addNamePrefix <- function() {
	if (req_name != '') {
		title.affy.result <<- paste(req_name, "_", title.affy.result, sep='')
		title.affy.image <<- paste(req_name, "_", title.affy.image, sep='')
		title.affy.hist <<- paste(req_name, "_", title.affy.hist, sep='')
		title.affy.MAplot <<- paste(req_name, "_", title.affy.MAplot, sep='')
		title.affy.RNAdeg <<- paste(req_name, "_", title.affy.RNAdeg, sep='')
		title.affy.boxplot <<- paste(req_name, "_", title.affy.boxplot, sep='')
		title.affy.CGH <<- paste(req_name, "_", title.affy.CGH, sep='')
		result.norm.data <<- paste(req_name, "_", result.norm.data, sep='')
		result.analyzed.data <<- paste(req_name, "_", result.analyzed.data, sep='')
		}
	}


mypaste <- function(src, i, max_num, sep='') {
	if (i>0 && max_num>0 && i<max_num){
		wid <- as.integer(log10(max_num))+1
		iwid <- as.integer(log10(length(i)))+1
		owid <- wid - iwid
		zs <- ''
		if (owid>0){
			#zs <- rep('0', times=owid)
			for (k in 1:owid) zs <- paste(zs, '0', sep='')
			#zs <- paste(zs, sep='')
			}
		zs <- paste(src, zs, i, sep=sep)
	}else zs <- paste(src, i , sep=sep)
	zs
	}

mycontrastname <- function(contra, format){
	contrast.name <- c()
    if(identical(format, "list")){
		for(i in 1:length(contra)){
			contrast.name <- c(contrast.name, paste(contra[[i]][1],".", contra[[i]][2],sep=""))
		}
	}else{
		contrast.name <- contra[2: length(contra)]
	}
	return(contrast.name)
}

####################################################
#########            load library          #########
####################################################
wd<-getwd()

source('InitParams.R')

library(affy);
library(limma);
library(sma);

setwd(source.dir);
source("splosh-code3_000.R");
source("CGH_v01.R");
source("myMakeContrast.R");
source("mkDesign.R");
source("plot-results.R");
source("read_imagefile.R");
setwd(wd);

#####################################################
############ read genome location file ##############
#####################################################

readGeneLoc <- function() {
	if(genome.sorting == TRUE){
		chr.position <<- try(read.delim(location.file, header=TRUE),TRUE);
		if(!is.list(chr.position)) stop("error: genome/chromosome location file format is not correct!");
		}
	}

#####################################################
################ experiment design  #################
#####################################################
affy.makeDesign <- function(){ 
	if(simple.design == TRUE){
		if(is.list(contrast.design) && length(contrast.design) >= 1) {
			designs <- mkDesign(design.ch1, comp=contrast.design)
			design <<- designs$design
			contrast.matrix <<- designs$contrast

			design.num <<- length(contrast.design)
			contrast.name <<- mycontrastname(contra=contrast.design, format="list")
		}
		else{
			design <<- mkDesign(targets=design.ch1)$design
			contrast.design <<- as.list(c("", colnames(design)))
			contrast.matrix <<- my.makeContrasts(contrast=contrast.design,levels=design);
			design.num <<- length(contrast.design) - 1
			contrast.name <<- mycontrastname(contra=contrast.design, format="vector")
		}
	}
	else{
		design <<- read.delim(design.file)	

		if(is.list(contrast.design) && length(contrast.design) >= 1) 
			contrast.design <<- as.list(c("", contrast.design))
		else	contrast.design <<- as.list(c("", colnames(design)))
			
		contrast.matrix <<- my.makeContrasts(contrast=contrast.design,levels=design);	
		design.num <<- length(contrast.design) - 1
		contrast.name <<- mycontrastname(contra=contrast.design, format="vector")
	}

	if((!is.vector(design) && is.array(design) && !is.list(design) && !is.matrix(design)) || 
		(!is.vector(contrast.matrix) && !is.array(contrast.matrix) && !is.list(contrast.matrix) && !is.matrix(contrast.matrix)))
		stop("error: experiment design is not correct!");
}

####################################################
#########    read affymetrix CEL file      #########
####################################################
affy.readIntensity <- function() {
	setwd(raw.data.dir);
	if(use.targets.file == TRUE){
		targets <- try(readTargets(targets.file), TRUE);
		if(!is.list(targets))
			stop("error: target file format is not correct!");
		slides <- targets$FileName;
	}
	Data <<- ReadAffy(filenames=slides)
	#if(!is.list(Data)) stop("error: microarray intensity file name or format is not correct!");
	if(class(Data)!='AffyBatch') stop("error: microarray intensity file name or format is not correct!");
	Num.of.Slides <<- length(slides);
	setwd(wd);
}

####################################################
#########      Expression Measures         #########
####################################################
expressionMeasure <- function(){
   ##### RMA ############
   if(identical(affy.method,"rma")) eset <<- rma(Data)

   ##### MAS 5.0 ############
   if(identical(affy.method,"mas5")) eset <<- mas5(Data)
   

   ##### Li and Wong's MEBI (dchip) ############
   if(identical(affy.method,"dchip")) 
	eset <<- expresso(Data,normalize.method="invariantset",bg.correct=FALSE,
		pmcorrect.method="pmonly",summary.method="liwong")

   ##### expresso ############
   if(identical(affy.method,"userdefined")){
	   if(identical(affy.normalize.method,"none")){
	     eset <<- expresso(Data,
				 # background correction
        	 bgcorrect.method=affy.bgcorrect.method,#bg.correct=affy.bg.correct,bgcorrect.param=affy.bgcorrect.param,
		         # normalize
             normalize=FALSE, #normalize.method=affy.normalize.method,#normalize.param=affy.normalize.param,
		         # pm correction
             pmcorrect.method=affy.pmcorrect.method,#pmcorrect.param=affy.pmcorrect.param,
    		     # expression values
             summary.method=affy.summary.method,summary.subset=affy.summary.subset,#summary.param=affy.summary.param
		         # misc.
             verbose=affy.verbose)
	   }else{
 		eset <<- expresso(Data,
				 # background correction
				 bgcorrect.method=affy.bgcorrect.method, #bg.correct=affy.bg.correct,bgcorrect.param=affy.bgcorrect.param,
		         # normalize
             normalize=TRUE, normalize.method=affy.normalize.method, #normalize.param=affy.normalize.param,
		         # pm correction
             pmcorrect.method=affy.pmcorrect.method,#pmcorrect.param=affy.pmcorrect.param,
		         # expression values
             summary.method=affy.summary.method,summary.subset=affy.summary.subset,#summary.param=affy.summary.param
        		 # misc.
             verbose=affy.verbose)
	   }
	}
	if(mean(eset@exprs) > 20)
		eset@exprs <<- log(eset@exprs, 2)
	Num.of.spots.per.array <<- length(eset@exprs[,1]);
}
#####################################################
############ export normalized data  ################
#####################################################
affy.normalizeOnly <- function()
	write.exprs(eset, result.norm.data)

#####################################################
############ statistical analysis  ##################
#####################################################
affy.analyze <- function() {
	fit <- try(lmFit(eset, design), TRUE);
	if(!is.list(fit)) stop("error: statistical analysis can not be executed!")

	fit1 <- try(contrasts.fit(fit, contrast.matrix), TRUE);
	if(!is.list(fit1)) stop("error: statistical analysis can not be executed!")

	fit2 <- try(eBayes(fit1), TRUE);
	if(!is.list(fit2)) stop("error: statistical analysis can not be executed!")

	A <- fit2$Amean;

	for ( i in 1: design.num){
		if(design.num == 1){
			M<-fit2$coef;			p<-fit2$p.value;
			t<-fit2$t;				B<-fit2$lods; 
		}else{
			M<-fit2$coef[,i];		p<-fit2$p.value[,i];
			t<-fit2$t[,i];			B<-fit2$lods[,i]; 
		}
		my.fdr <- try(splosh(pvals=p), TRUE);
		if(!is.list(my.fdr)) stop("error: false dicovery rate calculation can not be executed!");
		cgh <- rep(NA, Num.of.spots.per.array);

		#===========  Draw Chart for final Results  ====================
		if (plot.analyzed.results == TRUE) {
			chart.name<-paste(graphDir, title.affy.result, mypaste(".comparison.",i, design.num, sep=''), '.', contrast.name[i], '.png',sep="");
			try(plot.results(M=M,A=A,B=B,p=p,chart.name=chart.name), TRUE);
		}
		
		#===========  Draw Chart for chromosome location  ==============
		if(genome.sorting == TRUE){
			M.chr <- M[chr.position[,1]];
			cgh.genes <- try(plot.chrom(ratio=M.chr, chr=chr.position[,2],genome = genomes,
				genome.no=genome.no, a=span, c.thre=chr.thre.1, p.thre=chr.thre.2, 
				lim1 = chr.lim.1, lim2 = chr.lim.2,plot.cgh=plot.affy.CGH,
				imagename=paste(graphDir, title.affy.CGH, mypaste('.', i, design.num, sep=''), '.', contrast.name[i], '.png', sep='')
				), TRUE);
			if(is.vector(cgh.genes)) cgh <- replace(cgh, chr.position[,1], cgh.genes);
			}
			#===========  write data  ======================================
		file.name<-paste(result.analyzed.data,mypaste(".comparison.",i, design.num, sep=''), '.', contrast.name[i], '.txt', sep="");
		All.Results.matrix<-try(matrix(c(as.vector(fit2$genes[,1]),M, A, t,p,B,my.fdr$cfdr,my.fdr$fp,my.fdr$fn,cgh), ncol=10),TRUE);

		if(!is.matrix(All.Results.matrix))	stop("error: results file format is not correct!");			
		colnames(All.Results.matrix)<-c("probeset.ID", "M","A","t", "P", "B", "fdr", "fp", "fn","CGH"); 
		if(identical(Output.Format, "SpotID"))	sort.index <- sort(c(1:Num.of.spots.per.array), index.return = TRUE)
		if(identical(Output.Format, "sort.M")) sort.index <- sort(M, index.return = TRUE)
		if(identical(Output.Format, "sort.p")) sort.index <- sort(p, index.return = TRUE)
		if(identical(Output.Format, "sort.B")) sort.index <- sort(B, decreasing=TRUE, index.return = TRUE)
		All.Results.matrix <- All.Results.matrix[sort.index$ix,];
		write.table(All.Results.matrix, sep = "\t", file=file.name);
	}
}

################################################################################
#############     Quality Control through Data Exploration    ##################
################################################################################
#nd <- paste(wd, "/ResultsData_Output", sep="");setwd(nd);
##### plot 1: MAplot ############
draw.affy.MAplot <- function(){
	if(Num.of.Slides == 1){
		bitmap(paste(graphDir,title.affy.MAplot,'.png', sep=''), width=10,height=10)
		try(MAplot(Data), TRUE);
		dev.off()
	}else{
	    for(i in 1:Num.of.Slides){
			bitmap(paste(graphDir,title.affy.MAplot,'.',i,'.png', sep=''), width=10,height=10)
			try(MAplot(Data, which=i), TRUE);
			dev.off()
		}
	}
#	n<-0
#	sample.names <- colnames(eset@exprs)
#    for(i in 1:Num.of.Slides){
#		for(j in 1: Num.of.Slides){
#			if(j>i){
#				n <- n+1
#				M <- log(((eset@exprs[,j])/(eset@exprs[,j])), 2)
#				A <- (log(((eset@exprs[,j])*(eset@exprs[,i])),2))/2
#				bitmap(paste(graphDir,title.affy.MAplot,'.',n,'.png', sep=''), width=12,height=12)
				#try(MAplot(Data, pairs = TRUE), TRUE);
#				main <- paste(sample.names[j],"/",sample.names[i],sep="")
#				try(ma.plot(A,M,cex=0.1,xlab="A",ylab="M",main=main), TRUE)
#				dev.off()
#			}
#		}
#	}
}
##### plot 2: hist  #############
draw.affy.hist <- function(){
	bitmap(paste(graphDir,title.affy.hist,'.png', sep=''), width=8,height=8)
	try(hist(Data), TRUE);
	dev.off()
}
##### plot 3: image  ############
draw.affy.image <- function(){
    for(i in 1:Num.of.Slides){
		bitmap(paste(graphDir,title.affy.image,'.',i,'.png', sep=''), width=6,height=4)
		try(image(Data[,i]), TRUE);
		dev.off()
	}
}
##### plot 4: boxplot  ##########
draw.affy.boxplot <- function(){
	bitmap(paste(graphDir,title.affy.boxplot,'.png', sep=''), width=8,height=8)
	par(mfrow = c(1,1))
	try(boxplot(Data, col= c(2,3,4)), TRUE);
	dev.off()
}
##### plot 5: RNA degredation  ##
draw.affy.RNAdeg <- function(){
	bitmap(paste(graphDir,title.affy.RNAdeg,'.png', sep=''), width=8,height=8)
	deg <- AffyRNAdeg(Data)
	try(plotAffyRNAdeg(deg), TRUE);
	dev.off()
}

affy.drawCharts <- function() {
	##  save R image parameter
	op<-par(no.readonly=TRUE)
	if(plot.affy.image == TRUE) draw.affy.image()
	if(plot.affy.hist == TRUE) draw.affy.hist()
	if(plot.affy.MAplot == TRUE) draw.affy.MAplot()
	if(plot.affy.RNAdeg == TRUE) draw.affy.RNAdeg()
	if(plot.affy.boxplot == TRUE) draw.affy.boxplot()
	##  Recover R chart parameters
	par(op)
}

affy.Main <- function() {
	addNamePrefix()
	affy.readIntensity()
	print('after reading intensity')
	readGeneLoc()
	if(!identical(analysis, "normalization"))
		affy.makeDesign()
	
	print('after makeDesign')
	#prepareData()
	setwd(result.data.dir)
	expressionMeasure()
	print('after expressionMeasure')
	if(identical(analysis, "normalization")){
		affy.normalizeOnly()
		print('after normalizeOnly')
	}else {
		affy.analyze()
		print('after analyze')
	}

	affy.drawCharts()	
	print('after drawCharts')
	setwd(wd)
}

affy.Main()
##########################    Change Back File Path      ##############
setwd(wd)
rm(list=ls())
################################################################################
#############################    End of code    ################################
################################################################################
