#!/usr/bin/env python

import os, random, time

# some egg package need a cache directory. usually it is at users' home. but for apache you have to set up one with writting permission
#os.putenv('PYTHON_EGG_CACHE', '/var/tmp/.python-eggs') # putenv doest take effect immediately.
os.environ['PYTHON_EGG_CACHE'] = '/var/tmp/.python-eggs' #Note: On some platforms, including FreeBSD and Mac OS X, setting environ may cause memory leaks

def UniqueNameWithinListSeq(prefix='', suffix='', names=[], num_len=4, start_num=0): # name can be a directory or a list of names
	i = start_num
	tmpname = prefix + str(i).zfill(num_len) + suffix
	if type(names) in (type(''), type(u'')):
		names = os.listdir(names)
		#while os.path.exists(os.path.join(dir ,tmpname)):
		#	i = i+1
		#	tmpname = prefix + str(i).zfill(num_len) + suffix
	# dir must be list
	while tmpname in names:
		i = i+1
		tmpname = prefix + str(i).zfill(num_len) + suffix
	return tmpname


def UniqueNameSeq(prefix='', suffix='', dir='.', num_len=4, start_num=0):
	i = start_num
	tmpname = prefix + str(i).zfill(num_len) + suffix
	while os.path.exists(os.path.join(dir ,tmpname)):
		i = i+1
		tmpname = prefix + str(i).zfill(num_len) + suffix
	return tmpname

def TmpUniqueNameSeq(prefix='tmp', suffix='.tmp', dir='.', num_len=4, start_num=0):
	return UniqueNameSeq(prefix=prefix, suffix=suffix, dir=dir, num_len=num_len, start_num=start_num)

def UniqueNameWithinListRand(prefix='', suffix='', names='.', num_len=6): # names can be a directory or a list of names
	tmpname = prefix + str(int(random.random()*10**num_len)).zfill(num_len) + suffix
	if type(dir) in (type(''), type(u'')):
		names = os.listdir(names)
	while tmpname in names: #os.path.exists(os.path.join(dir ,tmpname)):
		tmpname = prefix + str(int(random.random()*10**num_len)).zfill(num_len) + suffix
	return tmpname

def UniqueNameRand(prefix='', suffix='', dir='.', num_len=6):
	tmpname = prefix + str(int(random.random()*10**num_len)).zfill(num_len) + suffix
	while os.path.exists(os.path.join(dir ,tmpname)):
		tmpname = prefix + str(int(random.random()*10**num_len)).zfill(num_len) + suffix
	return tmpname

def TmpUniqueNameRand(prefix='tmp', suffix='.tmp', dir='.', num_len=6):
	return UniqueNameRand(prefix=prefix, suffix=suffix, dir=dir, num_len=num_len)

def ExpDesign(chs):
	design = []
	error_msg = ""
	error_design = 'Error in the experiment design!'
	has_ref = None
	if len(chs) < 2: error_msg = error_design
	else:
		#has_ref = None
		for k in chs: # check if there two channels are the same (-- that is not correct)
			if k[0] == k[1]:
				error_msg = error_design
				break
		if not error_msg:
			for k in chs:
				if 'Reference' in k:
					has_ref = 1
					break
			if not has_ref: # no reference
				for k in chs:
					if k[0] == 'Control': # then k[1] must be 'Experiment'
						design.append(1)
					else: design.append(-1)
			else: # has reference
				for k in chs: 
					if "Reference" not in k: # all slides should have reference
						error_msg = error_design
						break
				if not error_msg: 
					for k in chs:
						if 'Experiment' in k: design.append((1,1))
						else:	design.append((1,0))
					pass # here need further work to check the order of Experiment/Control and Reference
				error_msg = error_design # disable Reference since the R code cannot deal with it at present
	return {"error_msg" : error_msg, "design" : design, "has_reference" : has_ref}
	
class Log:
	"""file like for writes with auto flush after each write
	to ensure that everything is logged, even during an
	unexpected exit."""
	MAX_SIZE = 1000000
	def __init__(self, f):
		if type(f) is type(''):
			self.name = f
			self.f = open(f, 'a+')
		else:
			self.f = f
			self.name = f.name
		i = os.path.basename(self.name).find('.')
		if i < 0:
			self.back_name = self.name+'_1'
		else:
			i = self.name.rfind('.') 
			self.back_name = self.name[:i]+'_1'+self.name[i:]
		self.limitSize()
	def write(self, s):
		self.limitSize()
		self.f.write(s)
		self.f.flush()
	def limitSize(self):
		self.f.seek(0,2)
		size = self.f.tell()
		if size > self.MAX_SIZE:
			#import shutil
			#shutil.copyfile(self.name, self.back_name)
			self.f.close()
			if os.path.exists(self.back_name): os.remove(self.back_name)
			os.rename(self.name, self.back_name)
			self.f = open(self.name, 'a+')
			#self.f.truncate(0)
			#self.f.flush()


import re, md5
from Crypto.Cipher import RC5
from base64 import encodestring, decodestring
#from binascii import b2a_hex
rc5_passwd = "anything"
rc5 = RC5.new(rc5_passwd, RC5.MODE_ECB)
esc_char = '_' # didn't use now
avoid_chars = [] # didn't use now
def encodeStr(file_path):
	#return file_path
	ln_add = 8 - len(file_path) % 8
	file_path = ln_add and 'X'*ln_add+file_path or file_path
	file_path = encodestring(rc5.encrypt(file_path)+str(ln_add))
	file_path = file_path[:-1] # to remove the trailing newline character ('\n') added by encodestring
	file_path = re.sub('_', '__', file_path)
	#file_path = re.sub(r'\s|=|/|\\', lambda m:'_'+ hex(ord(m.group(0)))[2:].zfill(2), file_path)
	file_path = re.sub(r'''\s|=|/|\\|\?|\*|\{|\}|,|:|'|"|;''', lambda m:'_'+ hex(ord(m.group(0)))[2:].zfill(2), file_path)

	return file_path

def decodeStr(file_name):
	#return file_name
	#file_name = re.sub(r'(?:(?<=^)|(?<=[^_]))(_[0-9a-fA-F]{2})', lambda m:m and chr(int(m.groups()[0][1:], 16)) or '', file_name)
	#file_name = re.sub(r'((?:__)+)(_[0-9a-fA-F]{2})', lambda m:m and m.groups()[0]+chr(int(m.groups()[1][1:], 16)) or '', file_name)
	file_name = re.sub(r'(?:(?<=^)|(?<!_))(_[0-9a-fA-F]{2})', lambda m:m and chr(int(m.groups()[0][1:], 16)) or '', file_name)
	file_name = re.sub(r'([^_](?:__)+)(_[0-9a-fA-F]{2})', lambda m:m and m.groups()[0]+chr(int(m.groups()[1][1:], 16)) or '', file_name)
	file_name = re.sub(r'([^_|^](?:__)*)(_[0-9a-fA-F]{2})', lambda m:m and m.groups()[0]+chr(int(m.groups()[1][1:], 16)) or '', file_name)
	file_name = re.sub(r'(__)', '_', file_name)

	file_name = decodestring(file_name+'\n') # restore the trailing '\n' added by encodestring
	ln_add = int(file_name[-1])
	file_name = rc5.decrypt(file_name[:-1])
	return ln_add and file_name[ln_add:] or file_name

def ascMd5(src):
	obj = repr(md5.md5(srctab_str = re.compile(r'((?<=[^\\])\\t)|(^\\t)')).digest())
	obj = encodestring(obj)
	obj = re.sub('_', '__', obj)
	obj = re.sub('\s', lambda m:'_'+hex(ord(m.group(0)))[2:].zfill(2), obj)
	return obj

def myMD5(src):
	obj = md5.md5(src).digest()
	return obj.replace('"','2').replace("'",'1')


esc_tab_str = re.compile(r'(\\\\)*\\t')  # the number of '\' before '\t' should be even
esc_line_str = re.compile(r'(\\\\)*\\n')
esc_str = re.compile(r'\\\\')

def escNT(s): # use escape for TAB and NEW LINE (and of course backslash too)
	return ((type(s) is type('')) and (s.replace('\\', '\\\\').replace('\n', '\\n').replace('\t', '\\t'), ) or (s,))[0]

def descNT(s): # reverse escNT
	#return ((type(s) is type('')) and (esc_str.sub('\\', line_str.sub('\n', tab_str.sub('\t',a))),) or (s,))[0]
	return ((type(s) is type('')) and (esc_str.sub(r'\\', esc_line_str.sub(r'\1\n', esc_tab_str.sub(r'\1\t', s))),) or (s,))[0]


	
########### Databases functions  ##############
import MySQLdb

DB_SRC = 'DBSRC'
DB_OBJ = 'DB'
DB_EXAMPLE='DBSRC_EXAMPLE'

def encodeDB(s='', DB_OBJ=DB_OBJ, DB_SRC=DB_SRC, RM_SRC=True):
	if s: open(DB_OBJ, 'w').write(encodeStr(s))
	elif os.path.exists(DB_SRC): 
		encoded_str = encodeStr(open(DB_SRC).read())
		open(DB_OBJ, 'w').write(encoded_str)
		if RM_SRC: os.unlink(DB_SRC)

def decodeDB(s='', DB_OBJ=DB_OBJ, DB_SRC=DB_SRC, RM_OBJ=False):
	if s: open(DB_SRC, 'w').write(decodeStr(s))
	elif os.path.exists(DB_OBJ):
		file(DB_SRC, 'w').write(decodeStr(file(DB_OBJ).read()))
		if RM_OBJ: os.unlink(DB_OBJ)

def get_dbstr(DB_SRC = DB_SRC, DB_OBJ = DB_OBJ, DB_EXAMPLE = DB_EXAMPLE, dbstr_encoded = True):		
	if os.path.exists(DB_SRC): 
		dbstr = open(DB_SRC).read()
		try: encodeDB(DB_OBJ=DB_OBJ, DB_SRC=DB_SRC)
		except: pass
	else: 
		if os.path.exists(DB_OBJ): 
			dbstr = decodeStr(open(DB_OBJ).read())
			db_str_encoded = False
		else: 
			# now search in the directory of tools.py
			wd = os.path.split(os.path.realpath(__file__))[0]
			DB_SRC_LAST = os.path.join(wd, DB_SRC)
			DB_OBJ_LAST = os.path.join(wd, DB_OBJ)
			if wd != os.path.realpath(os.getcwd()):
				if os.path.exists(DB_SRC_LAST): 
					dbstr = open(DB_SRC_LAST).read()
					try: encodeDB(DB_SRC=DB_SRC_LAST, DB_OBJ=os.path.join(wd, DB_OBJ))
					except: pass
				elif os.path.exists(DB_OBJ_LAST): 
					dbstr = decodeStr(open(DB_OBJ_LAST).read()) 
				else:
					DB_EX = os.path.join(wd, DB_EXAMPLE)
					if os.path.exists(DB_EX):
						dbstr = file(DB_EX).read()
					else: pass  # pass here may cause problem if one use DB functions while no DB information offered
			else:
				DB_EX = os.path.join(wd, DB_EXAMPLE)
				if os.path.exists(DB_EX):
					dbstr = file(DB_EX).read()
				else: pass  # pass here may cause problem if one use DB functions while no DB information offered


	return dbstr

def connectDB():
	exec get_dbstr()
	return MySQLdb.connect(host=host, db=db, port=port, user=user, passwd=passwd)
	
def getConnectionCursor():
	exec get_dbstr()
	connection = MySQLdb.connect(host=host, db=db, port=port, user=user, passwd=passwd)
	cursor = connection.cursor()
	return connection, cursor

TOOLS_LOG = os.path.join(os.path.split(os.path.realpath(__file__))[0], 'tools.log')
def inquireDB(sql_statement, cursor=None, connection=None, fetch=False):
	if cursor:
		close_cursor = False
	else:
		if connection: 
			cursor = connection.cursor()
			close_connection = False
		else: 
			connection, cursor = getConnectionCursor()
			close_connection = True
		close_cursor = True
	try:
		rlt = cursor.execute(sql_statement)
	except:
		# save sql_statement
		Log(TOOLS_LOG).write('\n\n%s\n\t%s' % (time.strftime('%Y-%m-%d %H:%M:%S', time.gmtime()), sql_statement))
		raise
	if fetch: rlt = rlt and cursor.fetchall() or [] #None
	if close_cursor:
		cursor.close()
		if close_connection: connection.close()
	return rlt

