/*
 * Decompiled with CFR 0.152.
 */
package jmaster.jumploader.view.impl.image;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import jmaster.jumploader.model.api.B;
import jmaster.jumploader.model.api.config.ImageConfig;
import jmaster.jumploader.view.impl.image.ImageControlListener;
import jmaster.jumploader.view.impl.image.RectangleRubberBand;
import jmaster.util.swing.GUIHelper;

public class ImageControl
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final long B = -6171717419492647594L;
    public static final String F = "imageControl";
    protected GUIHelper O = GUIHelper.getInstance();
    protected B G;
    protected Vector N = new Vector();
    protected RectangleRubberBand Q;
    protected Double J = null;
    protected Integer D = null;
    protected Integer K = null;
    protected JLabel P = new JLabel();
    protected BufferedImage C;
    protected int M;
    protected int H;
    protected double A = 1.0;
    protected Point I = null;
    protected boolean E = false;
    protected Image L;

    public ImageControl(B b2) {
        this.G = b2;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.O.injectProperties(this, F);
        this.O.injectProperties(this.P, F, "emptyControlLabel");
        this.P.setHorizontalAlignment(0);
    }

    public void init() {
        this.init(true);
    }

    public void init(boolean bl) {
        this.setPreferredSize(new Dimension((int)((double)this.M * this.A), (int)((double)this.H * this.A)));
        if (bl) {
            this.Q = null;
            this.B(null);
        }
        this.revalidate();
        this.repaint();
    }

    public void addImageControlListener(ImageControlListener imageControlListener) {
        this.N.add(imageControlListener);
    }

    public void removeImageControlListener(ImageControlListener imageControlListener) {
        this.N.remove(imageControlListener);
    }

    private void B(RectangleRubberBand rectangleRubberBand) {
        Iterator iterator = this.N.iterator();
        while (iterator.hasNext()) {
            ImageControlListener imageControlListener = (ImageControlListener)iterator.next();
            imageControlListener.rectangleRubberBandChanged(this, rectangleRubberBand);
        }
    }

    public BufferedImage getImage() {
        return this.C;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.C = bufferedImage;
        if (bufferedImage != null) {
            this.M = bufferedImage.getWidth();
            this.H = bufferedImage.getHeight();
        } else {
            this.M = 0;
            this.H = 0;
        }
        this.init();
    }

    public void discardImage() {
        this.C = null;
        this.M = 0;
        this.H = 0;
        this.init();
    }

    public double getZoomFactor() {
        return this.A;
    }

    public void setZoomFactor(double d2) {
        this.A = d2;
        this.init(false);
    }

    public int getImageHeight() {
        return this.H;
    }

    public int getImageWidth() {
        return this.M;
    }

    public RectangleRubberBand getBand() {
        return this.Q;
    }

    public void setBandCoords(int n2, int n3, int n4, int n5) {
        if (this.Q == null) {
            this.Q = this.A();
        } else {
            this.A(this.Q);
        }
        this.Q.setCoords(n2, n3, n4, n5);
        this.A(this.Q);
    }

    public boolean isWaitMode() {
        return this.E;
    }

    public void setWaitMode(boolean bl) {
        this.E = bl;
    }

    public Image getWaitImage() {
        return this.L;
    }

    public void setWaitImage(Image image) {
        this.L = image;
    }

    public Integer getBandPerimeterMax() {
        return this.K;
    }

    public void setBandPerimeterMax(Integer n2) {
        this.K = n2;
    }

    public Integer getBandPerimeterMin() {
        return this.D;
    }

    public void setBandPerimeterMin(Integer n2) {
        this.D = n2;
    }

    public Double getBandProportions() {
        return this.J;
    }

    public void setBandProportions(Double d2) {
        this.J = d2;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.C != null) {
            graphics.drawImage(this.C, 0, 0, (int)((double)this.M * this.A), (int)((double)this.H * this.A), 0, 0, this.M, this.H, null);
            if (this.Q != null) {
                this.A((Graphics2D)graphics, this.Q);
            }
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.P.setBounds(this.getBounds());
            this.P.paint(graphics);
        }
    }

    protected void A(RectangleRubberBand rectangleRubberBand) {
        this.A(null, rectangleRubberBand);
    }

    protected synchronized void A(Graphics2D graphics2D, RectangleRubberBand rectangleRubberBand) {
        if (graphics2D == null) {
            graphics2D = (Graphics2D)this.getGraphics();
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.setXORMode(Color.WHITE);
        graphics2D.setStroke(RectangleRubberBand._);
        if (rectangleRubberBand.getWidth() == 0 || rectangleRubberBand.getHeight() == 0) {
            System.out.println("!");
        }
        Point point = this.imageToScreen(rectangleRubberBand.getLeftTop());
        Point point2 = this.imageToScreen(rectangleRubberBand.getRightBottom());
        point2.setLocation(point2.getX() + this.A - 1.0, point2.getY() + this.A - 1.0);
        double d2 = point2.getX() - point.getX();
        double d3 = point2.getY() - point.getY();
        graphics2D.drawRect((int)point.getX(), (int)point.getY(), (int)d2, (int)d3);
        graphics2D.setStroke(RectangleRubberBand.T);
        for (int i2 = 0; i2 < 8; ++i2) {
            int n2 = (int)(RectangleRubberBand.P[i2] * d2 + point.getX() - 3.0);
            int n3 = (int)(RectangleRubberBand.a[i2] * d3 + point.getY() - 3.0);
            graphics2D.drawRect(n2, n3, 6, 6);
        }
    }

    public Point screenToImage(Point point) {
        int n2;
        int n3 = (int)(point.getX() / this.A);
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= this.M) {
            n3 = this.M - 1;
        }
        if ((n2 = (int)(point.getY() / this.A)) < 0) {
            n2 = 0;
        }
        if (n2 >= this.H) {
            n2 = this.H - 1;
        }
        return new Point(n3, n2);
    }

    public Point imageToScreen(Point point) {
        Point point2 = new Point();
        point2.setLocation(point.getX() * this.A, point.getY() * this.A);
        return point2;
    }

    public boolean isImagePoint(Point point) {
        return this.C != null && point.getX() >= 0.0 && point.getY() >= 0.0 && point.getX() < (double)this.M && point.getY() < (double)this.H;
    }

    public Rectangle getBandScreenRectangle(RectangleRubberBand rectangleRubberBand) {
        Point point = this.imageToScreen(rectangleRubberBand.getLeftTop());
        Point point2 = this.imageToScreen(rectangleRubberBand.getRightBottom());
        point2.setLocation(point2.getX() + this.A - 1.0, point2.getY() + this.A - 1.0);
        Rectangle rectangle = new Rectangle(point);
        rectangle.add(point2);
        return rectangle;
    }

    private boolean A(RectangleRubberBand rectangleRubberBand, Point point) {
        Rectangle rectangle = this.getBandScreenRectangle(rectangleRubberBand);
        return rectangle.contains(point);
    }

    private int B(RectangleRubberBand rectangleRubberBand, Point point) {
        int n2 = -1;
        for (int i2 = 0; i2 < 8; ++i2) {
            Rectangle rectangle = this.A(rectangleRubberBand, i2);
            if (!rectangle.contains(point)) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    private Rectangle A(RectangleRubberBand rectangleRubberBand, int n2) {
        Point point = this.imageToScreen(rectangleRubberBand.getLeftTop());
        Point point2 = this.imageToScreen(rectangleRubberBand.getRightBottom());
        point2.setLocation(point2.getX() + this.A - 1.0, point2.getY() + this.A - 1.0);
        double d2 = point2.getX() - point.getX();
        double d3 = point2.getY() - point.getY();
        int n3 = (int)(RectangleRubberBand.P[n2] * d2 + point.getX() - 3.0);
        int n4 = (int)(RectangleRubberBand.a[n2] * d3 + point.getY() - 3.0);
        return new Rectangle(n3, n4, 6, 6);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point point;
        if (this.Q != null) {
            int n2 = this.B(this.Q, mouseEvent.getPoint());
            if (n2 != -1) {
                this.Q.setHotAnchorId(n2);
                this.Q.setStatus(1);
            } else if (this.A(this.Q, mouseEvent.getPoint())) {
                this.Q.setStatus(2);
                this.setCursor(RectangleRubberBand.F);
                point = this.imageToScreen(this.Q.getLeftTop());
                this.I = new Point((int)((double)mouseEvent.getX() - point.getX()), (int)((double)mouseEvent.getY() - point.getY()));
            }
        }
        if (this.Q == null || this.Q.getStatus() == 0) {
            Point point2;
            if (this.Q != null) {
                this.A(this.Q);
            }
            if (this.isImagePoint(point = this.screenToImage(point2 = mouseEvent.getPoint()))) {
                this.Q = this.A();
                this.Q.setPoint0(point);
                this.Q.setPoint1(this.Q.getPoint0());
                this.Q.setStatus(1);
                this.Q.setHotAnchorId(4);
                this.A(this.Q);
            }
        }
    }

    private RectangleRubberBand A() {
        RectangleRubberBand rectangleRubberBand = new RectangleRubberBand();
        ImageConfig imageConfig = this.G.H();
        if (imageConfig.getCropPerimeterMin() != null) {
            rectangleRubberBand.setPerimeterMin(new Integer(imageConfig.getCropPerimeterMin()));
        }
        if (imageConfig.getCropRatio() != null) {
            rectangleRubberBand.setProportions(new Double(imageConfig.getCropRatio()));
        }
        return rectangleRubberBand;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.Q != null) {
            this.Q.setStatus(0);
            if (this.Q.getWidth() == 0 && this.Q.getHeight() == 0) {
                this.A(this.Q);
                this.Q = null;
            }
            this.B(this.Q);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.Q != null && this.Q.getStatus() != 0) {
            int n2;
            int n3;
            int n4 = this.Q.getX0();
            int n5 = this.Q.getY0();
            int n6 = this.Q.getX1();
            int n7 = this.Q.getY1();
            block0 : switch (this.Q.getStatus()) {
                case 2: {
                    Point point = new Point((int)((double)mouseEvent.getX() - this.I.getX()), (int)((double)mouseEvent.getY() - this.I.getY()));
                    Point point2 = this.screenToImage(point);
                    n3 = (int)(point2.getY() + (double)this.Q.getHeight());
                    for (n2 = (int)(point2.getX() + (double)this.Q.getWidth()); n2 >= this.M; --n2) {
                    }
                    while (n3 >= this.H) {
                        --n3;
                    }
                    point2.setLocation(n2 - this.Q.getWidth(), n3 - this.Q.getHeight());
                    this.Q.setPoint0(point2);
                    this.Q.setPoint1(new Point(n2, n3));
                    break;
                }
                case 1: {
                    Point point = this.screenToImage(mouseEvent.getPoint());
                    switch (this.Q.getHotAnchorId()) {
                        case 0: 
                        case 2: 
                        case 4: 
                        case 6: {
                            this.Q.setPoint1(point);
                            break block0;
                        }
                        case 3: 
                        case 7: {
                            this.Q.setX1((int)point.getX());
                            break block0;
                        }
                        case 1: 
                        case 5: {
                            this.Q.setY1((int)point.getY());
                        }
                    }
                }
            }
            if (n4 != this.Q.getX0() || n5 != this.Q.getY0() || n6 != this.Q.getX1() || n7 != this.Q.getY1()) {
                int n8 = this.Q.getX0();
                int n9 = this.Q.getY0();
                n2 = this.Q.getX1();
                n3 = this.Q.getY1();
                this.Q.setCoords(n4, n5, n6, n7);
                this.A(this.Q);
                this.Q.setCoords(n8, n9, n2, n3);
                this.A(this.Q);
            }
            this.B(this.Q);
        }
        Rectangle rectangle = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 1, 1);
        this.scrollRectToVisible(rectangle);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.Q != null) {
            int n2 = this.B(this.Q, mouseEvent.getPoint());
            if (n2 != -1) {
                this.setCursor(RectangleRubberBand.J[n2]);
            } else if (this.A(this.Q, mouseEvent.getPoint())) {
                this.setCursor(RectangleRubberBand.K);
            } else {
                this.setCursor(RectangleRubberBand.L);
            }
        }
    }
}

