/*
 * Decompiled with CFR 0.152.
 */
package jmaster.jumploader.view.impl.upload.list;

import [Ljmaster.jumploader.model.api.upload.IUploadFile;;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.TooManyListenersException;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import jmaster.jumploader.model.api.A.C;
import jmaster.jumploader.model.api.config.ViewConfig;
import jmaster.jumploader.model.api.upload.IUploadFile;
import jmaster.jumploader.model.api.upload.IUploader;
import jmaster.jumploader.view.api.main.IMainView;
import jmaster.jumploader.view.impl.upload.list.IUploadFileListListener;
import jmaster.jumploader.view.impl.upload.list.UploadFileListCellRenderer;
import jmaster.jumploader.view.impl.upload.list.UploadFileListModel;
import jmaster.jumploader.view.impl.upload.list.dnd.FileDropListener;
import jmaster.jumploader.view.impl.upload.list.dnd.IFileDropTarget;
import jmaster.jumploader.view.impl.upload.list.dnd.UploadFileListTransferHandler;
import jmaster.jumploader.view.impl.upload.list.dnd.UploadFileTransferable;
import jmaster.util.B.A;
import jmaster.util.B.B;
import jmaster.util.swing.easylist.EasyList;

public class UploadFileList
extends EasyList
implements jmaster.jumploader.model.api.upload.B,
Runnable,
IFileDropTarget,
KeyListener {
    private static final long \u00b5 = 9017089770972464908L;
    private static final String \u00c1 = "uploadFileList";
    private static final String \u00c5 = "uploadFileListUpdater";
    private static final long \u00c0 = 100L;
    private IUploader \u00c3;
    protected A \u00c4 = new A(IUploadFileListListener.class);
    private UploadFileListModel \u00c2;
    private Thread \u00aa;
    private long \u00ba = 100L;
    private DropTarget \u00a5;
    private int \u00c7 = -1;
    private Icon \u00c6;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UploadFileList(jmaster.jumploader.model.api.B b2, IMainView iMainView) {
        ViewConfig viewConfig = b2.F();
        this.setModel(new UploadFileListModel(b2));
        this.\u00c3 = b2.C();
        this.\u00c2 = (UploadFileListModel)super.getModel();
        this.\u00a2 = new UploadFileListCellRenderer(b2, iMainView);
        this.setCellRenderer((ListCellRenderer)this.\u00a2);
        this.setLayoutOrientation(2);
        String string = \u00c1 + (viewConfig.getUploadListViewName() == null ? "" : viewConfig.getUploadListViewName());
        this.t.injectProperties(this, string);
        this.t.injectProperties(this.v, string, "emptyListLabel");
        this.addKeyListener(this);
        this.\u00c3.addListener(this);
        this.setTransferHandler(new UploadFileListTransferHandler());
        this.setDragEnabled(b2.B().isUploadQueueReorderingAllowed());
        this.\u00a5 = new DropTarget();
        this.setDropTarget(this.\u00a5);
        this.\u00a5.setComponent(this);
        this.\u00a5.setActive(this.\u00c3.isFileAdditionEnabled());
        try {
            this.\u00a5.addDropTargetListener(new FileDropListener(this));
        }
        catch (TooManyListenersException tooManyListenersException) {
            tooManyListenersException.printStackTrace();
        }
        this.\u00aa = new Thread(this);
        this.\u00aa.setName(\u00c5);
        this.\u00aa.setDaemon(true);
        this.\u00aa.start();
        this.updateView();
    }

    public long getUpdateInterval() {
        return this.\u00ba;
    }

    public void setUpdateInterval(long l2) {
        this.\u00ba = l2;
    }

    public Icon getInsertIcon() {
        return this.\u00c6;
    }

    public void setInsertIcon(Icon icon) {
        this.\u00c6 = icon;
    }

    public void addListener(IUploadFileListListener iUploadFileListListener) {
        this.\u00c4.C(iUploadFileListListener);
    }

    public void removeListener(IUploadFileListListener iUploadFileListListener) {
        this.\u00c4.A(iUploadFileListListener);
    }

    private void A(IUploadFile[] iUploadFileArray) {
        for (int i2 = 0; i2 < this.\u00c4.C(); ++i2) {
            IUploadFileListListener iUploadFileListListener = (IUploadFileListListener)this.\u00c4.A(i2);
            iUploadFileListListener.uflRemoveFilesAction(this, iUploadFileArray);
        }
    }

    private void A(String[] stringArray) {
        for (int i2 = 0; i2 < this.\u00c4.C(); ++i2) {
            IUploadFileListListener iUploadFileListListener = (IUploadFileListListener)this.\u00c4.A(i2);
            iUploadFileListListener.uflAddFilesAction(this, stringArray);
        }
    }

    public void uploaderFileAdditionEnabledChanged(IUploader iUploader) {
        this.\u00a5.setActive(iUploader.isFileAdditionEnabled());
    }

    public void uploaderFileRemovalEnabledChanged(IUploader iUploader) {
    }

    public void uploaderFileAdded(IUploader iUploader, IUploadFile iUploadFile) {
        this.updateView();
    }

    public void uploaderFileRemoved(IUploader iUploader, IUploadFile iUploadFile) {
        this.updateView();
    }

    public void uploaderFileMoved(IUploader iUploader, IUploadFile iUploadFile, int n2) {
        this.updateView();
    }

    public void uploaderFileStatusChanged(IUploader iUploader, IUploadFile iUploadFile) {
    }

    public void uploaderFilesReset(IUploader iUploader) {
        this.updateView();
    }

    public void uploaderStatusChanged(IUploader iUploader) {
    }

    public void uploaderUploadEnabledChanged(IUploader iUploader) {
    }

    public void uploaderFileAddFailed(IUploader iUploader, C c2) {
    }

    public void uploaderFileUpdated(IUploader iUploader, IUploadFile iUploadFile) {
        this.updateView();
    }

    public void run() {
        while (this.\u00aa != null) {
            this.updateUploadingCells();
            try {
                Thread.sleep(this.\u00ba);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        IUploadFile[] iUploadFileArray;
        if (keyEvent.getKeyCode() == 127 && (iUploadFileArray = this.getSelectedFiles()) != null) {
            this.A(iUploadFileArray);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.\u00c7 != -1) {
            this.\u00c7 = -1;
            this.repaint();
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(UploadFileTransferable.getDataFlavor())) {
            Rectangle rectangle;
            int n2 = 0;
            Point point = dropTargetDragEvent.getLocation();
            int n3 = this.getCellAtLocation(point);
            if (n3 == -1) {
                rectangle = this.getVisibleRect();
                while (n3 == -1 && rectangle.contains(point)) {
                    n3 = this.getCellAtLocation(point);
                    --point.x;
                }
            }
            n2 = n3 != -1 ? ((rectangle = this.getCellBounds(n3, n3)).getCenterX() > (double)point.x ? n3 : n3 + 1) : this.getModel().getSize();
            if (n2 != this.\u00c7) {
                this.\u00c7 = n2;
                this.w.D("cell=" + n3 + ", insertIndex=" + this.\u00c7);
                this.repaint();
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (this.\u00c7 != -1) {
            this.\u00c7 = -1;
            this.repaint();
        }
    }

    public void filesDropped(File[] fileArray) {
        if (this.\u00c7 != -1) {
            this.\u00c7 = -1;
            this.repaint();
        }
        String[] stringArray = new String[fileArray.length];
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            stringArray[i2] = fileArray[i2].getAbsolutePath();
        }
        this.A(stringArray);
    }

    public void moveFiles(IUploadFile[] iUploadFileArray) {
        if (!$assertionsDisabled && this.\u00c7 == -1) {
            throw new AssertionError();
        }
        try {
            B.B(this.\u00c3, "moveFiles", new Class[]{IUploadFile;.class, Integer.TYPE}, new Object[]{iUploadFileArray, new Integer(this.\u00c7)});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.\u00c7 != -1) {
            this.\u00c7 = -1;
            this.repaint();
        }
    }

    public void updateUploadingCells() {
        if (!B.A()) {
            B.B(this, "updateUploadingCells");
            return;
        }
        for (int i2 = 0; i2 < this.\u00c2.getSize(); ++i2) {
            IUploadFile iUploadFile = this.\u00c2.getUploadFile(i2);
            if (!iUploadFile.isUploading() && !iUploadFile.isPreprocessing() && !iUploadFile.isServerProcessing()) continue;
            this.repaintCell(i2);
        }
    }

    public IUploadFile[] getSelectedFiles() {
        IUploadFile[] iUploadFileArray = null;
        int[] nArray = this.getSelectedIndices();
        if (nArray != null && nArray.length > 0) {
            iUploadFileArray = new IUploadFile[nArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                iUploadFileArray[i2] = this.\u00c2.getUploadFile(nArray[i2]);
            }
        }
        return iUploadFileArray;
    }

    public void updateView() {
        if (!B.A()) {
            B.A(this);
            return;
        }
        this.setBackgroundVisible(this.getModel().getSize() == 0);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.\u00c7 != -1 && this.\u00c6 != null) {
            Rectangle rectangle = null;
            int n2 = 0;
            int n3 = 0;
            if (this.\u00c7 < this.\u00c2.getSize()) {
                rectangle = this.getCellBounds(this.\u00c7, this.\u00c7);
                n2 = rectangle.x - this.\u00c6.getIconWidth() / 2;
                n3 = rectangle.y + rectangle.height / 2 - this.\u00c6.getIconHeight() / 2;
            } else {
                rectangle = this.getCellBounds(this.\u00c2.getSize() - 1, this.\u00c2.getSize() - 1);
                n2 = rectangle.x + rectangle.width - this.\u00c6.getIconWidth() / 2;
                n3 = rectangle.y + rectangle.height / 2 - this.\u00c6.getIconHeight() / 2;
            }
            this.w.D("i=" + this.\u00c7 + ", x=" + n2 + ", y=" + n3 + ", b=" + rectangle);
            this.\u00c6.paintIcon(this, graphics, n2, n3);
            int n4 = -1;
            int n5 = -1;
            if (this.\u00c7 > 0 && this.\u00c7 < this.\u00c2.getSize()) {
                rectangle = this.getCellBounds(this.\u00c7 - 1, this.\u00c7 - 1);
                n4 = rectangle.x + rectangle.width - this.\u00c6.getIconWidth() / 2;
                n5 = rectangle.y + rectangle.height / 2 - this.\u00c6.getIconHeight() / 2;
            }
            if (n4 != -1 && n5 != -1 && n2 != n4 && n3 != n5) {
                this.\u00c6.paintIcon(this, graphics, n4, n5);
            }
        }
    }

    static {
        $assertionsDisabled = !UploadFileList.class.desiredAssertionStatus();
    }
}

