/*
 * Decompiled with CFR 0.152.
 */
package jmaster.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jmaster.util.B.B;
import jmaster.util.property.D;

public class SwingUtil {
    public static final String C = "fireTableDataChanged";
    public static final String D = "fireTableRowsInserted";
    public static final String A = "fireTableRowsDeleted";
    public static final String B = "fireTableRowsUpdated";

    public static void centerParent(Component component) {
        Container container = component.getParent();
        Point point = container.getLocationOnScreen();
        Dimension dimension = container.getSize();
        Dimension dimension2 = component.getSize();
        int n2 = dimension.width > dimension2.width ? (dimension.width - dimension2.width) / 2 + point.x : point.x;
        int n3 = dimension.height > dimension2.height ? (dimension.height - dimension2.height) / 2 + point.y : point.y;
        component.setLocation(n2, n3);
    }

    public static Frame getParentFrame(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        if (container instanceof Frame) {
            return (Frame)container;
        }
        return SwingUtil.getParentFrame(container);
    }

    public static JFrame getParentJFrame(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        if (container instanceof JFrame) {
            return (JFrame)container;
        }
        return SwingUtil.getParentJFrame(container);
    }

    public static JApplet getParentJApplet(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        if (container instanceof JApplet) {
            return (JApplet)container;
        }
        return SwingUtil.getParentJApplet(container);
    }

    public static void reloadTreeNode(final DefaultTreeModel defaultTreeModel, final TreeNode treeNode) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        defaultTreeModel.reload(treeNode);
                    }
                });
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException(exception);
            }
        } else {
            defaultTreeModel.reload(treeNode);
        }
    }

    public void setNativeLookAndFeel() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        if (!jmaster.util.B.B.A()) {
            jmaster.util.B.B.B(this, "setNativeLookAndFeel");
            return;
        }
        String string = UIManager.getSystemLookAndFeelClassName();
        UIManager.setLookAndFeel(string);
    }

    public static void fireTableRowsInserted(AbstractTableModel abstractTableModel, int n2, int n3) {
        if (!jmaster.util.B.B.A()) {
            jmaster.util.B.B.C(abstractTableModel, D, new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n2), new Integer(n3)});
        } else {
            abstractTableModel.fireTableRowsInserted(n2, n3);
        }
    }

    public static void fireTableRowsDeleted(AbstractTableModel abstractTableModel, int n2, int n3) {
        if (!jmaster.util.B.B.A()) {
            jmaster.util.B.B.C(abstractTableModel, A, new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n2), new Integer(n3)});
        } else {
            abstractTableModel.fireTableRowsDeleted(n2, n3);
        }
    }

    public static void fireTableRowsUpdated(AbstractTableModel abstractTableModel, int n2, int n3) {
        if (!jmaster.util.B.B.A()) {
            jmaster.util.B.B.C(abstractTableModel, B, new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n2), new Integer(n3)});
        } else {
            abstractTableModel.fireTableRowsUpdated(n2, n3);
        }
    }

    public static void fireTableDataChanged(AbstractTableModel abstractTableModel) {
        if (!jmaster.util.B.B.A()) {
            jmaster.util.B.B.B(abstractTableModel, C);
        } else {
            abstractTableModel.fireTableDataChanged();
        }
    }

    public static void setUiDefault(Object object, Object object2) {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        uIDefaults.put(object, object2);
    }

    public static void setUiDefaultString(String string, Object object) {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Object object2 = uIDefaults.get(string);
        if (object2 != null) {
            if (object2 instanceof Color) {
                object = new Color(jmaster.util.property.D.R("" + object));
            }
            if (object2 instanceof Font) {
                Object object3;
                StringTokenizer stringTokenizer = new StringTokenizer("" + object, ",");
                Font font = (Font)object2;
                String string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : font.getFontName();
                int n2 = font.getStyle();
                if (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    n2 = 0;
                    if (string3.indexOf(98) != -1) {
                        n2 |= 1;
                    }
                    if (string3.indexOf(105) != -1) {
                        n2 |= 2;
                    }
                }
                int n3 = font.getSize();
                if (stringTokenizer.hasMoreTokens()) {
                    object3 = stringTokenizer.nextToken();
                    n3 = Integer.parseInt((String)object3);
                }
                object = object3 = new Font(string2, n2, n3);
            }
        }
        SwingUtil.setUiDefault(string, object);
    }

    public static Object getUiDefault(Object object) {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        return uIDefaults.get(object);
    }
}

