/*
 * Decompiled with CFR 0.152.
 */
package jmaster.util.swing.filetree;

import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import jmaster.util.B.B;
import jmaster.util.swing.filetree.FileTreeCellRenderer;
import jmaster.util.swing.filetree.FileTreeModel;
import jmaster.util.swing.filetree.FileTreeNode;
import jmaster.util.swing.filetree.FileTreePendingNode;

public class FileTree
extends JTree
implements TreeExpansionListener {
    private static final long j = -2947248786804745544L;
    protected FileTreeModel i;

    public FileTree() {
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        this.A(fileSystemView.getRoots());
    }

    public FileTree(File[] fileArray) {
        this.A(fileArray);
    }

    protected void A(File[] fileArray) {
        this.i = new FileTreeModel(fileArray);
        this.setModel(this.i);
        this.setCellRenderer(new FileTreeCellRenderer());
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        this.addTreeExpansionListener(this);
    }

    public FileTreeModel getFileTreeModel() {
        return this.i;
    }

    public FileTreeCellRenderer getFileTreeCellRenderer() {
        return (FileTreeCellRenderer)this.getCellRenderer();
    }

    public void navigateTo(File file) {
        if (B.A()) {
            B.B(this, "navigateTo", new Class[]{File.class}, new Object[]{file});
            return;
        }
        FileTreeNode[] fileTreeNodeArray = this.i.getRootNodes();
        FileTreeNode fileTreeNode = null;
        Vector<File> vector = new Vector<File>();
        do {
            vector.insertElementAt(file, 0);
            for (int i2 = 0; i2 < fileTreeNodeArray.length; ++i2) {
                if (!file.equals(fileTreeNodeArray[i2].getFile())) continue;
                fileTreeNode = fileTreeNodeArray[i2];
            }
        } while (fileTreeNode == null && (file = file.getParentFile()) != null);
        if (fileTreeNode == null) {
            return;
        }
        Object[] objectArray = new Object[vector.size() + 1];
        FileTreeNode fileTreeNode2 = fileTreeNode;
        objectArray[0] = this.i.getRoot();
        objectArray[1] = fileTreeNode2;
        for (int i3 = 1; i3 < objectArray.length - 1; ++i3) {
            file = (File)vector.elementAt(i3);
            if (!fileTreeNode2.isExpanded()) {
                this.i.expandNode(fileTreeNode2);
            }
            FileTreeNode fileTreeNode3 = null;
            for (int i4 = 0; i4 < this.i.getChildCount(fileTreeNode2); ++i4) {
                FileTreeNode fileTreeNode4 = (FileTreeNode)this.i.getChild(fileTreeNode2, i4);
                if (!file.equals(fileTreeNode4.getFile())) continue;
                fileTreeNode3 = fileTreeNode4;
                break;
            }
            if (fileTreeNode3 == null) {
                fileTreeNode3 = new FileTreeNode(file);
                fileTreeNode2.insert(fileTreeNode3, 0);
                this.i.reload(fileTreeNode2);
                this.i.expandNode(fileTreeNode3);
            }
            fileTreeNode2 = fileTreeNode3;
            objectArray[i3 + 1] = fileTreeNode2;
        }
        TreePath treePath = new TreePath(objectArray);
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
        this.makeVisible(new TreePath(new Object[]{objectArray[objectArray.length - 1]}));
    }

    public synchronized void refresh() {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null && treePath.getPathCount() > 1) {
            Object[] objectArray = treePath.getPath();
            FileTreeNode fileTreeNode = (FileTreeNode)objectArray[1];
            while (fileTreeNode.getChildCount() > 0) {
                this.i.removeNodeFromParent((MutableTreeNode)fileTreeNode.getLastChild());
            }
            fileTreeNode.setExpanded(false);
            fileTreeNode.add(new FileTreePendingNode());
            this.navigateTo(((FileTreeNode)treePath.getLastPathComponent()).getFile());
        }
    }

    public File getSelectedFile() {
        Object object;
        File file = null;
        TreePath treePath = this.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof FileTreeNode) {
            FileTreeNode fileTreeNode = (FileTreeNode)object;
            file = fileTreeNode.getFile();
        }
        return file;
    }

    public File[] getSelectedFiles() {
        File[] fileArray = null;
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray != null) {
            int n2;
            ArrayList<File> arrayList = new ArrayList<File>();
            for (n2 = 0; n2 < treePathArray.length; ++n2) {
                TreePath treePath = treePathArray[n2];
                Object object = treePath.getLastPathComponent();
                if (!(object instanceof FileTreeNode)) continue;
                FileTreeNode fileTreeNode = (FileTreeNode)object;
                arrayList.add(fileTreeNode.getFile());
            }
            fileArray = new File[arrayList.size()];
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                fileArray[n2] = (File)arrayList.get(n2);
            }
        }
        return fileArray;
    }

    protected void A(final FileTreeNode fileTreeNode) {
        if (!fileTreeNode.isExpanded() && !fileTreeNode.isProcessing()) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    FileTree.this.i.expandNode(fileTreeNode);
                }
            });
            thread.setName("FileTreeExpander_" + fileTreeNode.getFile());
            thread.start();
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        Object object = treeExpansionEvent.getPath().getLastPathComponent();
        if (object != null && object instanceof FileTreeNode) {
            this.A((FileTreeNode)object);
        }
    }
}

