/*
 * Decompiled with CFR 0.152.
 */
package jmaster.util.swing.filetree;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import jmaster.util.B.B;
import jmaster.util.swing.SwingUtil;
import jmaster.util.swing.filetree.DefaultFileComparator;
import jmaster.util.swing.filetree.FileTreeNode;
import jmaster.util.swing.filetree.FileTreePendingNode;

public class FileTreeModel
extends DefaultTreeModel
implements TreeModel {
    private static final long E = -5923991880231569068L;
    protected FileFilter C;
    protected Comparator D = new DefaultFileComparator();
    protected File[] B;
    protected FileTreeNode[] A;

    public FileTreeModel(File[] fileArray) {
        super(new DefaultMutableTreeNode());
        this.B = fileArray;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        if (fileArray != null) {
            this.A = new FileTreeNode[fileArray.length];
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                this.A[i2] = new FileTreeNode(fileArray[i2]);
                defaultMutableTreeNode.add(this.A[i2]);
            }
        }
    }

    public FileFilter getFileFilter() {
        return this.C;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.C = fileFilter;
    }

    public Comparator getFileComparator() {
        return this.D;
    }

    public void setFileComparator(Comparator comparator) {
        this.D = comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandNode(FileTreeNode fileTreeNode) {
        try {
            if (!fileTreeNode.isExpanded()) {
                if (SwingUtilities.isEventDispatchThread()) {
                    jmaster.util.B.B.B(this, "expandNode", new Class[]{FileTreeNode.class}, new Object[]{fileTreeNode});
                    return;
                }
                fileTreeNode.setProcessing(true);
                File file = fileTreeNode.getFile();
                File[] fileArray = file.listFiles();
                if (fileArray != null && this.C != null) {
                    int n2;
                    ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
                    for (n2 = 0; fileArray != null && n2 < fileArray.length; ++n2) {
                        if (!this.C.accept(fileArray[n2])) continue;
                        arrayList.add(fileArray[n2]);
                    }
                    fileArray = new File[arrayList.size()];
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        fileArray[n2] = (File)arrayList.get(n2);
                    }
                }
                if (this.D != null) {
                    Arrays.sort(fileArray, this.D);
                }
                for (int i2 = 0; fileArray != null && i2 < fileArray.length; ++i2) {
                    FileTreeNode fileTreeNode2 = new FileTreeNode(fileArray[i2]);
                    fileTreeNode.add(fileTreeNode2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            fileTreeNode.setProcessing(false);
            fileTreeNode.setExpanded(true);
            if (fileTreeNode.getChildCount() > 0 && fileTreeNode.getChildAt(0) instanceof FileTreePendingNode) {
                fileTreeNode.remove(0);
            }
            SwingUtil.reloadTreeNode(this, fileTreeNode);
        }
    }

    public FileTreeNode[] getRootNodes() {
        return this.A;
    }

    public void reset() {
        if (!jmaster.util.B.B.A()) {
            jmaster.util.B.B.B(this, "reset");
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        defaultMutableTreeNode.removeAllChildren();
        if (this.B != null) {
            this.A = new FileTreeNode[this.B.length];
            for (int i2 = 0; i2 < this.B.length; ++i2) {
                this.A[i2] = new FileTreeNode(this.B[i2]);
                defaultMutableTreeNode.add(this.A[i2]);
            }
        }
    }
}

