
# bgcorrect.methods: "mas", "none", "rma", "rma2"
# normalize.methods(Data): "constant", "contrasts", "invariantset", "loess",
#		"qspline", "quantiles", "quantiles.robust", "vsn" 
# pmcorrect.methods: "mas", "pmonly", "subtractmm"
# express.summary.stat.methods: "avgdiff", "liwong", "mas", "medianpolish", "playerout" 

# affy.method:"rma","mas5","dchip","userdefined"

# plots: "array.image","hist","MAplot","RNAdeg","boxplot","CGH"

source.dir <- "sources";
graphDir <- paste(getwd(),"/ResultsData_Output/Results_Charts/", sep=''); #note the tailing "/" !
raw.data.dir <- "RawData_Input";
result.data.dir <- "ResultsData_Output";
chart.dir <- "ResultsData_Output/Results_Charts";

design.file <- "RawData_Input/design.txt";
location.file <- "RawData_Input/genes_chr_hpaii.txt";

design.samples <- c();, #c("ctrl","ctrl","ctrl","ctrl"),
design.comp <- list();
simple.design <- FALSE; #TRUE, # should be calculated with web data
contrast.design <- "";

use.targets.file <- TRUE;
slides <- list(); # list of intensity files

affy.method <- "rma"; 

affy.bg.correct <- TRUE; 
affy.bgcorrect.method <- "rma"; 
affy.bgcorrect.param <- list();
affy.normalize <- TRUE; 
affy.normalize.method <- "constant"; 
affy.normalize.param <- list();
affy.pmcorrect.method <- "pmonly"; 
affy.pmcorrect.param <- list();
affy.summary.method <- "avgdiff"; 
affy.summary.param <- list(); 
affy.summary.subset <- NULL;
affy.verbose <- FALSE;

analysis <- "normalization"; # "linear model analysis"

export.file.name <- "output.txt";
Output.Format <- c("SpotID");
	
plot.affy.image <- TRUE;
plot.affy.hist <- TRUE;
plot.affy.MAplot <- TRUE;
plot.affy.RNAdeg <- TRUE;
plot.affy.boxplot <- TRUE;

title.affy.image <- "affy.image";
title.affy.hist <- "affy.hist";
title.affy.MAplot <- "affy.MAplot";
title.affy.RNAdeg <- "affy.RNAdeg";
title.affy.boxplot <- "affy.boxplot";
		
genome.sorting <- TRUE; # CGH analysis
genomes <- "human";
genome.no <- 10;
span <- 0.8; 
chr.thre.1 <- 1.8;
chr.thre.2 <- 0.001;
chr.lim.1 <- 1.5; 
chr.lim.2 <- 3;

####################################################
#########            load library          #########
####################################################
wd<-getwd()

source('InitParams.R')

library(affy);
library(limma);
library(sma);

setwd(source.dir);
source("splosh-code3_000.R");
source("CGH_v01.R");
source("myMakeContrast.R");
source("plot-results.R");
source("read_imagefile.R");
source("mkDesign.R");
setwd(wd);

#####################################################
################ experiment design  #################
#####################################################
affy.makeDesign <- function(){
	if(simple.design == TRUE){
		if(identical(design.comp,list())){
			this.design <- mkDesign(targets=design.samples)
			design <<- this.design$design;
			contrast.design <- c("", names(this.design$design));
			contrast.design <- as.list(contrast.design);	
			contrast.matrix <<- my.makeContrasts(contrast=contrast.design,levels=design);
		}else{
			this.design <- mkDesign(targets=design.samples,comp=design.comp)
			design <<- this.design$design;
			contrast.design <<- this.design$contrast;			
		}
	}else{
		design <<- read.delim(design.file);
		if(contrast.design == '') contrast.design <- c("", names(design))
		else contrast.design <- c("", contrast.design);
		contrast.design <<- as.list(contrast.design);	
		contrast.matrix<<-my.makeContrasts(contrast=contrast.design,levels=design);
	}
	if(!is.list(design) || !is.list(contrast.matrix))
		stop("error: experiment design is not correct!");
}

####################################################
#########    read affymetrix CEL file      #########
####################################################
affy.readIntensity <- function() {
	setwd(raw.data.dir);
	if(use.targets.file == TRUE){
		targets <- try(readTargets(targets.file), TRUE);
		if(!is.list(targets))
			stop("error: target file format is not correct!");
		slides <- targets$FileName;
	}
	Data <<- ReadAffy(filenames=slides)
	if(!is.list(Data)) stop("error: microarray intensity file name or format is not correct!");
	Num.of.Slides <<- length(slides);
	setwd(wd);
}

####################################################
#########      Expression Measures         #########
####################################################
expressionMeasure <- function(){
   ##### RMA ############
   if(identical(affy.method,"rma")) eset <<- rma(Data)

   ##### MAS 5.0 ############
   if(identical(affy.method,"mas5")) eset <<- mas5(Data)
   

   ##### Li and Wong's MEBI (dchip) ############
   if(identical(affy.method,"dchip")) 
	eset <<- expresso(Data,normalize.method="invariantset",bg.correct=FALSE,
		pmcorrect.method="pmonly",summary.method="liwong")

   ##### expresso ############
   if(identical(affy.method,"userdefined"))
     eset <<- expresso(Data,
	 # background correction
             bg.correct=affy.bg.correct,bgcorrect.method=affy.bgcorrect.method,bgcorrect.param=affy.bgcorrect.param,
         # normalize
             normalize=affy.normalize,normalize.method=affy.normalize.method,normalize.param=affy.normalize.param,
         # pm correction
             pmcorrect.method=affy.pmcorrect.method,pmcorrect.param=affy.pmcorrect.param,
         # expression values
             summary.method=affy.summary.method,summary.param=affy.summary.param,summary.subset=affy.summary.subset,
         # misc.
             verbose=affy.verbose)
}
#####################################################
############ export normalized data  ################
#####################################################
affy.normalizeOnly <- function()
	write.exprs(eset, export.file.name)

#####################################################
############ statistical analysis  ##################
#####################################################
affy.analyze <- function() { 
	fit <- try(lmFit(MA, design), TRUE);
	fit2 <- try(contrasts.fit(fit, contrast.matrix), TRUE);
	fit2 <- try(eBayes(fit2), TRUE);

	if(!is.list(fit2)) stop("error: statistical analysis can not be executed!");
	A <- fit2$Amean;

	design.num <- length(contrast.design)-1
	for ( i in 1: design.num){
		if(design.num == 1){
			M<-fit2$coef;			p<-fit2$p.value;
			t<-fit2$t;			B<-fit2$lods; }
		else {
			M<-fit2$coef[,i];		p<-fit2$p.value[,i];
			t<-fit2$t[,i];			B<-fit2$lods[,i]; }

		my.fdr <- try(splosh(pvals=p), TRUE);
		if(!is.list(my.fdr)) stop("error: false dicovery rate calculation can not be executed!");
		cgh <- rep(NA, Num.of.spots.per.array);
		
		#===========  Draw Chart for final Results  ====================
		if (plot.analyzed.results == TRUE) {
			chart.name<-paste(graphDir, Final.Chart.Title,mypaste(".comparison.",i, design.num, sep=''), '.', contrast.design[i+1], '.png',sep="");
			try(plot.results(M=M,A=A,B=B,p=p,chart.name=chart.name), TRUE);
			}
		
		#===========  Draw Chart for chromosome location  ==============
		if(genome.sorting == TRUE){
			M.chr <- M[chr.position[,1]];
			cgh.genes <- try(plot.chrom(ratio=M.chr, chr=chr.position[,2],genome = genomes,
				genome.no=genome.no, a=span, c.thre=chr.thre.1, p.thre=chr.thre.2, 
				lim1 = chr.lim.1, lim2 = chr.lim.2,plot.cgh=plot.cgh,
				imagename=paste(graphDir, Location.Chart.Title, mypaste('.', i, design.num, sep=''), '.', contrast.design[i+1], '.png', sep='')
				), TRUE);
			if(is.vector(cgh.genes)) cgh <- replace(cgh, chr.position[,1], cgh.genes);
			}
			#===========  write data  ======================================
		file.name<-paste(result.analyzed.data,mypaste(".comparison.",i, design.num, sep=''), '.', contrast.design[i+1], '.txt', sep="");
		All.Results.matrix<-try(matrix(c(fit2$genes[,1],M, A, t,p,B,my.fdr$cfdr,my.fdr$fp,my.fdr$fn,cgh), ncol=10),TRUE);
		if(!is.matrix(All.Results.matrix))	stop("error: results file format is not correct!");			
		colnames(All.Results.matrix)<-c("probeset.ID", "M","A","t", "P", "B", "fdr", "fp", "fn","CGH"); }
		
		if(identical(Output.Format, "SpotID"))	sort.index <- sort(c(1:Num.of.spots.per.array), index.return = TRUE)
		else if(identical(Output.Format, "sort.M")) sort.index <- sort(M, index.return = TRUE)
		else if(identical(Output.Format, "sort.p")) sort.index <- sort(p, index.return = TRUE)
		else if(identical(Output.Format, "sort.B")) sort.index <- sort(B, index.return = TRUE)
		All.Results.matrix <- All.Results.matrix[sort.index$ix,];
		write.table(All.Results.matrix, sep = "\t", file=file.name);		
	}
}

################################################################################
#############     Quality Control through Data Exploration    ##################
################################################################################
nd <- paste(wd, "\\ResultsData_Output", sep="");setwd(nd);
##### plot 1: MAplot ############
draw.affy.MAplot <- function(){
	bitmap(paste(graphDir,title.affy.MAplot,'.png', sep=''), width=12,height=12)
	try(MAplot(Data, pairs = TRUE), TRUE);
	dev.off()
}
##### plot 2: hist  #############
draw.affy.hist <- function(){
	bitmap(paste(graphDir,title.affy.hist,'.png', sep=''), width=8,height=8)
	try(hist(Data), TRUE);
	dev.off()
}
##### plot 3: image  ############
draw.affy.image <- function(){
	bitmap(paste(graphDir,title.affy.image,'.png', sep=''), width=12,height=6)
	par(mfrow=c(2,2))
	try(image(Data), TRUE);
	dev.off()
}
##### plot 4: boxplot  ##########
draw.affy.boxplot <- function(){
	bitmap(paste(graphDir,title.affy.boxplot,'.png', sep=''), width=8,height=8)
	par(mfrow = c(1,1))
	try(boxplot(Data, col= c(2,3,4)), TRUE);
	dev.off()
}
##### plot 5: RNA degredation  ##
draw.affy.RNAdeg <- function(){
	bitmap(paste(graphDir,title.affy.RNAdeg,'.png', sep=''), width=8,height=8)
	deg <- AffyRNAdeg(Data)
	try(plotAffyRNAdeg(deg), TRUE);
	dev.off()
}

affy.drawCharts <- function() {
	##  save R image parameter
	op<-par(no.readonly=TRUE)
	if(plot.affy.image == TRUE) draw.affy.image()
	if(plot.affy.hist == TRUE) draw.affy.hist()
	if(plot.affy.MAplot == TRUE) draw.affy.MAplot()
	if(plot.affy.RNAdeg == TRUE) draw.affy.RNAdeg()
	if(plot.affy.boxplot == TRUE) draw.affy.boxplot()
	##  Recover R chart parameters
	par(op)
}

affy.Main <- function() {
	#addNamePrefix()
	affy.readIntensity()
	#readGeneLoc()
	affy.makeDesign
	#prepareData()
	#setwd(result.data.dir)
	expressionMeasure()
	if(identical(analysis, "normalization")){
		affy.normalizeOnly()
	}else {
		affy.analyze()
	}
	affy.drawCharts()	
	setwd(wd)
}

affy.Main()
##########################    Change Back File Path      ##############
setwd(wd)
rm(list=ls())
################################################################################
#############################    End of code    ################################
################################################################################
