mkDesign <- function(targets, comp=NULL, ref=NULL) { 
	# targets should be a vector (for affy) or two-column matrix (for dual-color) of sample names, each row represents a slide. and each column represents a channel -- the first column is Ch1 (or Green, Control) and the second one is Ch2 (or Red, Exp). like matrix(c('s1', 's1', 's2', 's2', 's2', 's2', 's1', 's1'), nrow=4)
	# comp: a list of comparisons, for s1-s2 and s2-s3, and s3-s1, it is list(c("s1","s2"),c("s2","s3"),c('s3','s1'))
	# ref: the name of the sample that was used as reference, e.g, ref='s1'
	targets <- as.matrix(targets)
	slides_n <- nrow(targets)
	channels_n <- ncol(targets)
	ftargets <- factor(targets)
	samps <- levels(ftargets)
	samps_n <- length(samps)
	samps_name <- row.names(targets)

	if (!is.null(ref)) {
		stmp <- c()
		for (s in samps) if (s != ref) stmp[length(stmp)+1] <- s
		if (length(stmp) < samps_n) samps <- c(ref, stmp)
		}
	
	# make the the matrix A (row - slides, col - samples)
	slideM <- matrix(0, nrow=slides_n, ncol=samps_n)
	#row.names(slideM) <- row.names(targets)
	dimnames(slideM)[[2]] <- samps
	## assume channels_n == 2
	if (channels_n == 1) vals <- 1
	else vals <- c(-1, 1:(channels_n-1))
	for (i in 1:slides_n) for (j in 1:channels_n) slideM[i,targets[i,j]] <- vals[j]

	# make matrix B
	if (channels_n == 1) {
		design <- slideM
		colnames(design) <- samps
		}
	else {
		sampM <- diag(nrow=samps_n)
		sampM[2:samps_n,1] <- -1

		design <- as.matrix((slideM %*% solve(sampM))[,2:samps_n])
		colnames(design) <- paste(samps[2:samps_n], samps[1], sep='-')
		}
	if (!is.null(samps_name)) rownames(design) <- samps_name

	if (is.null(comp)) return(list(samples=samps, design=design))

	# make matrix C
	comp_n <- length(comp)
	compM <- matrix(0, nrow=samps_n, ncol=comp_n)
	row.names(compM) <- samps
	for (j in 1:comp_n) {
		a <- comp[[j]]
		compM[a[[1]], j] <- 1
		compM[a[[2]], j] <- -1
		}

	if (channels_n == 1) contrast <- compM
	else contrast <- matrix((solve(t(sampM)) %*% compM)[2:samps_n, ], ncol=comp_n)
	rownames(contrast) <- colnames(design)
	colnames(contrast) <- lapply(comp, join <- function(a) paste(a[1],a[2],sep='-'))

	list(samples=samps, design=design, contrast=contrast)
	}


