my.makeContrasts <- function(contrast, levels) {
	if(is.factor(levels)) levels <- levels(levels)
	if(is.matrix(levels)) levels <- colnames(levels)
	if(is.data.frame(levels)) levels <- names(levels)
	levels <- make.names(levels)
	n <- length(levels)
	if(n < 1) stop("No levels to construct contrasts from")
	indicator <- function(i,n) {
		out <- rep(0,n)
		out[i] <- 1
		out
	}
	for (i in 1:n) assign(levels[i], indicator(i,n))
	e <- contrast;
	ne <- length(e)
	cm <- matrix(0,n,ne-1)
	rownames(cm) <- levels
	if(ne < 2) return(cm)
	enames <- names(e)[1:ne]
	easchar <- as.character(e)[2:ne]
	if(is.null(enames))
		colnames(cm) <- easchar
	else {
		colnames(cm) <- ifelse(enames=="",easchar,enames)
	}
	for (j in 1:(ne-1)) {
		ej <- e[[j+1]]
		if(is.character(ej)) ej <- parse(text=ej)
		cm[,j] <- eval(ej)
	}
	cm
}
