
#################   read export .gpr file from scannarray express  #############

My.read.GPR.images <- function(files,source,path=NULL,ext=NULL,names=NULL,columns=NULL,wt.fun=NULL,verbose=TRUE,sep="\t",quote="\"",...) 
{
#	Extracts an RG list from a series of image analysis output files
#	Gordon Smyth
#	1 Nov 2002.  Last revised 27 Sep 2003.

	if(missing(files)) {
		if(missing(ext))
			stop("Must specify input files")
		else {
			extregex <- paste("\\.",ext,"$",sep="")
			files <- dir(path=ifelse(is.null(path),".",path),pattern=extregex)
			files <- sub(extregex,"",files)
		}
	}
	if(!missing(source) && !missing(columns)) stop("Cannot specify both source and columns")
	source <- match.arg(source,c("arrayvision","genepix","imagene","quantarray","smd","spot","spot.close.open","user.defined"))
	if(source=="imagene") return(read.imagene(files=files,path=path,ext=ext,names=names,columns=columns,wt.fun=wt.fun,verbose=verbose,sep=sep,quote=quote,...))
	slides <- as.vector(as.character(files))
	if(!is.null(ext)) slides <- paste(slides,ext,sep=".")
	nslides <- length(slides)
	if(is.null(names)) names <- removeExt(files)

	if(is.null(columns)) columns <- switch(source,
		smd = list(Gf="CH1I_MEAN",Gb="CH1B_MEDIAN",Rf="CH2I_MEAN",Rb="CH2B_MEDIAN"),
		spot = list(Rf="Rmean",Gf="Gmean",Rb="morphR",Gb="morphG"),
		spot.close.open = list(Rf="Rmean",Gf="Gmean",Rb="morphR.close.open",Gb="morphG.close.open"),
		genepix = list(Rf="F633 Mean",Gf="F543 Mean",Rb="B633 Mean",Gb="B543 Mean"),
#		genepix = list(Rf="F2 Median",Gf="F1 Median",Rb="B2 Median",Gb="B1 Median"),
		quantarray = list(Rf="ch2 Intensity",Gf="ch1 Intensity",Rb="ch2 Background",Gb="ch1 Background"),
		user.defined = list(Rf="ch2.Intensity",Gf="ch1.Intensity",Rb="ch2.Background",Gb="ch1.Background")
	)

#	Read first file to get nspots
	fullname <- slides[1]
	if(!is.null(path)) fullname <- file.path(path,fullname)
	if(source=="quantarray") {
		firstfield <- scan(fullname,what="",sep="\t",flush=TRUE,quiet=TRUE,blank.lines.skip=FALSE,multi.line=FALSE)
		skip <- grep("Begin Data",firstfield)
		if(length(skip)==0) stop("Cannot find \"Begin Data\" in image output file")
		nspots <- grep("End Data",firstfield) - skip -2
		obj <- read.table(fullname,skip=skip,header=TRUE,sep=sep,quote=quote,as.is=TRUE,check.names=FALSE,comment.char="",nrows=nspots,...)
	} else if(source=="arrayvision") {
		skip <- 1
		cn <- scan(fullname,what="",sep=sep,quote=quote,skip=1,nlines=1,quiet=TRUE)
		fg <- grep("^Median Dens - RFU",cn)
		if(length(fg) != 2) stop(paste("Cannot find foreground columns in",fullname))
		bg <- grep("Bkgd",cn)
		if(length(fg) != 2) stop(paste("Cannot find background columns in",fullname))
		columns <- list(Rf=fg[1],Rb=bg[1],Gf=fg[2],Gb=bg[2])
		obj <- read.table(fullname,skip=skip,header=TRUE,sep=sep,quote=quote,as.is=TRUE,check.names=FALSE,comment.char="",...)
		nspots <- nrow(obj)
	} else if(source=="user.defined") {
			skip <- 0
			obj <- read.delim(fullname, skip=skip, header=TRUE)
			nspots <- nrow(obj)
	} else {
		skip <- grep(columns$Rf,readLines(fullname,n=50)) - 1
		if(length(skip)==0)
			stop("Cannot find column heading in image output file")
		else
			skip <- skip[1]
		obj <- read.table(fullname,skip=skip,header=TRUE,sep=sep,quote=quote,as.is=TRUE,check.names=FALSE,comment.char="",...)
		nspots <- nrow(obj)
	}

#	Now read rest
	Y <- matrix(0,nspots,nslides)
	colnames(Y) <- names
	RG <- list(R=Y,G=Y,Rb=Y,Gb=Y)
	if(source=="smd") {
		anncol <- grep(columns$Gf,colnames(obj))-1
		if(anncol>0) RG$genes <- data.frame(obj[,1:anncol])
	}
	if(!is.null(wt.fun)) RG$weights <- Y
	for (i in 1:nslides) {
		if(i > 1) {
			fullname <- slides[i]
			if(!is.null(path)) fullname <- file.path(path,fullname)
			if(source=="user.defined") {
				obj <- read.delim(fullname,header=TRUE)
			}else{
				obj <- read.table(fullname,skip=skip,header=TRUE,sep=sep,as.is=TRUE,quote=quote,check.names=FALSE,comment.char="",nrows=nspots,...)
			}
		}
		RG$R[,i] <- obj[,columns$Rf]
		RG$G[,i] <- obj[,columns$Gf]
		if (columns$Rb %in% colnames(obj)) RG$Rb[,i] <- obj[,columns$Rb] 
		else RG$Rb <- NULL
		if (columns$Gb %in% colnames(obj)) RG$Gb[,i] <- obj[,columns$Gb] 
		else RG$Gb <- NULL
		if(!is.null(wt.fun)) RG$weights[,i] <- wt.fun(obj)
		if(verbose) cat(paste("Read",fullname,"\n"))
	}
#	new("RGList",RG)
	return(RG)
}
