#!/usr/bin/env python

#LOG = open('tmp.log','a')

from tools import *
import sys, os, re #, md5 #, email.Encoders
from urllib import quote, unquote
from string import strip, split

from db_vars import *

path_sep = os.path.sep
path_sep_url = '/'

cgi_token = "Content-type:text/html\n\n"
cgi_token_xml = "Content-type:text/xml\n\n"

http_host = os.getenv('HTTP_HOST') # or use SERVER_NAME + :SERVER_PORT?
script_path_url = os.getenv('SCRIPT_NAME')
script_path_url = script_path_url[0:script_path_url.rfind(path_sep_url)] # /cgi-bin, or /~xxx/cgi-bin
script_path_file = os.getenv('SCRIPT_FILENAME').replace(path_sep_url, path_sep)
script_path_file = script_path_file[0:script_path_file.rfind(path_sep)]# /var/www/cgi-bin, or /home/xxx/public_html/cgi-bin
#base_dir_url = script_path_url[0:script_path_url.rfind('/')] or '/' # '/'(i.e. /), or /~xxx
##base_dir = script_path_file[0:script_path_file.rfind('/')] # /var/www, or /home/xxx/public_html
#base_dir = (base_dir_url == '/' and os.getenv('DOCUMENT_ROOT')) or script_path_file[0:script_path_file.rfind('/')] # /var/www/html, or /home/xxx/public_html

def getBaseDir(cgi_url=script_path_url, cgi_file=script_path_file):
	n = cgi_url.count(path_sep_url) # n should not less than 1
	if n==1: # should be something like '/cgi-bin'
		return path_sep_url, os.getenv('DOCUMENT_ROOT').replace(path_sep_url, path_sep)
	#if cgi_url[1] == '~': #should be /~xxx/...
	#	if n==2: # /~xxx/cgi-bin
	#		return cgi_url[:cgi_url.rfind('/')], cgi_file[:cgi_file.rfind('/')]
	#	else: # /~xxx/cgi-bin/...
	#		s = cgi_url.find('/',1)
	#		e = cgi_url.find('/',s+1)
	#		cgi_dir = cgi_url[s:e]
	#		return cgi_url[:s]+cgi_url[e:], 

	if cgi_url[1] == '~': #should be /~xxx/...
		urls, files = cgi_url.split(path_sep_url), cgi_file.split(path_sep)
		for i in range(len(urls)):
			if urls[-i] != files[-i]: break
		del urls[-(i-1)], files[-(i-1)]
		return path_sep_url.join(urls), path_sep.join(files)
		
	# Now must be /cgi-bin/...
	i = cgi_url.find(path_sep_url, 1)
	return cgi_url[i:], (os.getenv('DOCUMENT_ROOT')+cgi_url[i:]).replace(path_sep_url, path_sep)

base_dir_url, base_dir = getBaseDir(script_path_url) # base_dir_url is something like /webarray or /~xxx/webarray

home_dir = base_dir # /var/www/html(/webarray), or '/home/xxia/public_html(/webarray)' # user data will based on this dir
users_relative_dir = "users"
users_dir = os.path.join(home_dir, users_relative_dir) # /var/www/html/users, or /home/xxx/public_html/users
relative_upload_dir = 'data'
relative_result_dir = 'result'
relative_chart_dir = 'chart'
R_code_dir = 'R_code' # under cgi-bin
icon_dir = path_sep_url.join((base_dir_url, 'icon')) #os.path.join(base_dir_url, 'icon')
js_dir = path_sep_url.join((base_dir_url, 'js')) #os.path.join(base_dir_url, 'js')

#print cgi_token
#print base_dir_url, base_dir, users_dir, icon_dir
#import cgi
#print cgi.print_environ()
#import sys
#sys.exit(0)

data_subdirs = { 
	'intensity':{'name_short':'intensity', 'name_cgi':'intensity_file', 'web_text':'Intensity files', 'binary_ext':['CEL']}, 
	'gal':{'name_short':'gal', 'name_cgi':'gal_file', 'web_text':'gene list files'}, 
	'spot':{'name_short':'spot','name_cgi':'spot_file', 'web_text':'spot type files'}, 
	'location':{'name_short':'location','name_cgi':'location_file', 'web_text':'genome/chromosome location files'},
	'target':{'name_short':'target', 'name_cgi':'target_file', 'web_text':'targets files'}, 
	'design':{'name_short':'design', 'name_cgi':'design_file', 'web_text':'design files'}, 
	'composite':{'name_short':'composite', 'name_cgi':'composite_file', 'web_text':'composite normalization'},
	# for MPMDB use only
	'project':{'name_short':'project', 'name_cgi':'prj_file', 'web_text':'Project files'},
	'prjanno':{'name_short':'prjanno', 'name_cgi':'prjanno_file', 'web_text':'Project annotation files'},
	'image':{'name_short':'image', 'name_cgi':'img_file', 'web_text':'Image files', 'binary_file':True},
	'probe':{'name_short':'probe', 'name_cgi':'probe_file', 'web_text':'Probe files'},
	'protocol':{'name_short':'protocol', 'name_cgi':'prot_file', 'web_text':'Protocol files', 'binary_file':True},
	'map':{'name_short':'map', 'name_cgi':'map_file', 'web_text':'Probe-mapping files'},
	'other':{'name_short':'other', 'name_cgi':'other_file', 'web_text':'Other files', 'binary_file':True}
	#'image':{'name_short':'', 'name_cgi':'', 'web_text':''}
	} # the key is cgi form items to be dealt with, the values' keys: name_short - directory name, name_full - directory full name, name_cgi - variable name used in pages/ui_upload.pih
	
result_subdirs = { # name_short and name_full
	'request':{'name_short':''},
	'chart':{'name_short':'chart'}
	}
	
namemap_limma_linear = {'intensity_file':'slides', 'gal_file':'gal.file.name', 'gal_format':'gal', 
	'norm_in_array':'WithinArray.Nor', 'norm_bt_array':'BetweenArra.Nor', 'target_file':'targets.file',
	'output_format':'Output.Format', 'bg_substraction':'BG.Sub', 'spot_file' : 'spot.types.files',
	'intensity_format':'MA.File.Format', 'replicates_in_array':'Num.of.Dup', 'ch1':'design.ch1', 'ch2':'design.ch2'
	}#'contrast':'contrast.design'}
	
no_file_selected = '' #'No file selected'

EncodedCookies = ['user_name', 'online']

error_info = []

def exitWithInfo(e_info=None, e_code=0):
	if e_info is None: e_info = '\n<p>'.join(error_info)
	print cgi_token
	print e_info
	sys.exit(e_code)


def getCookiesForServer(): # server read cookies from client
	#CookieJar = Cookie.SimpleCookie()
	cookies = {}
	if os.environ.has_key('HTTP_COOKIE'):
		#LOG.write('\nHTTP_COOKIE: '+os.environ['HTTP_COOKIE'])
		for eachCookie in map(strip, split(os.environ['HTTP_COOKIE'], ';')): # or use '; ', or lstrip ?
			try:
				#k, v = eachCookie.split('=')
				i = eachCookie.find('=')
				if i < 0: continue
				if i == 0: continue
				k, v = eachCookie[:i], eachCookie[i+1:]
			except: 
				continue
				#exitWithInfo('HTTP_COOKIE: '+os.environ['HTTP_COOKIE'])
			if k in EncodedCookies:
				cookies[k] = decodeStr(unquote(v))
			else: cookies[k] = unquote(v)
	return cookies

cookies = getCookiesForServer()
username = cookies.get('user_name', '')
user_dir = username = username.lower()
upload_dir = ''
result_dir = ''
#request_dir = ''

#LOG.write(repr(cookies)+'\n'+username+'\t'+user_dir+'\n')

def OnlineStr(user_id):
	# return 'yes' 
	return 'Yes, ' + user_id + ' is online'

def OfflineStr(user_id):
	#return 'no' 
	return 'No, ' + user_id + ' is not online'

def isOnline():
	#return 1
	cookies = getCookiesForServer()
	#print cookies
	if cookies.has_key('user_name') and cookies.has_key('online') and cookies['online']==OnlineStr(cookies['user_name']): return 1
	return 0

def Username():
	return cookies.get('user_name', '')
	#un = cookies.get('user_name', '')
	#if un: un = decodeStr(un)
	#return un

def prepareDirnames(): # prepare dirs except request's dirs which depend on user's requests.
	global user_dir, upload_dir, result_dir
	#if not username: return 
	if not isOnline(): return
	user_id = username.lower() 
	user_dir = os.path.abspath(os.path.join(users_dir, user_id))
	upload_dir = os.path.join(user_dir, relative_upload_dir)
	if not os.path.exists(upload_dir): 
		os.makedirs(upload_dir)
		os.chmod(upload_dir, 0775)
	result_dir = os.path.join(user_dir, relative_result_dir)
	if not os.path.exists(result_dir): 
		os.makedirs(result_dir)
		os.chmod(result_dir, 0775)
	
	for v in data_subdirs.values():
		v['name_full'] = os.path.join(upload_dir, v['name_short'])

	saveUsersDir(os.path.abspath(users_dir))

try:
	prepareDirnames()
except: # for mpmdb
	pass

def prepareUploadDirs():
	#prepareDirNames()
	for v in data_subdirs.values():
		full_name = v['name_full']
		if not os.path.exists(full_name): 
			os.mkdir(full_name)
			os.chmod(full_name, 0775)

def getRequestDirnames(request_name):
	if not result_dir: return None
	request_dir = os.path.join(result_dir, request_name)
	subdirs = result_subdirs.copy()
	for v in subdirs.values():
		v['name_full'] =  os.path.join(request_dir, v['name_short'])

	return subdirs


def prepareResultDirs_keep(request_name=''):
	#global request_dir
	if not result_dir: return None
	if not request_name: # need to create a unique name
		from tools import UniqueNameSeq
		request_name = UniqueNameSeq(prefix='req_', suffix='', dir=result_dir, num_len=3, start_num=len(os.listdir(result_dir))+1)
		# more codes here
	if not os.path.exists(result_dir): 
		os.mkdir(result_dir)
		os.chmod(result_dir, 0777)
	request_dir = os.path.join(result_dir, request_name)
	if not os.path.exists(request_dir): 
		os.mkdir(request_dir) #os.makedirs(request_dir)
		os.chmod(request_dir, 0777)
	# make sub dirs here
	for v in result_subdirs.values():
		full_name = os.path.join(request_dir, v['name_short'])
		if not os.path.exists(full_name): 
			os.mkdir(full_name)
			os.chmod(full_name, 0777)
		v['name_full'] = full_name 
	return result_subdirs

def prepareResultDirs(request_name=''):
	#global request_dir
	if not result_dir: return None
	if not request_name: # need to create a unique name
		from tools import UniqueNameSeq
		request_name = UniqueNameSeq(prefix='req_', suffix='', dir=result_dir, num_len=3, start_num=len(os.listdir(result_dir))+1)
		# more codes here
	if not os.path.exists(result_dir): 
		os.mkdir(result_dir)
		#os.chmod(result_dir, 0770)
		os.chmod(result_dir, 0775)
	request_dir = os.path.join(result_dir, request_name)
	if os.path.exists(request_dir): 
		import shutil
		shutil.rmtree(request_dir) 
	os.mkdir(request_dir) #os.makedirs(request_dir)
	#os.chmod(request_dir, 0770)
	os.chmod(request_dir, 0775)
	# make sub dirs here
	for v in result_subdirs.values():
		short_name = v['name_short']
		full_name = os.path.join(request_dir, short_name)
		if short_name: #not os.path.exists(full_name): 
			os.mkdir(full_name)
			#os.chmod(full_name, 0770)
			os.chmod(full_name, 0775)
		v['name_full'] = full_name 
	return result_subdirs

def getRelativePath(fnpth, basepth):
	''' get the relative path (fnpth relative to basepth, -- both should be abspath)'''
	fns = re.sub(r'^\s*%s?(.*)%s?\s*$' % (path_sep, path_sep), r'\1', fnpth)
	bases = re.sub(r'^\s*%s?(.*)%s?\s*$' % (path_sep, path_sep), r'\1', basepth)
	fns, bases = fns.split(path_sep), bases.split(path_sep)
	for pth in bases[:]:
		if fns and fns[0] == pth: 
			fns.pop(0)
			bases.pop(0)
		else: break
	if not bases: rlt = fns
	else:
		rlt = ['..']*len(bases)
		rlt.extend(fns)
	rlt = path_sep.join(rlt)
	return rlt
		
def path2url(path):
	#pre = os.path.commonprefix((os.path.normpath(base_dir)+path_sep, path))
	#return os.path.join(base_dir_url, path[len(pre):])
	#return os.path.join(base_dir_url, getRelativePath(path, os.path.normpath(base_dir)))
	return path_sep_url.join((base_dir_url, getRelativePath(path, os.path.normpath(base_dir)).replace(path_sep, path_sep_url)))

def url2path(url): # the url should not including host, and should begin with '/'
	pre = os.path.commonprefix((base_dir_url+path_sep_url, url))
	return os.path.join(base_dir, url[len(pre):].replace(path_sep_url, path_sep))



# SAVE user_params to database
def saveReq_movedto_tools(req_type, req_name, req_params):
	import cPickle, time
	req_str = cPickle.dumps(req_params)
	connection, cursor = getConnectionCursor()
	sql_statement = 'SELECT id FROM users WHERE user_name="%s"' % username
	n = cursor.execute(sql_statement)
	#if n < 1: # failed
	if cursor.rowcount < 1: # failed
		print cgi_token
		print "Error occurs when reading user database"
		cursor.close()
		connection.close()
		sys.exit(0)
	user_id = cursor.fetchone()[0]
	#req_type = TYPE_NORM_ANALYSIS
	date_time = time.strftime('%Y-%m-%d %H:%M:%S', time.gmtime())
	#req_name = os.path.basename(os.path.normpath(result_subdirs['request']['name_full']))
	cursor.execute('DELETE FROM requests WHERE user_id=%d and req_name="%s"' % (user_id, req_name))
	sql_statement = 'INSERT INTO requests (user_id, req_name, req_time, req_info, category) VALUES (%d, "%s", "%s", "%s", %d)' % (user_id, req_name, date_time, req_str, req_type)

	n = cursor.execute(sql_statement)
	n = cursor.rowcount
	connection.commit()
	cursor.close()
	connection.close()
	return n

def delReqs_movedto_tools(r_ids=[], r_names=[]): # should not delete reqs on working
	import cPickle, time
	connection, cursor = getConnectionCursor()
	for k in r_ids:
		cursor.execute('DELETE FROM requests WHERE req_id=%d' % k)
	connection.commit()
	cursor.close()
	connection.close()
	import shutil
	cwd = os.getcwd()
	os.chdir(result_dir)
	for k in r_names:
		if os.path.exists(k): shutil.rmtree(k)
	os.chdir(cwd)


def exitMsg(msg):
	print cgi_token
	print msg
	sys.exit(0)
