#!/usr/bin/env python

from tools import *

# the order to delete:
# 1. array
# 2. sample, protocol, platform
# 3. project
# all other tables except array need to check references to itself fefore deleting

# Steps to del a record
# 1. make sure it is not referenced by other records/tables
# 2. del the ref from this to others first (e.g. files)
# 3. del anything belong to it
# 4. del its keywords, dyncols
# 5. del itself

def delFiles(fns, cur, dbnm):
	if fns:
		for loc, nm, fid in fns:
			fn = os.path.join(loc, nm)
			if os.path.exists(fn): os.unlink(fn)
		# clear fileinfo, filexref
		ids = map(lambda a:str(a[2]), fns)
		ids = ', '.join(ids)
		cur.execute('DELETE FROM %s.fileinfo WHERE id IN (%s)' % (dbnm, ids))
		cur.execute('DELETE FROM %s.filexref WHERE file_id IN (%s)' % (dbnm, ids))
		cur.connection.commit()

def delArray(dbnm, rec_id, cur=None):
	cur = cur or getCursor()
	# clear ref in sampxref, intensity, project_array
	for tb in ('sampxref', 'intensity', 'project_array'):
		cur.execute('DELETE FROM %s.%s WHERE array_id=%d' % (dbnm, tb, rec_id) )
	# delete image and intensity files
	fns = inquireDB('SELECT f.location, f.name, f.id FROM %s.fileinfo f, %s.filexref x WHERE x.tbname="array" AND x.tb_id=%d AND x.file_id=f.id AND (f.category="image" || f.category="intensity")' % (dbnm, dbnm, rec_id), cursor=cur, fetch=True)
	delFiles(fns, cur, dbnm)
	# clear fileinfo, filexref
	#cur.execute('DELETE f.* FROM %s.fileinfo f, %s.filexref x WHERE x.tbname="array" AND x.tb_id=%d AND x.file_id=f.id AND (f.category="image" || f.category="intensity")' % (dbnm, dbnm, rec_id))
	#cur.execute('DELETE FROM %s.filexref WHERE tbname="array" AND tb_id=%d' % (dbnm, rec_id))
	# clear ref in keyword
	cur.execute('DELETE FROM %s.keyword WHERE tb_name="array" AND rec_id=%d' % (dbnm, rec_id))
	# clear ref in dyncol
	cur.execute('DELETE d.* FROM %s.dyncol d, %s.dyncoldef f WHERE f.tb_name="array" AND f.id=d.col_id AND d.rec_id=%d' % (dbnm, dbnm, rec_id))
	# clear not-using cols in dyncoldef
	#cur.execute('DELETE f.* FROM %s.dyncoldef f LEFT JOIN %s.dyncol d ON f.id=d.col_id WHERE f.tb_name="array" AND d.col_id IS NULL' % (dbnm, dbnm))
	cur.execute('DELETE f.* FROM %s.dyncoldef f LEFT JOIN %s.dyncol d ON f.id=d.col_id WHERE d.col_id IS NULL' % (dbnm, dbnm))
	# del itself
	cur.execute('DELETE FROM %s.array WHERE id=%d' % (dbnm, rec_id))
	cur.connection.commit()

def refSamp(dbnm, rec_id, cur=None):
	'''use refSamp check links before call delSamp'''
	cur = cur or getCursor()
	# check in sampxref
	ary_id_nms = inquireDB('SELECT DISTINCT id, identifier FROM %s.sampxref LEFT JOIN %s.array ON array_id=id WHERE sample_id=%d' % (dbnm, dbnm, rec_id), cursor=cur, fetch=True)
	return {'array':ary_id_nms}

def delSamp(dbnm, rec_id, cur=None):
	cur = cur or getCursor()
	# make sure no ref first.
	# if refSamp(dbnm, rec_id): return
	#cur.execute('DELETE FROM %s.sampxref WHERE sample_id=%d' % (dbnm, rec_id) )
	# clear ref in keyword
	cur.execute('DELETE FROM %s.keyword WHERE tb_name="sample" AND rec_id=%d' % (dbnm, rec_id))
	# clear ref in dyncol
	cur.execute('DELETE d.* FROM %s.dyncol d, %s.dyncoldef f WHERE f.tb_name="sample" AND f.id=d.col_id AND d.rec_id=%d' % (dbnm, dbnm, rec_id))
	# clear not-using cols in dyncoldef
	#cur.execute('DELETE f.* FROM %s.dyncoldef f LEFT JOIN %s.dyncol d ON f.id=d.col_id WHERE f.tb_name="sample" AND d.col_id IS NULL' % (dbnm, dbnm))
	cur.execute('DELETE f.* FROM %s.dyncoldef f LEFT JOIN %s.dyncol d ON f.id=d.col_id WHERE d.col_id IS NULL' % (dbnm, dbnm))
	# del itself
	cur.execute('DELETE FROM %s.sample WHERE id=%d' % (dbnm, rec_id) )
	cur.connection.commit()

def refProt(dbnm, rec_id, cur=None):
	'''use refProt check links before call delProt'''
	cur = cur or getCursor()

	ary_id_nms = inquireDB('SELECT DISTINCT a.id, a.identifier FROM %s.array a RIGHT JOIN %s.sampxref x ON x.array_id=a.id WHERE a.prot_hyb_id=%d || a.prot_img_id=%d || a.prot_data_id=%d || x.prot_proc_id=%d || x.prot_tech_id=%d || x.prot_label_id=%d' % (dbnm, dbnm, rec_id, rec_id, rec_id, rec_id, rec_id, rec_id), cursor=cur, fetch=True)
	return {'array':ary_id_nms, 'sample':()}
	#ary_id_nms = inquireDB('SELECT DISTINCT a.id, a.identifier FROM %s.array RIGHT JOIN %s.sampxref x ON x.array_id=a.id, %s.project p WHERE p.id=%d && (a.prot_hyb_id=%d || a.prot_img_id=%d || a.prot_data_id=%d || x.prot_proc_id=%d || x.prot_tech_id=%d || x.prot_label_id=%d)' % (dbnm, dbnm, dbnm, , rec_id, rec_id, rec_id, rec_id, rec_id, rec_id), cursor=cur, fetch=True)

	ary_id_nms = inquireDB('SELECT DISTINCT id, identifier FROM %s.array WHERE prot_hyb_id=%d || prot_img_id=%d || prot_data_id=%d' % (dbnm, rec_id, rec_id, rec_id), cursor=cur, fetch=True)
	#return ary_id_nms # sample are related to array too
	samp_id_nms = inquireDB('SELECT DISTINCT id, name FROM %s.sample LEFT JOIN %s.sampxref ON id=sample_id WHERE prot_proc_id=%d || prot_tech_id=%d || prot_label_id=%d' % (dbnm, dbnm, rec_id, rec_id, rec_id), cursor=cur, fetch=True)
	return {'array':ary_id_nms, 'sample':samp_id_nms}

def delProt(dbnm, rec_id, cur=None):
	cur = cur or getCursor()
	# delete protocol files
	fns = inquireDB('SELECT DISTINCT f.location, f.name, f.id FROM %s.fileinfo f, %s.filexref x WHERE x.tbname="protocol" AND x.tb_id=%d AND x.file_id=f.id AND f.category="protocol"' % (dbnm, dbnm, rec_id), cursor=cur, fetch=True)
	delFiles(fns, cur, dbnm)
	# clear fileinfo, filexref
	#cur.execute('DELETE f.* FROM %s.fileinfo f, %s.filexref x WHERE x.tbname="protocol" AND x.tb_id=%d AND x.file_id=f.id AND f.category="protocol"' % (dbnm, dbnm, rec_id))
	#cur.execute('DELETE FROM %s.filexref WHERE tbname="protocol" AND tb_id=%d' % (dbnm, rec_id))
	# clear ref in keyword
	cur.execute('DELETE FROM %s.keyword WHERE tb_name="protocol" AND rec_id=%d' % (dbnm, rec_id))
	# clear ref in dyncol
	cur.execute('DELETE d.* FROM %s.dyncol d, %s.dyncoldef f WHERE f.tb_name="protocol" AND f.id=d.col_id AND d.rec_id=%d' % (dbnm, dbnm, rec_id))
	# clear not-using cols in dyncoldef
	#cur.execute('DELETE f.* FROM %s.dyncoldef f LEFT JOIN %s.dyncol d ON f.id=d.col_id WHERE f.tb_name="protocol" AND d.col_id IS NULL' % (dbnm, dbnm))
	cur.execute('DELETE f.* FROM %s.dyncoldef f LEFT JOIN %s.dyncol d ON f.id=d.col_id WHERE d.col_id IS NULL' % (dbnm, dbnm))
	# del itself
	cur.execute('DELETE FROM %s.protocol WHERE id=%d' % (dbnm, rec_id) )
	cur.connection.commit()

def refPf(dbnm, rec_id, cur=None):
	'''use refPf check links before call delPf'''
	cur = cur or getCursor()
	ary_id_nms = inquireDB('SELECT id, identifier FROM %s.array WHERE platform_id=%d' % (dbnm, rec_id), cursor=cur, fetch=True)
	return {'array':ary_id_nms}

def delPf(dbnm, rec_id, cur=None):
	cur = cur or getCursor()
	# delete probe files
	fns = inquireDB('SELECT f.location, f.name, f.id FROM %s.fileinfo f, %s.filexref x WHERE x.tbname="platform" AND x.tb_id=%d AND x.file_id=f.id AND f.category="platform"' % (dbnm, dbnm, rec_id), cursor=cur, fetch=True)
	delFiles(fns, cur, dbnm)
	# clear fileinfo, filexref
	#cur.execute('DELETE f.* FROM %s.fileinfo f, %s.filexref x WHERE x.tbname="platform" AND x.tb_id=%d AND x.file_id=f.id AND f.category="platform"' % (dbnm, dbnm, rec_id))
	#cur.execute('DELETE FROM %s.filexref WHERE tbname="platform" AND tb_id=%d' % (dbnm, rec_id))
	# clear ref in keyword
	cur.execute('DELETE FROM %s.keyword WHERE tb_name="platform" AND rec_id=%d' % (dbnm, rec_id))
	# clear ref in dyncol
	cur.execute('DELETE d.* FROM %s.dyncol d, %s.dyncoldef f WHERE f.tb_name="platform" AND f.id=d.col_id AND d.rec_id=%d' % (dbnm, dbnm, rec_id))
	# clear not-using cols in dyncoldef
	#cur.execute('DELETE f.* FROM %s.dyncoldef f LEFT JOIN %s.dyncol d ON f.id=d.col_id WHERE f.tb_name="platform" AND d.col_id IS NULL' % (dbnm, dbnm))
	cur.execute('DELETE f.* FROM %s.dyncoldef f LEFT JOIN %s.dyncol d ON f.id=d.col_id WHERE d.col_id IS NULL' % (dbnm, dbnm))
	# delete probe records 
	cur.execute('DELETE FROM %s.probe WHERE platform_id=%d' % (dbnm, rec_id))
	# clear xpf_id and mapf_id without used by probe
	cur.execute('DELETE x.* FROM %s.xpf x LEFT JOIN %s.probe pb ON x.id=pb.xpf_id WHERE pb.xpf_id IS NULL' % (dbnm, dbnm))
	cur.execute('DELETE x.* FROM %s.mapf x LEFT JOIN %s.probe pb ON x.id=pb.mapf_id WHERE pb.mapf_id IS NULL' % (dbnm, dbnm))
	# clear dbxref
	cur.execute('DELETE x.* FROM %s.dbxref x LEFT JOIN %s.probe pb ON x.probe_id=pb.id WHERE pb.id IS NULL' % (dbnm, dbnm))
	# clear dbkw that not used
	cur.execute('DELETE k.* FROM %s.dbkw k LEFT JOIN %s.dbxref x ON k.id=x.dbkw_id WHERE x.dbkw_id IS NULL' % (dbnm, dbnm))
	# clear db
	cur.execute('DELETE d.* FROM %s.db d LEFT JOIN %s.dbkw k ON d.name=k.dbname WHERE k.dbname IS NULL' % (dbnm, dbnm))
	# del itself
	cur.execute('DELETE FROM %s.platform WHERE id=%d' % (dbnm, rec_id))
	cur.connection.commit()

def refPrj(dbnm, rec_id, cur=None):
	cur = cur or getCursor()
	# check if its platforms are used by other projects
	pf_ary_prj_id_nms = inquireDB('SELECT DISTINCT pf.id, pf.name, a.id, a.identifier, p.id, p.name FROM %s.array a INNER JOIN %s.platform pf ON a.platform_id=pf.id LEFT JOIN %s.project p ON pf.project_id=p.id WHERE pf.project_id=%d AND a.project_id!=%d' % (dbnm, dbnm, dbnm, rec_id, rec_id), cursor=cur, fetch=True)
	# check if its samples are used by other projects
	samp_ary_prj_id_nms = inquireDB('SELECT DISTINCT s.id, s.name, a.id, a.identifier, p.id, p.name FROM %s.sample s, %s.sampxref x, %s.array a, %s.project p WHERE s.id=x.sample_id && x.array_id=a.id && s.project_id=%d && a.project_id!=%d && a.project_id=p.id' % (dbnm, dbnm, dbnm, dbnm, rec_id, rec_id), cursor=cur, fetch=True)
	# check if its protocols are used by other projects

	prot_ary_prj_id_nms = inquireDB('SELECT DISTINCT pt.id, pt.name, a.id, a.identifier, p.id, p.name FROM %s.protocol pt, %s.array a RIGHT JOIN %s.sampxref x ON x.array_id=a.id, %s.project p WHERE pt.id IN (a.prot_hyb_id, a.prot_img_id, a.prot_data_id, x.prot_proc_id, x.prot_tech_id, x.prot_label_id) && pt.project_id=%d && a.project_id!=%d && p.id=%d' % (dbnm, dbnm, dbnm, dbnm, rec_id, rec_id, rec_id), cursor=cur, fetch=True)
	return {'platform_array':pf_ary_prj_id_nms, 'sample_array':samp_ary_prj_id_nms, 'protocol_array':prot_ary_prj_id_nms}

	prot_samp_prj_id_nms = inquireDB('SELECT DISTINCT pt.id, pt.name, s.id, s.name, p.id, p.name FROM %s.protocol pt, %s.sampxref x, %s.sample s, %s.project p WHERE (pt.id=x.prot_proc_id || pt.id=x.prot_tech_id || pt.id=x.prot_label_id) && x.sample_id=s.id && pt.project_id=%d && s.project_id!=%d && s.project_id=p.id' % (dbnm, dbnm, dbnm, dbnm, rec_id, rec_id), cursor=cur, fetch=True)
	prot_ary_prj_id_nms = inquireDB('SELECT DISTINCT pt.id, pt.name, a.id, a.identifier, p.id, p.name FROM %s.protocol pt, %s.array a, %s.project p WHERE (pt.id=a.prot_hyb_id || pt.id=a.prot_img_id || pt.id=a.prot_data_id) && pt.project_id=%d && a.project_id!=%d && p.id=%d' % (dbnm, dbnm, dbnm, rec_id, rec_id, rec_id), cursor=cur, fetch=True)
	return {'platform_array':pf_ary_prj_id_nms, 'sample_array':samp_ary_prj_id_nms, 'protocol_sample':prot_samp_prj_id_nms, 'protocol_array':prot_ary_prj_id_nms}

def delPrj(dbnm, rec_id, cur=None):
	cur = cur or getCursor()
	# delete project files first
	fns = inquireDB('SELECT f.location, f.name, f.id FROM %s.fileinfo f, %s.filexref x WHERE x.tbname="project" AND x.tb_id=%d AND x.file_id=f.id AND f.category="project"' % (dbnm, dbnm, rec_id), cursor=cur, fetch=True)
	delFiles(fns, cur, dbnm)
	# clear fileinfo, filexref
	#cur.execute('DELETE f.* FROM %s.fileinfo f, %s.filexref x WHERE x.tbname="project" AND x.tb_id=%d AND x.file_id=f.id AND f.category="project"' % (dbnm, dbnm, rec_id))
	#cur.execute('DELETE FROM %s.filexref WHERE tbname="platform" AND tb_id=%d' % (dbnm, rec_id))
	
	# delete arrays, samples, platforms, protocols
	for tb, fun in (('array', delArray), ('sample', delSamp), ('platform', delPf), ('protocol', delProt)): 
		for tb_rec in inquireDB('SELECT id FROM %s.%s WHERE project_id=%d' % (dbnm, tb, rec_id), cursor=cur, fetch=True): 
			fun(dbnm, tb_rec[0])
	# clear ref in keyword
	cur.execute('DELETE FROM %s.keyword WHERE tb_name="project" AND rec_id=%d' % (dbnm, rec_id))
	# clear ref in dyncol
	cur.execute('DELETE d.* FROM %s.dyncol d, %s.dyncoldef f WHERE f.tb_name="project" AND f.id=d.col_id AND d.rec_id=%d' % (dbnm, dbnm, rec_id))
	# clear not-using cols in dyncoldef
	#cur.execute('DELETE f.* FROM %s.dyncoldef f LEFT JOIN %s.dyncol d ON f.id=d.col_id WHERE f.tb_name="project" AND d.col_id IS NULL' % (dbnm, dbnm))
	cur.execute('DELETE f.* FROM %s.dyncoldef f LEFT JOIN %s.dyncol d ON f.id=d.col_id WHERE d.col_id IS NULL' % (dbnm, dbnm))
	# del itself
	cur.execute('DELETE FROM %s.project WHERE id=%d' % (dbnm, rec_id))
	cur.connection.commit()

