#!/usr/bin/env python

import os, sys, re

def convertImg(path, src='.pdf', obj=['.png', '.eps'], keep=True):
	# convert PDF to eps, png

	if not os.path.exists(path) or not os.path.isdir(path): return

	fmt = {'.png':'png256', '.eps':'epswrite'}
	if type(obj) is str: obj = [obj]
	obj = filter(lambda a:a in fmt, obj) # only '.png' and/or '.eps' left

	cwd = os.getcwd()
	os.chdir(path)

	lnsrc = len(src)
	fns_all = os.listdir('.')
	fns = filter(lambda a:a[-lnsrc:]==src, fns_all)
	#fns = map(lambda a:(a, a[:-lnsrc]+'.eps', a[:-lnsrc]+'.png'), fns)
	#os.system('for nm in *.pdf; do gs -sDEVICE=epswrite -sOutputFile="${nm%pdf}eps" -q "${nm}" -c quit; done; rm -rf *.pdf;')
	prog = sys.platform == 'win32' and 'gswin32c' or 'gs'
	for fsrc in fns:
		try:
			for ext in obj:
				fobj = fsrc[:-lnsrc] + ext
				if fobj not in fns_all: os.popen('%s -q -sDEVICE=%s -sOutputFile="%s" "%s" -c quit' % (prog, fmt[ext], fobj, fsrc), 'r').read()
			if not keep: os.unlink(fsrc) #os.system('rm "%s"' % fpdf)
		except: pass

	os.chdir(cwd)


#output_zip = req_id+'_outputs.zip'

def isEmptyDir(path):
	if not os.path.isdir(path): return False
	names = os.listdir(path)
	if not names: return True
	cwd = os.getcwd()
	os.chdir(path)
	for k in names:
		if os.path.isfile(k): return False
		elif not isEmptyDir(k): return False
	return True

tmp_files = ['Rplots.ps']
tmp_exts = ['.cat', '.pik', '.srt', '.inf', '.Rdata', '.zip']
def zipPath(zip_file, path, files_excluded=tmp_files, filetypes_excluded=['.pdf']+tmp_exts, arc_root=None):
	if os.path.isdir(path):
		names = os.listdir(path)
		if names:
			cwd = os.getcwd()
			os.chdir(path)
			for k in names: 
				if os.path.isfile(k): 
					if (k not in files_excluded) and (os.path.splitext(k)[1] not in filetypes_excluded): 
						#zip_file.write(k)
						zip_file.write(k, arc_root and os.path.join(arc_root, k) or k)
				else: zipPath(zip_file, k, files_excluded=files_excluded, filetypes_excluded=filetypes_excluded, arc_root=arc_root)
			os.chdir(cwd)
	else: # should be a regular file
		if (path not in files_excluded) and (os.path.splitext(path)[1] not in filetypes_excluded): zip_file.write(path)
	
def outputZip(path, req_id=None, req_type=None, output_name=None, override=True, filetypes_excluded=tmp_exts):
	if isEmptyDir(path): return
	if not req_id: 
		arc_root = os.path.basename(os.path.normpath(path)) # normpath may remove tailing '/'
		output_zip = arc_root + '.zip'
	else: 
		arc_root = req_id
		output_zip = arc_root + '_outputs.zip'
	
	if output_name is None:
		if os.path.isdir(path): output_name = os.path.join(path, output_zip)
		else: output_name =  os.path.join(os.path.dirname(path), output_zip)
	#if os.path.exists(output_name) and not override: return
	# now always not override
	if os.path.exists(output_name): return

	if req_type is not None: HTML().mkHTML(path, req_id, req_type)

	names = os.listdir(path) # get names before the output_name file created!!!
	import zipfile
	zip_file = zipfile.ZipFile(output_name, 'w', zipfile.ZIP_DEFLATED)

	## cannot do like (i.e. zip directly) this since the output file can be located in the path, which may lead to zip recursively, never stop
	#zipPath(zip_file, path, filetypes_excluded=filetypes_excluded)   
	#return

	if os.path.isfile(path): 
		zipPath(zip_file, path, filetypes_excluded=filetypes_excluded, arc_root=arc_root)
	else:
		#names = os.listdir(path)
		cwd = os.getcwd()
		os.chdir(path)
		for k in names: zipPath(zip_file, k, filetypes_excluded=filetypes_excluded, arc_root=arc_root) # now add .pdf files as well
		zip_file.close()
		os.chdir(cwd)

from db_vars import *
table_model = { # (comment, file_name_model)
		TYPE_NORM_ANALYSIS : [
			('input parameters', 'input_parameters.txt'), 
			('normalized data', 'output.normalized.data.txt'), 
			('result table', 'output.analyzed.data', 'gridFile')
			],
		TYPE_NORMPCA : [
			('input parameters', 'input_parameters.txt'), 
			('result table', 'normalized_by_pca.txt', 'gridFile')
			],
		TYPE_DBS_ANALYSIS : [
			('input parameters', 'input_parameters.txt'), 
			('request steps', 'request_step.txt'), 
			('Probe annotation', 'Probes_'),
			('experiment information', 'exp_info'), 
			('preprocessed data', 'data_table'), 
			('result table for differential analysis', 'result_table', 'gridFile'), # keep this line for old requests
			('result table for differential analysis', 'differential_analysis', 'gridFile'), 
			('outlier genes of Correspondence Analysis', 'coa_result'), 
			('outlier genes of Between Group Analysis', 'bga_result'), 
			('transposon table', 'transposon_table.', 'gridFile'), 
			('transposon table (with all probes)', 'transposon_table_all_probes', 'gridFile'), 
			('transposon with significant <i>p</i> value', 'transposon_table_p', 'gridFile'), 
			('transposon table by gene (gene_symbol)', 'transposon_table_by_gene', 'gridFile'), 
			('transposon table (with all genes)', 'transposon_table_all_genes', 'gridFile'), 
			('bacteria CGH table', 'bacCGH_table', 'gridFile'), 
			('output information', 'output_info') 
			]
		}
#for t1, t2 in ((TYPE_NORM_ANALYSIS, TYPE_LINEAR_DUAL), (TYPE_NORM_ANALYSIS, TYPE_LINEAR_AFFY)): table_model[t2] = table_model[t1]

chart_model = {
		TYPE_NORM_ANALYSIS : [
			('Final.Chart', {'files':[], 'token':'Final_Results_Plot', 'comment':'Results plot'}),  
			('Array.Chart', {'token':'imageplot.slide', 'comment':'Array image plot'}), 
			('Density.Chart', {'token':'densityplot', 'comment':'Density plot'}), 
			('Location.Chart', {'token':'plot.CGH.two.samples', 'comment':'Two-Sample CGH plot'}), 
			('MA.Chart', {'token':'plotMA.slides', 'comment':'MA plot'}), 
			('Printtip.Chart', {'token':'printtiploessplot.slides', 'comment':'Printtiploess plot'}), 
			('Scale.Chart', {'token':'Box_Plot_Scale_Norm', 'comment':'Box plot'}) 
			],
		TYPE_LINEAR_AFFY : [
			('Final.Chart', {'files':[], 'token':'affy.result.chart', 'comment':'Results plot'}),  
			('Array.Chart', {'token':'affy.image', 'comment':'Array image plot'}), 
			('Boxplot.Chart', {'token':'affy.boxplot', 'comment':'Box plot'}), 
			('CGH.Chart', {'token':'affy.CGH.plot', 'comment':'CGH plot'}), 
			('Hist.Chart', {'token':'affy.hist', 'comment':'Histogram plot'}), 
			('MAplot.Chart', {'token':'affy.MAplot', 'comment':'MA plot'}), 
			('RNAdeg.Chart', {'token':'affy.RNAdeg', 'comment':'RNA degradation plot'}) 
			],
		TYPE_NORMPCA : [
			('Angle_freq_dist_num.png', {'comment':'Angle frequency distribution'}), 
			('Angle_freq.png', {'comment':'Angle frequency'}), 
			('House_keeping.png', {'comment':'House keeping genes'}), 
			('R1_R2.png', {'comment':'R1 versus R2'}) 
			], # the value is (file_name, info_to_be_displayed)
		TYPE_DBS_ANALYSIS : [
			('array', {'token':'_array_image_', 'comment':'A view of array image'}),
			('raw', {'token':'_raw_data_', 'comment':'Raw data'}),
			('bg', {'token':'_bg_corrected_', 'comment':'After background correction'}),
			('norm_in_array', {'token':'_normalized_in_array_', 'comment':'After within-array normalization'}),
			('norm_in_pf', {'token':'_normalized_in_platform_', 'comment':'After within-platform normalization'}),
			('norm_x_pf', {'token':'_normalized_x_platform_', 'comment':'After cross-platform alignment/normalization'}),
			('cluster_chs', {'token':'cluster_data_channels', 'comment':'Clustering chart of all data channels'}),
			('cluster_grps', {'token':'cluster_groups', 'comment':'Clustering chart of all groups'}),
			('heatmap', {'token':'heatmap.', 'comment':'Heatmap chart of all data channels'}), # for old requests
			('heatmap_chs', {'token':'heatmap_data_channels', 'comment':'Heatmap chart of all data channels'}),
			('heatmap_grps', {'token':'heatmap_groups', 'comment':'Heatmap chart of all groups'}),
			#'COA', {'token':'COA_chart', 'comment':'Correspondence analysis', 'legend':'<table><tr><td>A. Plot of the eigenvalues</td><td>B. Projection of microarray samples</td></tr><tr><td>C. Projection of genes</td><td>D. Biplot showing both genes and samples</td></tr><tr><td colspan=2>Samples and genes with a strong associated are projected in the same direction from the origin. The greater the distance from the origin, the stronger the association.</td></tr></table>'}),
			('COA', {'token':'COA_chart', 'comment':'Correspondence Analysis', 'legend':'A. Plot of the eigenvalues. B. Projection of microarray samples. C. Projection of genes. D. Biplot showing both genes and samples.<br>Samples and genes with a strong associated are projected in the same direction from the origin. The greater the distance from the origin, the stronger the association.'}),
			('BGA', {'token':'BGA_chart', 'comment':'Between Group Analysis', 'legend':'A. Between graph of the microarray samples, showing their separation on the discriminating BGA axes. B. Scatterplot of the first 2 axes of microarray samples, colored by their class. C. Graph of positions of genes on the same axis. Genes at the ends of the axis are most discriminating for that group. D. Plot of the eigenvalues.'}),
			('genome_both', {'token':re.compile(r'genome_chart_.*?both_strand_', re.I), 'comment':'Genome plots for both strands'}),
			('genome_pos', {'token':re.compile(r'genome_chart_.*?pos_strand_', re.I), 'comment':'Genome plots for positive strand'}),
			('genome_neg', {'token':re.compile(r'genome_chart_.*?neg_strand_', re.I), 'comment':'Genome plots for negative strand'})
			]
		}
#for t1, t2 in ((TYPE_NORM_ANALYSIS, TYPE_LINEAR_DUAL),): chart_model[t2] = chart_model[t1]

class HTML:
	def tableHTML(self, req_id, result_dir, name_model = [], filetypes_excluded=tmp_exts, output_zip=''): 
		rlt = []
		if not name_model: return rlt
		filenames = os.listdir(result_dir)
		filenames.sort()

		name_start = len(req_id + '_')
		#if filenames and (filenames[0].find(req_id)==0): # for new reqs
		for nm_mdl in name_model:#.items():
			if len(nm_mdl) == 3:
				nm, mdl, vfun = nm_mdl
			else: # should be 2
				nm, mdl = nm_mdl 
				vfun = 'viewFile'
			mdl = req_id + '_' + mdl
			fnms = filter(lambda a:(mdl in a) and (os.path.splitext(a)[1] not in filetypes_excluded), filenames)
			if not fnms: continue
			if len(fnms)==1:
				fn = fnms[0]
				rlt.append("<p>The %s:<br>&nbsp;&nbsp;&nbsp;&nbsp;<a href='%s'>%s</a>" % (nm, fn, fn))
			else:
				rlt.append("<p>The %s data:" % nm)
				for fn in fnms:
					rlt.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;<a href='%s'>%s</a>]" % (fn, fn))
		return rlt

	def chartHTML(self, graph_dir, chart_infos, name_start=0, filetypes_excluded=['.pdf', '.eps']):
		rlt = []
		filenames = filter(lambda a:os.path.splitext(a)[1] not in filetypes_excluded, os.listdir(graph_dir))
		filenames.sort()
		if filenames:
			def fltFun(x):
				tk = x[0]
				s = x[1]
				if type(tk) is str: return tk in s
				return tk.search(s) # should be a re object
			# print content list
			rlt.append('<p><table ><tr><th><b>Charts:</b></th><tr><td><ul>')
			for k, v in chart_infos: #k,v in chart_infos.items():
				if not v.get('files',None): v['files'] = filter(lambda a:fltFun((v['token'], a[name_start:])), filenames)
				if v['files']: rlt.append(('<li><a href=#%s>' % k.replace('.','_')) + v['comment'] + '</a>')
			rlt.append('</ul></td></table>')
			# print charts
			rlt.append('<p><ul>')
			for k, v in chart_infos: #k,v in chart_infos.items():
				if v['files']:
					v_show = v['files'][:]
					v_legend = v.get('legend', '')
					if v_legend: v_show[0] = '%s<br><font size=-1>%s</font>' % (v_show[0], v_legend)
					rlt.append(('<table><tr><td height=40 /></tr></table><br><li><font size=+1><b><a name=%s></a>' % k.replace('.', '_')) + v['comment'] + ' <a href=#RESULT_TOP>(return TOP)</a></b></font>')
					chart_urls = zip(v['files'], v_show)
					rlt.append('<br><table>' + reduce(lambda a,b:a+('<tr><td align=center><img src="%s"></td></tr><tr><td align=center>%s</td></tr><tr><td height=20></td></tr>\n' % b ), chart_urls, '') + '</table>')
			rlt.append('</ul>')
		return rlt
		
	def convertPDF(self, path, req_state=None, keep=True):
		# convert PDF to eps
		if req_state is not None and req_state == STATE_STOPPED:
			convertImg(path, src='.pdf', obj=['.png', '.eps'])

	def getBody(self, path, req_id, req_type, req_state=None, html='index.html'):
		#rlt = self.tableHTML(req_id, path, name_model=table_model[req_type], filetypes_excluded=tmp_exts, output_zip=output_zip)
		#rlt.extend(self.chartHTML(req_id))
		category = req_type
		rlt = []
		if category == TYPE_NORM_ANALYSIS or category==TYPE_LINEAR_DUAL or category==TYPE_LINEAR_AFFY:
			if category == TYPE_NORM_ANALYSIS or category==TYPE_LINEAR_DUAL:
				chart_infos = chart_model[TYPE_NORM_ANALYSIS]
			else: # must be TYPE_LINEAR_AFFY
				chart_infos = chart_model[TYPE_LINEAR_AFFY]
			table_infos = table_model[TYPE_NORM_ANALYSIS]
			result_dir = path #req_info['result.data.dir']
			graph_dir = os.path.join(path, 'chart') #req_info['chart.dir']
			if not os.path.exists(graph_dir): graph_dir = os.path.join(result_dir, relative_chart_dir) # for old requests
			self.convertPDF(graph_dir, req_state=req_state)
			rlt = self.tableHTML(req_id, result_dir, table_infos)
			name_start = len(req_id+'_')
			rlt.extend(self.chartHTML(graph_dir, chart_infos, name_start=name_start))
		elif category == TYPE_NORMPCA:
			chart_infos = chart_model[TYPE_NORMPCA]
			result_dir = path #req_info['output_dir']
			
			if not os.path.exists(result_dir): result_dir = os.path.join(users_dir, username, relative_result_dir, req_id) # for old requests
			result_file = os.path.join(result_dir, 'normalized_by_pca.txt')
			result_file_url = path2url(result_file)
			graph_dir = os.path.join(path, 'chart') #req_info['chart_dir']
			if not os.path.exists(graph_dir): graph_dir = os.path.join(result_dir, relative_chart_dir) # for old requests
			#for k in chart_infos.keys(): 
			for k, v in chart_infos: 
				full_name = os.path.join(graph_dir, k)
				#chart_infos[k]['full'] = full_name
				v['full'] = full_name
				if os.path.exists(full_name): v['exist'] = True
				else: v['exist'] = False
				
			self.convertPDF(graph_dir, req_state=req_state)
			rlt = self.tableHTML(req_id, result_dir, table_model[TYPE_NORMPCA])
			rlt.append('<p><table><tr><th><b>Charts:</b></th><tr><td><ul>')
			for k,v in chart_infos: #.items(): 
				if v['exist']: rlt.append(('<li><a href=#%s>' % k.replace('.','_')) + v['comment'] + '</a>')
			rlt.append('</ul></td></table><p><ul>')
			for k,v in chart_infos: #.items():
				if v['exist']:
					rlt.append(('<li><font size=+1><b><a name=%s></a>' % k.replace('.', '_')) + v['comment'] + ' <a href=#RESULT_TOP>(return TOP)</a></b></font>')
					rlt.append(('<br><table><tr><td align=center><img src="%s"></td><tr><td align=center>%s</td>' % (path2url(v['full']), k)) + '</table>')
			print '</ul>'
		elif category in TYPE_SHOW_ERR:
			rlt.append(error_info and error_info.replace('\n', '<p>') or 'No information to present.')
			rlt.append('<p><input type="button" value="Go back" onClick="JavaScript:history.go(-1)"/>')

		elif category == TYPE_DBS_ANALYSIS:
			graph_dir = os.path.join(path, 'chart') #os.path.join(req_info['result_dir'], 'chart')
			self.convertPDF(graph_dir, req_state=req_state)
			rlt = self.tableHTML(req_id, path, table_model[TYPE_DBS_ANALYSIS])

			name_start = len(req_id+'_')
			rlt.extend(self.chartHTML(graph_dir, chart_model[TYPE_DBS_ANALYSIS], name_start=name_start))

		else: # different result display
			pass
		return rlt
		
	def mkHTML(self, path, req_id, req_type, req_state=None, html='index.html'):
		rlt = self.getBody(path, req_id, req_type, req_state=req_state)
		rlt.insert(0, "<html>\n<body bgcolor='white'>\n<a name = 'RESULT_TOP'><h1><center>Results of %s</center></h1>\n" % req_id)
		rlt.append('\n</body>\n</html>')
		open(os.path.join(path, html), 'w').write('\n'.join(rlt))
		return rlt
