#!python

import os, shutil
file_path = os.path.split(os.path.abspath(__file__))[0]

def modInterpreter(fn, src='#!/usr/bin/env python', obj='#!python'):
	lines = open(fn).readlines()
	obj = obj + '\n'
	if lines and lines[0].strip() == src:
		lines[0] = obj
		open(fn, 'w').write(''.join(lines))

def modInterpreter(fn, src='#!/usr/bin/env python', obj='#!python'):
	obj = obj + '\n'
	f = open(fn)
	line0 = f.readline()
	if line0.strip() == src:
		lines = f.read()
		f.close()
		open(fn, 'w').write(obj + lines)

def modPath(pth, src='#!/usr/bin/env python', obj='#!python'):
	if os.path.isfile(pth): return modInterpreter(pth, src=src, obj=obj)
	if not os.path.isdir(pth) or not os.path.exists(pth): return
	# now must be a folder
	cwd = os.getcwd()
	fns = os.listdir(pth)
	os.chdir(pth)
	for fn in fns: modPath(fn, src=src, obj=obj)
	os.chdir(cwd)

def dupFiles():
	fns = ('analyze_dmp',) #, 'runR', 'fillDBs', 'analyzeDBs')  # windows need extension name to run a program
	for fn in fns:
		try: shutil.copy(fn, '%s.py' % fn)
		except: pass

if __name__ == '__main__': 
	import sys
	src = len(sys.argv) > 1 and sys.argv[1] or '#!/usr/bin/env python'
	obj = len(sys.argv) > 2 and sys.argv[2] or '#!python'
	print 'Replacing the leading line "%s" with "%s", please wait.' % (src, obj)
	modPath(file_path, src=src, obj=obj)
	dupFiles()
