#!/usr/bin/env python

import os, sys, getopt, getpass, MySQLdb, re


def exitUsage(s):
	print 'Renamed existed column names (and definitions) to new ones for a table.\n'
	print "Usage:\n\t%s [-u mysql_admin_user] [-p] [-h host] [-d database_name] [-t] a_tb_name [-s] 'src_col1,src_col2,...' [-o] ' obj_col1[ INT(5) UNSIGNED],obj_col2,...'\n" % os.path.split(sys.argv[0])[1]
	if s: print '\n'+s
	sys.exit(0)

def updateTbs(cur, db, tb, srcs=[], objs=[]):
	if not db: exec get_dbstr() # get_dbstr come from tools.py (from mkdb.py)
	cur.execute('USE %s' % db)
	cur.execute('DESCRIBE %s' % tb)
	defs = dict(map(lambda a:a[0:2], cur.fetchall()))
	for col_src, col_obj in zip(srcs, objs):
		if col_src not in defs:
			print '%s doesn\'t exist, failed to change it!' % col_src
			continue
		try:
			print 'ALTER TABLE %s CHANGE %s %s %s' % (tb, col_src, col_obj, ' ' not in col_obj and defs[col_src] or '') 
			cur.execute('ALTER TABLE %s CHANGE %s %s %s' % (tb, col_src, col_obj, ' ' not in col_obj and defs[col_src] or '') )
		except:
			print 'Failed in change column "%s" to "%s" in table "%s"!' % (col_src, col_obj, tb)

def updateTbMain():
	#if len(sys.argv) != 3: exitUsage()
	#src, obj = sys.argv[1:]
	optlist, args = getopt.getopt(sys.argv[1:], 'u:ph:d:t:s:o:')
	optdict = dict(optlist)
	#if not args: exitUsage()
	host = optdict.get('-h', 'localhost')
	user = optdict.get('-u', getpass.getuser())
	passwd = optdict.has_key('-p') and getpass.getpass() or ''
	db = optdict.get('-d', '')
	err_msg = None
	try: 
		tb = optdict.get('-t', None) or args.pop(0)
		if not tb: err_msg = 'Didn\'t change since no valid table name offered!'
	except: exitUsage('Didn\'t change since no valid table name offered!')
	#import string
	try: 
		cols_src = optdict.get('-s', None) or args.pop(0)
		cols_src = filter(bool, map(str.strip, cols_src.split(',')))
		if not cols_src: err_msg = 'Didn\'t change since no valid source column names offered!'
	except: exitUsage('Didn\'t change since no valid source column names offered!')
	try: 
		obj_str = optdict.get('-o', None) or args.pop(0)
		#cols_obj = filter(bool, map(string.strip, cols_obj.split(',')))
		n_cols = len(cols_src)
		if n_cols == 1: cols_obj = [obj_str]
		else:
			#print cols_src
			#print obj_str
			cols_obj = []
			for i in range(n_cols-1):
				m = re.search(r'(\b%s\b.*?),\s*(%s\b.*)' % (cols_src[i], cols_src[i+1]), obj_str, re.I)
				if not m: raise
				cols_obj.append(m.groups()[0])
			cols_obj.append(m.groups()[1])
		if len(cols_obj) != n_cols: err_msg = 'Didn\'t change since no valid destination column names offered!'
	except: exitUsage('Didn\'t change since no valid destination column names offered!')
	if err_msg: exitUsage(err_msg)
	if args: exitUsage('Didn\'t change since extra parameters offered: "%s"' % ';'.join(args))
	
	#print cols_obj
	#sys.exit(0)

	conn = MySQLdb.connect(host=host, user=user, passwd=passwd)
	cur = conn.cursor()
	updateTbs(cur, db, tb, cols_src, cols_obj)

if __name__ == '__main__': updateTbMain()
