#!/usr/bin/env python

import os

from mkdb import *


def exitUsage():
	print 'Be careful, if you renamed an existed column in the new definition, its record will be lost! In such cases, use modColumns.py to rename those columns in tables first.\n'
	print "Usage:\n\t%s [-h host] [-d database_name] [-t tb_definition_file] [-u mysql_admin_user] [-p] --all | table_name_list\n" % os.path.split(sys.argv[0])[1]
	sys.exit(0)

def getCols(tbs): # tbs is the result of readDbStruct
	colstr = re.compile(r'\s*(\w+)\s*', re.I) # use match, groups()[0]
	rlt_list = {} # {tb:[colnames], ...}
	rlt_dic = {}  # {tb:{colname:col_definition,...}, ...}
	for k, v in tbs.items():
		#print k, ':', len(v), '--', v
		rlt_list[k] = cols = []
		rlt_dic[k] = cols_dic = {}
		for vi in v:
			m = colstr.match(vi)
			if not m: continue
			col = m.groups()[0]
			if col.upper() != 'INDEX': 
				cols.append(col)
				cols_dic[col] = vi
	return rlt_list, rlt_dic
	
def updateTbs(cur, db, tbnms, dbstruct=db_struct, all_tb=False):
	tbs = readDbStruct(dbstruct) # readDbStruct come from mkdb.py
	if all_tb: tbnms = tbs.keys()

	cols_new_list, cols_new_dic = getCols(tbs)
	mktbsql = getDbSQL(tbs, pre='(', mid=', ', suf=')') 
	#print cols_new_list
	#print cols_new_dic
	if not db: exec get_dbstr() # get_dbstr come from tools.py (from mkdb.py)
	cur.execute('USE %s' % db)
	for tb in tbnms:
		if not tbs.has_key(tb): 
			print "%s does not have a definition, cannot modify it." % tb
			continue
		col_list = ', '.join(cols_new_list[tb]).strip()
		if not col_list: 
			print "%s does not have a valid definition, cannot modify it." % tb
			continue
		cur.execute('DESCRIBE %s' % tb)
		if not cur.rowcount: 
			print "%s does not exist, use mkDB instead to create it." % tb
			continue
		cols_old = map(lambda a:a[0], cur.fetchall())
		# if there is any new column, add it into table
		cols_new = cols_new_dic[tb]
		for col in cols_old:
			if cols_new.has_key(col): del cols_new[col]
		if cols_new: # has new columns
			cur.execute('ALTER TABLE %s ADD (%s)' % (tb, ', '.join(cols_new.values())) )
		# create new table		
		tbtmp = tb+'_tmp'
		cur.execute('CREATE TABLE IF NOT EXISTS %s %s' % (tbtmp, mktbsql[tb]) )
		cur.execute('INSERT INTO %s SELECT %s FROM %s' % (tbtmp, ', '.join(cols_new_list[tb]), tb) )
		cur.execute('DROP TABLE %s' % tb)
		cur.execute('ALTER TABLE %s RENAME %s' % (tbtmp, tb) )


def updateTbMain():
	#if len(sys.argv) != 3: exitUsage()
	#src, obj = sys.argv[1:]
	optlist, args = getopt(sys.argv[1:], 'h:d:t:u:p', ['all'])
	optdict = dict(optlist)
	all_tb = '--all' in optdict
	if not args and not all_tb: exitUsage()
	host = optdict.get('-h', 'localhost')
	db = optdict.get('-d', '')
	dbstruct = optdict.get('-t', db_struct)
	user = optdict.get('-u', getpass.getuser())
	passwd = optdict.has_key('-p') and getpass.getpass() or ''
	
	conn = MySQLdb.connect(host=host, user=user, passwd=passwd)
	cur = conn.cursor()
	updateTbs(cur, db, args, dbstruct=dbstruct, all_tb=all_tb)

if __name__ == '__main__': updateTbMain()
