
##########################  chromosomal location  ############################


plot.chrom<-function(ratio, chr, a=0.8, c.thre=1.96, p.thre=0.001, lim1=1.5,lim2=3.0,
	genome="human",genome.no=0, main="", ylab="Log2 ratio", 
	imagename="plot.chromosomal.location.png", plot.cgh=TRUE, type=NULL)
{
	Chr.Position1 <- lim1/1.2;
	Marker1 <- lim1/1.5;
	Chr.Position2 <- lim2/1.2;
	Marker2 <- lim2/1.5;
	#===========  Labels  =============================================
	if(genome == "human"){
		Labels=c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,"X","Y");
	}
	if(genome == "mouse"){
		Labels=c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,"X","Y");
	}
	if(genome == "rat"){
		Labels=c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,"X");
	}
	if(genome == "single"){
		Labels=c("the whole genome");
	}
	if(genome == "multiple"){
		Labels=c(1:genome.no);
	}
	
	#===========  calculation  =============================================
	Posi.chr<-c();
	no.of.genes<-length(chr);
	x1<-c(1:(no.of.genes+length(Labels)*2));
	d<-c();e<-c();c<-c();f<-c();
	Chr.Marker1<-c(Marker1, -Marker1); 
	Chr.Marker2<-c(Marker2, -Marker2);
	Chr.Label<-c(); Chr.No<-0;
	CGH.genes<-c();
	for(j in 1:length(Labels))
	{
		b<-c();
		x2<-0;
		for(k in 1: no.of.genes)
		{
			if(chr[k] == j){
				if(is.na(ratio[k])){
					b<-c(b, 0);
					x2<-x2+1;
				}else{
					b<-c(b, ratio[k]);
					x2<-x2+1;
				}
			}
	 	}
		x3<-c(1:x2);
		a.loess<-loess(b~x3,span=a,degree=2,family="symmetric",iterations=4,surface="direct");
		c<-c(c, rep(0,2), a.loess$fitted);
		d<-c(d,a.loess$fitted);
		e<-c(e, a.loess$residuals);
		f<-c(f, rep(0,2), a.loess$residuals);
		Chr.Label<-c(Chr.Label,((x2/2)+Chr.No+j*2));
		Chr.No<-Chr.No+length(b);
	}
#	S1<-mean(d)+sd(d)*c.thre;
	S1<-mean(d)+sd(d)*c.thre;
	S2<-mean(d)-sd(d)*c.thre;

	utest.chart<-c();
	utest.data<-c();
	for(j in 1:length(Labels))
	{
		b<-c(); q<-c();
		for(k in 1: no.of.genes){
			if(chr[k] == j){
				b<-c(b,d[k]);
				q<-c(q,k);
			}
      		}
		b.posi<-c(); b.neg<-c();
		q.posi<-c(); q.neg<-c();
		utest<-c();
		for(l in 1: length(b)){
			if(b[l]>=S1){
				b.posi<-c(b.posi, b[l]);
				q.posi<-c(q.posi, q[l]);
			}
#			if(b[l]<=-S1){
			if(b[l]<=S2){

				b.neg<-c(b.neg, b[l]);
				q.neg<-c(q.neg, q[l]);
			}
			if(length(b.posi)==0 && length(b.neg)==0){
				utest<-c(utest,"");
				CGH.genes<-c(CGH.genes,0);
			}
			if((l==length(b) || b[l]<S1) && length(b.posi)>0){
				inten.others <- d;
				inten.others <- replace(inten.others, q.posi, NA);
				u.tempt<-wilcox.test(as.numeric(inten.others), b.posi);
				
				if(u.tempt$p.value<p.thre){
					utest<-c(utest, rep(Marker1, length(b.posi)));
					CGH.genes<-c(CGH.genes,rep(1, length(b.posi)));
					Posi.chr<-c(Posi.chr, j);
				}
				else{
					utest<-c(utest, rep("", length(b.posi)));
					CGH.genes<-c(CGH.genes,rep(0, length(b.posi)));
				}
#				if(b[l]>(-S1) && b[l]<S1){
				if(b[l]>S2 && b[l]<S1){

					utest<-c(utest,"");
					CGH.genes<-c(CGH.genes,0);
				}
				b.posi<-c();
				q.posi<-c();
			}
#			if((l==length(b) || b[l]>(-S1)) && length(b.neg)>0){
			if((l==length(b) || b[l]>S2) && length(b.neg)>0){

				inten.others <- d;
				inten.others <- replace(inten.others, q.neg, NA);
				u.tempt<-wilcox.test(as.numeric(inten.others), b.neg);
				
				if(u.tempt$p.value<p.thre){
					utest<-c(utest, rep(-Marker1, length(b.neg)));
					CGH.genes<-c(CGH.genes,rep(-1, length(b.neg)));
					Posi.chr<-c(Posi.chr, j);
				}
				else{
					utest<-c(utest, rep("", length(b.neg)));
					CGH.genes<-c(CGH.genes,rep(0, length(b.neg)));
				}
#				if(b[l]>(-S1) && b[l]<S1){
				if(b[l]>S2 && b[l]<S1){

					utest<-c(utest,"");
					CGH.genes<-c(CGH.genes,0);
				}
				b.neg<-c();
				q.neg<-c();
			}
		}
		utest.chart<-c(utest.chart, rep("",2), utest);
		Chr.Marker1<-c(Chr.Marker1,rep("", (length(b))),Marker1, -Marker1);
		Chr.Marker2<-c(Chr.Marker2,rep("", (length(b))),Marker2, -Marker2);
		utest.data<-c(utest.data, utest)


	}
	#===========  Draw Charts  =============================================
	if(plot.cgh == TRUE){
		if (type=='pdfwrite') pdf(imagename,  width=12, height=9)
		else bitmap(imagename,  width=12, height=9, type=type)
		par(mfcol=c(2,1), bg="white");

		plot(x1,c, cex=0.1, ylim=c(-lim1, lim1), "l", col="blue", lwd=2, xlab="Chromosome Location", 
				ylab="", xaxt="n");
			abline(0, 0, col="red");
			lines(utest.chart,lwd=4, col="red");
			lines(Chr.Marker1, lwd=1, col="dark green");
			text(Chr.Label,Chr.Position1,labels=Labels);
			title(main=main, ylab=ylab);
		
		for( i in 1: length(utest.chart)){
		 if(utest.chart[i] == Marker1){
				utest.chart[i] <- Marker2;
			}
			if(utest.chart[i] == -(Marker1)){
				utest.chart[i] <- -(Marker2);
			}
		}

	 	plot(x1,f, cex=0.1, ylim=c(-lim2, lim2), "l", col="blue", lwd=1, xlab="Chromosome Location", 
				ylab="", xaxt="n");
			abline(0, 0, col="red");
			lines(utest.chart,lwd=4, col="red");
			lines(Chr.Marker2, lwd=1, col="dark green");
			text(Chr.Label,Chr.Position2,labels=Labels);
			title(main=main, ylab=ylab);

		dev.off() 
	}
	return(CGH.genes);
}

################################################################################
##############################   END OF CODE   #################################
################################################################################
