#!/usr/bin/env python

import os, sys

def convertImg(path, src='.pdf', obj=['.png', '.eps'], keep=True):
	# convert PDF to eps, png

	if not os.path.exists(path) or not os.path.isdir(path): return

	fmt = {'.png':'png256', '.eps':'epswrite'}
	if type(obj) is str: obj = [obj]
	obj = filter(lambda a:a in fmt, obj) # only '.png' and/or '.eps' left

	cwd = os.getcwd()
	os.chdir(path)

	lnsrc = len(src)
	fns_all = os.listdir('.')
	fns = filter(lambda a:a[-lnsrc:]==src, fns_all)
	#fns = map(lambda a:(a, a[:-lnsrc]+'.eps', a[:-lnsrc]+'.png'), fns)
	#os.system('for nm in *.pdf; do gs -sDEVICE=epswrite -sOutputFile="${nm%pdf}eps" -q "${nm}" -c quit; done; rm -rf *.pdf;')
	prog = sys.platform == 'win32' and 'gswin32c' or 'gs'
	for fsrc in fns:
		try:
			for ext in obj:
				fobj = fsrc[:-lnsrc] + ext
				if fobj not in fns_all: os.popen('%s -q -sDEVICE=%s -sOutputFile="%s" "%s" -c quit' % (prog, fmt[ext], fobj, fsrc), 'r').read()
			if not keep: os.unlink(fsrc) #os.system('rm "%s"' % fpdf)
		except: pass

	os.chdir(cwd)

