#!/usr/bin/env python

# Columns in table MicroarrasyAnalsys.requests:

# Analysis categories (category):
TYPE_NORM_ANALYSIS = 1; TYPE_NORMPCA = 2; TYPE_LINEAR_DUAL = 3; TYPE_LINEAR_AFFY = 4

#TYPE_DELETE = 50

# mpmdb operation categories:
TYPE_FILL_SINGLE = 1000; TYPE_FILL_BATCH = 1001; TYPE_FILL_FILE = 1002; TYPE_FILL_UPDATE = 1003; TYPE_REQUEST = 1004
TYPE_DBS_FILL_SINGLE=1005; TYPE_DBS_FILL_FILE = 1006; TYPE_DBS_MAPF=1007; TYPE_DBS_FILL_PROBE = 1008; TYPE_DBS_FILL_PRJANNO = 1009;
TYPE_DBS_ANALYSIS=1100
TYPE_DBS_DELREC=1200

TYPE_WEBARRAY_ANALYSIS = [TYPE_NORM_ANALYSIS, TYPE_NORMPCA, TYPE_LINEAR_DUAL, TYPE_LINEAR_AFFY]
TYPE_WEBARRAY = TYPE_WEBARRAY_ANALYSIS

TYPE_WEBARRAYDB_FILL = [TYPE_FILL_SINGLE, TYPE_FILL_BATCH, TYPE_FILL_FILE, TYPE_FILL_UPDATE, TYPE_DBS_FILL_SINGLE, TYPE_DBS_FILL_FILE, TYPE_DBS_MAPF, TYPE_DBS_FILL_PROBE, TYPE_DBS_FILL_PRJANNO,
		TYPE_DBS_DELREC
		]
TYPE_WEBARRAYDB_ANALYSIS = [TYPE_DBS_ANALYSIS]
TYPE_WEBARRAYDB = TYPE_WEBARRAYDB_FILL + TYPE_WEBARRAYDB_ANALYSIS
TYPE_WEBARRAYDB.append(TYPE_REQUEST)

TYPE_DIC = {}
for tp in TYPE_WEBARRAY_ANALYSIS: TYPE_DIC[tp] = TYPE_WEBARRAY_ANALYSIS
for tp in TYPE_WEBARRAYDB_ANALYSIS: TYPE_DIC[tp] = TYPE_WEBARRAYDB_ANALYSIS
for tp in TYPE_WEBARRAYDB_FILL: TYPE_DIC[tp] = TYPE_WEBARRAYDB_FILL

TYPE_NO_RESULT = TYPE_SHOW_ERR = TYPE_WEBARRAYDB_FILL # no result to show for these TYPEs by "fetch", then show its error_msg

TYPE_ANALYSIS = TYPE_WEBARRAY_ANALYSIS + TYPE_WEBARRAYDB_ANALYSIS #[TYPE_NORM_ANALYSIS, TYPE_NORMPCA, TYPE_LINEAR_DUAL, TYPE_LINEAR_AFFY, TYPE_DBS_ANALYSIS]

# types and related operation commands
TYPE_CMDS = {TYPE_NORM_ANALYSIS:'runR', TYPE_NORMPCA:'runR', TYPE_LINEAR_DUAL:'runR', TYPE_LINEAR_AFFY:'runR',
	TYPE_FILL_SINGLE:'fillSingle', TYPE_FILL_BATCH:'fillBatch', TYPE_FILL_FILE:'fillFile', TYPE_FILL_UPDATE:'fillUpdate', 
	TYPE_DBS_FILL_SINGLE:'fillDBs', TYPE_DBS_FILL_FILE:'fillDBs', TYPE_DBS_MAPF:'fillDBs', TYPE_DBS_FILL_PROBE:'fillDBs',
	TYPE_DBS_FILL_PRJANNO:'fillDBs', 
	TYPE_DBS_ANALYSIS:'analyzeDBs',
	TYPE_REQUEST:'reqData',
	TYPE_DBS_DELREC:'delrec'
	}
TYPE_CMDS[TYPE_FILL_SINGLE] = 'fillDBs'

# only TYPEs in TYPE_PARALLEL can be done in parallel.
TYPE_PARALLEL = [TYPE_NORM_ANALYSIS, TYPE_NORMPCA, TYPE_LINEAR_DUAL, TYPE_LINEAR_AFFY, TYPE_DBS_ANALYSIS]

TYPE_EVENT_CODE = {'register':1, 'confirm':2, 'logon':3, 'logoff':4, 
		'request':10, 'savefile':11, 'downloadsrc':12, 'savegal':13, 'addxref':14,
		'search':20, 'browse':21, 'show':22,
		'edititem':30, 'delrec':31}

# pages (used by loadparams)
PAGES = {TYPE_NORM_ANALYSIS:'pages/ui_analyze_linear_dual.pih', TYPE_LINEAR_DUAL:'pages/ui_analyze_linear_dual.pih', TYPE_LINEAR_AFFY:'pages/ui_analyze_linear_affy.pih', TYPE_NORMPCA:'pages/ui_normpca.pih', TYPE_FILL_SINGLE:'pages/dbs_fill_single.pih', TYPE_FILL_FILE:'pages/dbs_fill_file.pih', TYPE_DBS_FILL_FILE:'pages/dbs_fill_file.pih', TYPE_DBS_MAPF:'pages/dbs_mapf.pih', TYPE_DBS_FILL_PROBE:'pages/dbs_fill_probe.pih', TYPE_DBS_FILL_PRJANNO:'pages/dbs_fill_prjanno.pih', TYPE_DBS_ANALYSIS:'pages/dbs_analyze.pih'}
DBS_PAGES = {} #{'bac':'pages/dbs_bac_fill_single.pih', 'prostate':'pages/dbs_prostate_fill_single.pih'}
#DBS_PAGES['bacteria'] = DBS_PAGES['bac']
DBS_PAGE_DEFAULT = 'pages/dbs_fill_single.pih'

# Request state (req_state):
STATE_WAITING = 0; STATE_SOLVED = 1; STATE_ERROR = 2; STATE_WORKING = 3; STATE_STOPPED = 4; STATE_TO_DELETE = 5; STATE_CANCELLED = 6

# Availability:
AVAIL_NO = 0 # means disabled or deleted
AVAIL_YES = 1
