#!/usr/bin/env python

import sys
from deldbs import *

# accept pih_vars from ui
from tools import *
from cgitools import script_path_url, js_dir, username

# get default db name
exec get_dbstr()

dbnm = pih_vars.get('db', db)
tbnm = pih_vars.get('tb', '')
if not tbnm: 
	print 'Table name is not specified yet!<p><input type="button" value="Go back" onClick="JavaScript:history.go(-1)"/>'
	sys.exit(0)
rec = pih_vars.get('rec', None) # rec should be an int
if rec is None:
	print 'Record No. is not specified yet!<p><input type="button" value="Go back" onClick="JavaScript:history.go(-1)"/>'
	sys.exit(0)

cur = getCursor()

# check username
if tbnm == 'project': 
	sql_str = 'SELECT u.user_name FROM %s.project p LEFT JOIN %s.users u ON p.user_id=u.id WHERE p.id=%d' % (dbnm, db, rec)
else:
	sql_str = 'SELECT u.user_name FROM %s.%s t LEFT JOIN %s.project p ON t.project_id=p.id LEFT JOIN %s.users u ON p.user_id=u.id WHERE t.id=%d' % (dbnm, tbnm, dbnm, db, rec)
rec_host = inquireDB(sql_str, cursor=cur, fetch=True)
if not rec_host:
	print 'No such a record in projects!<p><input type="button" value="Go back" onClick="JavaScript:history.go(-1)"/>'
	sys.exit(0)
rec_host = rec_host[0][0]
if not rec_host or rec_host.lower() != username.lower():
	print 'You don\'t have privilege to delete this record!<p><input type="button" value="Go back" onClick="JavaScript:history.go(-1)"/>'
	sys.exit(0)

def prepareJS():
	print '''
<script language="JavaScript">
var script_path_url = %s;
var cur_db = %s;
</script>
<script type="text/javascript" src=%s/dbs_show_tb.js> </script>
	''' % (`script_path_url`, `dbnm`, js_dir)

def rmArray(dbnm, rec, cur):
	delArray(dbnm, rec, cur)
	return True
	
def rmSamp(dbnm, rec, cur):
	ary_id_nms = refSamp(dbnm, rec, cur)['array']
	if ary_id_nms: 
		prepareJS()
		print 'Cannot delete this sample since it is used by these arrays:<ul>'
		print '\n'.join(map(lambda a:'<li><a href="javascript:showArray(\'%s\')">%s</a></li>' % (encodeStr(str(a[0])), a[1]), ary_id_nms))
		print '</ul><p><input type="button" value="Go back" onClick="JavaScript:history.go(-1)"/>'
		return False
	delSamp(dbnm, rec, cur)
	return True

def rmProt(dbnm, rec, cur):
	rlt = refProt(dbnm, rec, cur)
	ary_id_nms, samp_id_nms = rlt['array'], rlt['sample']
	refs = False
	if ary_id_nms or samp_id_nms: 
		refs = True
		prepareJS()
		print 'Cannot delete this protocol!'
	if ary_id_nms: 
		print '<p>It is used by these arrays:<ul>'
		print '\n'.join(map(lambda a:'<li><a href="javascript:showArray(\'%s\')">%s</a></li>' % (encodeStr(str(a[0])), a[1]), ary_id_nms))
		print '</ul><p><input type="button" value="Go back" onClick="JavaScript:history.go(-1)"/>'
	if samp_id_nms: 
		print '<p>It is used by these samples:<ul>'
		print '\n'.join(map(lambda a:'<li><a href="javascript:showSamp(\'%s\')">%s</a></li>' % (encodeStr(str(a[0])), a[1]), samp_id_nms))
		print '</ul><p><input type="button" value="Go back" onClick="JavaScript:history.go(-1)"/>'
	if refs: return False
	delProt(dbnm, rec, cur)
	return True
	
def rmPf(dbnm, rec, cur):
	ary_id_nms = refPf(dbnm, rec, cur)['array']
	if ary_id_nms: 
		prepareJS()
		print 'Cannot delete this platform since it is used by these arrays:<ul>'
		print '\n'.join(map(lambda a:'<li><a href="javascript:showArray(\'%s\')">%s</a></li>' % (encodeStr(str(a[0])), a[1]), ary_id_nms))
		print '</ul><p><input type="button" value="Go back" onClick="JavaScript:history.go(-1)"/>'
		return False
	delPf(dbnm, rec, cur)
	return True

def rmPrj(dbnm, rec, cur):
	rlt = refPrj(dbnm, rec, cur)
	refs = False
	for v in rlt.values():
		if v:
			refs = True
			prepareJS()
			print 'Cannot delete this project since it is referenced by other projects!'
			break
	if refs:
		showFun = {'array':'showArray', 'sample':'showSamp', 'protocol':'showProt', 'platform':'showPf', 'project':'showPrj'}
		print '<p>Its contents are used in other projects:<ul>'
		for k,v in rlt.items():
			if not v: continue
			k1, k2 = k.split('_')
			print '\n'.join(map(lambda a:'<li>%s <a href="javascript:%s(\'%s\')">%s</a> is used by %s <a href="javascript:%s(\'%s\')">%s</a> in project <a href="javascript:showPrj(\'%s\')">%s</a></li>' % (k1, showFun[k1], encodeStr(str(a[0])), a[1], k2, showFun[k2], encodeStr(str(a[2])), a[3], encodeStr(str(a[4])), a[5]), v))
		print '</ul><p><input type="button" value="Go back" onClick="JavaScript:history.go(-1)"/>'
			
		return False

	delPrj(dbnm, rec, cur)
	return True


op_dic = {'array':rmArray, 'sample':rmSamp, 'protocol':rmProt, 'platform':rmPf, 'project':rmPrj}
fun = op_dic[tbnm]

try:
	if fun(dbnm, rec, cur):
		saveEvent(user_id=username, ev_catcode="delrec", ev_valstr='%s::%s::%d' % (dbnm, tbnm, rec), cur=cur)
		print 'The record was deleted!<p><input type="button" value="Close" onClick="JavaScript:window.close()"/>'
except:
	print '<pre>'
	import traceback
	#traceback.print_exc()
	print traceback.format_exc()
	print '</pre><p>'
	print 'Failed!<p><input type="button" value="Go back" onClick="JavaScript:history.go(-1)"/>'



