#!/usr/bin/env python

import os, sys, time, traceback, cStringIO, re, popen2
from db_vars import *
from tools import esc_sql_1, savePid, bug_report_fmt, Daemon_Host

file_path = os.path.split(os.path.abspath(__file__))[0]
__lamnodes = os.path.join(file_path, 'CLUSTER_NODES')
if not os.path.exists(__lamnodes): __lamnodes = ''
if os.path.exists(Daemon_Host): exec open(Daemon_Host).read()
if 'lam_dir' not in globals(): lam_dir = ''
if lam_dir: 
	lamnode, lamboot, lamhalt = os.path.join(lam_dir, 'lamnodes'), os.path.join(lam_dir, 'lamboot'), os.path.join(lam_dir, 'lamhalt')
else: lamnode, lamboot, lamhalt = 'lamnodes', 'lamboot', 'lamhalt'

def htmlStr(s): return s.replace('\n','<br>').replace('"', "''")

def runR_in_Pipe(CMDS=[], req_id=None, RCMD='R', R_code_dir=None, line_tail=';\n'):
	# search R in R_code_dir first, then in file_path, then in $PATH
	if R_code_dir:
		lcwd = os.getcwd()
		os.chdir(R_code_dir)
		if os.path.exists(RCMD): RCMD = os.path.realpath(RCMD)
		else:
			RCMD_full = os.path.join(file_path, RCMD)
			if os.path.exists(RCMD_full): RCMD = os.path.realpath(RCMD_full)			
	else:
		RCMD_full = os.path.join(file_path, RCMD)
		if os.path.exists(RCMD_full): RCMD = os.path.realpath(RCMD_full)

	error_head = '<h1>Error Message</h1><br><p>'
	R_halt_str = re.compile(r'\nExecution halted\n*\Z')
	rlt = None
	error_msg = []

	if not CMDS:
		error_msg.append('No code to feed R!')
	else:
		try:
			#CMDS.append('q(save="no")' )
			#Rin, Rout = os.popen4('%s --vanilla --quiet' % RCMD)
			if hasattr(popen2, 'Popen4'):
				Robj = popen2.Popen4('%s --vanilla' % RCMD)
				pid, Rin, Rout = Robj.pid, Robj.tochild, Robj.fromchild
				savePid(req_id, pid=pid)
			else: Rin, Rout = os.popen4('%s --vanilla' % RCMD)
			for cmd in CMDS: os.write(Rin.fileno(), cmd + line_tail)
			Rin.close()
			rlt = Rout.read()
			Rout.close()
		except: 
			rlt = None
			error_msg.append('Error happened in R: <p>') #might caused by wrong parameters from user.')
			cfile = cStringIO.StringIO()
			traceback.print_exc(None,cfile)
			value = htmlStr(cfile.getvalue())

			err_tk = 'error: '
			err_st = value.find(err_tk)
			if err_st >= 0: value = value[err_st+len(err_tk):]
			error_msg.append(value)

	if R_code_dir: os.chdir(lcwd)
			
	# try...except seems not be able to detect error in R even if R halts. Then codes needed here
	if rlt and R_halt_str.search(rlt): error_msg.append(htmlStr(rlt))
			
	date_time = time.strftime('%Y-%m-%d %H:%M:%S', time.gmtime())
	if error_msg:
		error_msg.insert(0, error_head)
		error_msg.append(bug_report_fmt)
		msg = esc_sql_1.sub(r'\\\1', ' '.join(error_msg))
		req_state = STATE_ERROR
		sql_update = req_id and 'UPDATE requests SET req_state=%d, solve_time="%s", error_msg="%s" WHERE req_id=%d' % (req_state, date_time, msg, req_id) or ''
	else: 
		req_state = STATE_SOLVED
		sql_update = req_id and 'UPDATE requests SET req_state=%d, solve_time="%s" WHERE req_id=%d' % (req_state, date_time, req_id) or ''
	#sys.stdout.write( cPickle.dumps( (rlt, sql_update) ) )
	#sys.stdout.close()
	return rlt, sql_update

def initLam():
	try:
		shin, shout = os.popen4(lamnode)
		shin.close()
		msg = shout.read()
		shout.close()
		if lamboot not in msg: # lamboot already in running
			return False
		os.popen('%s %s' % (lamboot, __lamnodes))
		return True
	except: return False

def stopLam():
	try:
		#shin, shout = os.popen4('lamhalt')
		#shin.close()
		#msg = shout.read()
		#shout.close()
		os.spawnlp(os.P_NOWAIT, lamhalt)
	except: pass

def pipeR(CMDS=[], req_id=None, RCMD='R', R_code_dir=None, line_tail=';\n', init_lam=True):
	try:	
		if init_lam: lamhalt = initLam()
		rlt = runR_in_Pipe(CMDS=CMDS, req_id=req_id, RCMD=RCMD, R_code_dir=R_code_dir, line_tail=line_tail)
		#if init_lam and lamhalt: stopLam() #os.popen('lamhalt')
	except:
		#if init_lam and lamhalt: stopLam() #os.popen('lamhalt')
		cfile = cStringIO.StringIO()
		traceback.print_exc(None,cfile)
		value = htmlStr(cfile.getvalue())
		#os.write(sys.stdout.fileno(), cPickle.dumps( ('Nothing done', value) ) )
		rlt = 'Nothing done', value
	return rlt
	
