
#getGeneLoc <- function(idx_reg, getGeneIdx, gene_name=gene_name, probe_pos=probe_pos, gene_strand=gene_strand) { # use global variables: gene_name, probe_pos, gene_strand -->> Now these are parameters
getGeneLoc <- function(idx_reg, getGeneIdx, gene_name, probe_pos, gene_strand) { # use global variables: gene_name, probe_pos, gene_strand -->> Now these are parameters
	#GeneInSect <- gene_name[idx_reg]
	GeneIdx <- getGeneIdx(gene_name[idx_reg]) # a list with gene_name as names and a vectors of idx as value
	nms <- names(GeneIdx)
	# remove the blank name
	if (length(nms)>0 && nms[1]=='') { GeneIdx[1] <- NULL; nms <- nms[-1] }
	# remove 'IR ' names
	idx <- grep('^IR ', nms)
	if (length(idx)>0) {GeneIdx[idx] <- NULL; nms <- nms[-idx]}
	if (length(nms)==0) {return(data.frame())}
	#vals <- sapply(nms, function(x) {ix <- idx_reg[GeneIdx[[x]]]; y <- probe_pos[ix]; c(min(y), max(y), gene_strand[ix][1])})
	#vals <- sapply(GeneIdx, function(x) {ix <- idx_reg[x]; y <- probe_pos[ix]; c(min(y), max(y), gene_strand[ix[1]])})
	# vals will be converted to char in R-2.8, so use following codes instead.
	vals <- sapply(GeneIdx, function(x) {ix <- idx_reg[x]; y <- probe_pos[ix]; c(min(y), max(y))}) #, gene_strand[ix[1]])})
	vals <- if (is.null(vals)) rbind(vals) else t(vals)
	vals <- cbind(as.data.frame(vals), sapply(GeneIdx, function(x) gene_strand[idx_reg[x[1]]]) )
	dimnames(vals) <- list(nms, c('gene_start', 'gene_end', 'gene_strand_sec'))
	vals[grep('\\+|-', vals$gene_strand_sec),]
	}

#getTnPos <- function(idx, pos, tn_token=Tn_token, val=1) {
getTnPos <- function(tn_token, pos, val=1) {
	# return coordinates for transposons
	#x <- pos[which(Tn_token[idx] == val)]
	#x <- if (val==1) pos[which(Tn_token[idx] == val)] else pos[which(Tn_token[idx] < -0.09999)] # -1.0 cannot be exactly equal to !!!
	#browser()
	if (TRUE || val > 0) val <- val*2
	#x <- pos[which(Tn_token[idx] == as.integer(val))] #*2))]
	x <- pos[which(tn_token == as.integer(val))] #*2))]
	x <- c(rbind(x, x, rep(NA, length=length(x))))
	y <- rep(c(15.5, 15.9, NA), length=length(x))
	#if (!is.null(fn_log)) cat2File(paste(time_now <- Sys.time(), {time_dif <- format(time_now-time_last); time_last <<- time_now; time_dif}, paste(length(x), 'transposons (', val, ')\n'), sep='\t'), filename=fn_log)
	return(list(x=x, y=y))
	}

#getSigIdxParam4Line <- if(is.null(MetaP)) NULL else function(MetaP_idx, pos, MN, pv=SigP) {
getSigIdxParam4Line <- function(MetaP_idx, pos, MN, pv) {
	# return coordinates of for probe with significant p-values
	#pidx <- MetaP[idx] < pv
	pidx <- MetaP_idx < pv
	pidx <- which(pidx[-length(pidx)] & pidx[-1]) 
	#x <- idx[pidx]
	NAs <- rep(NA, times=length(pidx))
	#x <- pos[as.vector(rbind(x, idx[pidx+1], NAs))]
	x <- pos[as.vector(rbind(pidx, pidx+1, NAs))]
	y <- rep(16.9, times=length(x))
	#color <- ifelse(MN[pidx]<0, colorP, colorN)
	#color <- as.vector(rbind(color, color, NAs))
	#if (!is.null(fn_log)) cat2File(paste(time_now <- Sys.time(), {time_dif <- format(time_now-time_last); time_last <<- time_now; time_dif}, paste(length(x), 'sig p values\n'), sep='\t'), filename=fn_log)
	return(list(x=x, y=y))#, color=color))
	}

#getSigIdxParam4Point <- if(is.null(MetaP) || !p_label) NULL else function(idx, pos, MN, colorP='red', colorN='pink', pv=SigP) {
getSigIdxParam4Point <-  function(MetaP_sect, pos, MN, colorP='red', colorN='pink', pv=0.001) {
	# return coordinates of for probe with significant p-values
	#pidx <- which(MetaP[idx] < pv)
	pidx <- which(MetaP_sect < pv)
	x <- pos[pidx]
	y <- rep(17.3, times=length(x))
	color <- if(is.null(MN)) colorP else ifelse(MN[pidx]<0, colorP, colorN)
	return(list(x=x, y=y, color=color))
	}
#getSigIdxParam <- getSigIdxParam4Point

decideNrow <- function(n) {
	if (n <= 30) return(c(3, 2, 3, 4, 5, 3, 4, 4, 3, 5,    4, 4, 3, 5, 5, 4, 3, 3, 4, 4,    3, 4, 4, 4, 5, 3, 3, 4, 3, 3)[n])
	ns <- c(4, 3, 5)
	md <- n_ary %% ns
	md0 <- which(md == 0)
	if (any(md0)) return(ns[md0[1]])
	}

plotGenome <- function(R, G, M, A, probe_pos, probe_strand, gene_name, gene_strand, file_prefix, len_sect=10000, n_sect=as.integer(max(probe_pos, na.rm=TRUE)/len_sect)+1, plot_pdf=FALSE, tn_analysis=FALSE, tn_token, getGeneIdx, p_label=TRUE, MetaP=NULL, SigP=0.001, max_chart=NULL, bac_cgh=FALSE, fn_log=NULL, other_params=NULL){

	#time_last <- Sys.time()
	#if (!is.null(fn_log)) cat2File(paste(time_now <- Sys.time(), {time_dif <- format(time_now-time_last); time_last <- time_now; time_dif}, 'PlotCGH 0\n', sep='\t'), filename=fn_log)

	ext <- if (plot_pdf) '.pdf' else '.png'
	fmt <- paste('%0', nchar(n_sect), 'd', sep='')
	if (!is.null(max_chart) && max_chart <= 0) max_chart <- NULL
	#M <- R - G
	#A <- rowMeans(cbind(R, G)) #if (is.null(dim(R))) rowMeans(cbind(R, G)) else apply(array(c(R, G), dim=c(dim(R),2)), c(1,2), mean)
	AveA <- if (is.null(dim(A))) mean(A, na.rm=TRUE) else colMeans(A, na.rm=TRUE) #mean(c(R, G), na.rm=TRUE) # 12
	A_half <- if (is.null(dim(A))) quantile(A, 0.5, na.rm=TRUE)[[1]] else apply(A, 2, function(x) quantile(x, 0.5, na.rm=TRUE)[[1]]) # A / 2
	getRealGeneIdx <- function(nm, GeneInSect) { # for future use?
		idx <- grep(paste('((^\\s*)|(\\+\\s*))', nm, sep=''), GeneInSect, perl=TRUE, value=FALSE)
		}

	plotOneSect <- function(idx, strand, main_title, reg_start, reg_end, n_gene, gene_name_sec, gene_strand_sec, gene_start, gene_end, colorP, colorN, tn_val, draw_both=FALSE, is_first=TRUE, is_last=TRUE, pch_start=24, pch_end=25) {
		if (is.null(G)) 
			plot(probe_pos[idx], R[idx], pch=".", xlab="Genome location", ylab="Intensity (log2)", ylim=c(7,17.4), type="l", col="green", main=main_title, xlim=c(reg_start, reg_end))
		else {
			plot(probe_pos[idx], G[idx], pch=".", xlab="Genome location (BROWN: input; GREEN: output)", ylab="Intensity (log2)", ylim=c(7,17.4), type="l", col="brown", main=main_title, xlim=c(reg_start, reg_end))
			lines(probe_pos[idx], R[idx], pch=".", col="green") }
		abline(h=AveA, col="grey")
		if (n_gene > 0) {
			gene_color <- ifelse(gene_strand_sec == '+', 'red', 'blue'); #pch_start <- 24; pch_end <- 25
			ys <- rep(c(x_up, x_low), length=n_gene)
			gname <- gsub('STMsR0*|PSLT0*|STM0*', '', gene_name_sec)
			if (!draw_both) {
				ix <- which(gene_strand_sec != strand)
				ys[ix] <- NA
				gname[ix] <- NA
				}
			if (is_first) points(gene_start, ys, col=gene_color, pch=pch_start) 
			else { imin <- which(gene_start == min(gene_start)); points(gene_start[-imin], ys[-imin], col=gene_color[-imin], pch=pch_start) }
			if (is_last) points(gene_end, ys, col=gene_color, pch=pch_end) 
			else { imax <- which(gene_end == max(gene_end)); points(gene_end[-imax], ys[-imax], col=gene_color[-imax], pch=pch_end) }
			ys <- rep(c(t_up, t_low), length=n_gene)
			text(rowMeans(cbind(gene_start, gene_end)), ys, gname, col=gene_color)
			}
		#if(!is.null(getSigIdxParam4Point)) { # draw box for pos with significant p value
		if(p_label && !is.null(MetaP)) { # draw box for pos with significant p value
			#params <- getSigIdxParam4Point(idx, probe_pos[idx], M[idx], colorP=colorP, colorN=colorN)
			params <- getSigIdxParam4Point(MetaP[idx], probe_pos[idx], M[idx], colorP=colorP, colorN=colorN, pv=SigP)
			points(params, pch=22, col=params$color)
			}
		if (tn_analysis) {
			#if(!is.null(getTnPos)) lines(getTnPos(idx, probe_pos[idx], val=tn_val), col=col_tn) # the vertical bar
			lines(getTnPos(tn_token[idx], probe_pos[idx], val=tn_val), col=col_tn) # the vertical bar
			#if(!is.null(getSigIdxParam4Line)) { # draw horizontal bar for adjacent pos with significant p value
			if(!is.null(MetaP)) lines(getSigIdxParam4Line(MetaP[idx], probe_pos[idx], M[idx], SigP), lwd=3, col=col_tn_p)
			}
		}

	# plot genome
	col_tn <- col_tn_p <- 'purple'
	if (!is.null(M)) {
		min_M <- min(c(min(M)-0.2, -3)) # -3
		max_M <- max(c(max(M)+2, 6.5)) # 6.5
		plotTx.M <- 5.7*max_M/6.5; M_text <- 6.1*max_M/6.5 }
	x_low <- 15.2; x_up <- 16.2
	t_low <- 14.8; t_up <- 16.6
	plotTx.A <- x_up;  A_text <- t_up
	n_chart <- 0
	pch_start <- 24; pch_end <- 25
	if (is.null(other_params)) {
		thresh_1 <- log2(0.33); txt_m1 <- '0.33'
		thresh_2 <- log2(0.67); txt_m2 <- '0.67'
		thresh_3 <- log2(1.5); txt_m3 <- '1.5'
		}
	else {
		if (is.null(other_params$cgh_m1)) { thresh_1 <-log2(0.33); txt_m1 <- '0.33'}
		else { 
			txt_m1 <- other_params$cgh_m1
			thresh_1 <- eval(parse(text=txt_m1))
			if (thresh_1 > 0) thresh_1 <- log2(thresh_1) 
			else {txt_m1 <- '0.33'; thresh_1 <- log2(0.33);}
			}
		if (is.null(other_params$cgh_m2)) { thresh_2 <-log2(0.67); txt_m2 <- '0.67'}
		else { 
			txt_m2 <- other_params$cgh_m2
			thresh_2 <- eval(parse(text=txt_m2)) 
			if (thresh_2 > 2^thresh_1) thresh_2 <- log2(thresh_2)
			else {
				thresh_2 <- 2^thresh_1 + 0.5
				txt_m2 <- as.character(thresh_2)
				thresh_2 <- log2(thresh_2)}
			}
		if (is.null(other_params$cgh_m3)) { thresh_3 <-log2(1.5); txt_m3 <- '1.5'}
		else { 
			txt_m3 <- other_params$cgh_m3
			thresh_3 <- eval(parse(text=txt_m3)) 
			if (thresh_3 > thresh_2) thresh_3 <- log2(thresh_3) 
			else {
				thresh_3 <- log2(2^thresh_2 + 0.5)
				txt_m3 <- as.character(thresh_3)
				thresh_3 <- log2(thresh_3) }
			}
		}

	if (!bac_cgh || is.null(dim(A))) n_row <- 3
	else {
		n_row <- decideNrow(ncol(A))
		fmtcol <- paste('%0', nchar(ncol(A)), 'd', sep='')
		}
	dev_on <- FALSE

	# plot ratio and both strand
	for(i in 1: n_sect){
		if (!is.null(max_chart) && n_chart >= max_chart) {
			if (dev_on) {dev.off(); dev_on <- FALSE}
			break}
		is_first <- i == 1
		is_last <- i == n_sect
		reg_start <- (i-1)*len_sect
		reg_end   <-  i*len_sect
		#idxRegin <- sort(intersect(which(probe_pos >= reg_start),which(probe_pos < reg_end)))
		idx_reg <- sort(which(probe_pos >= reg_start & probe_pos < reg_end)) 
		if (!bac_cgh) {
			idxP <- idx_reg[which(probe_strand[idx_reg] == "+")]
			idxN <- idx_reg[which(probe_strand[idx_reg] == "-")]
			if(length(idxP) ==  0 || length(idxN) == 0) next
			idxPM <- if (is.null(M)) idxP else idxP[which(M[idxP] != 0)]
			idxNM <- if (is.null(M)) idxN else idxN[which(M[idxN] != 0)]			
			}
		vals <- getGeneLoc(idx_reg, getGeneIdx, gene_name, probe_pos, gene_strand)
		gene_name_sec <- rownames(vals)
		n_gene <- nrow(vals)
		gene_start <- vals$gene_start #unlist(vals[, 'gene_start'])
		gene_end <- vals$gene_end #unlist(vals[, 'gene_end'])
		gene_strand_sec <- vals$gene_strand_sec #unlist(vals[, 'gene_strand_sec'])

		plotRatio <- function(M, plotNM, arynm=NULL) {
			if (!dev_on) {
				#plotNM <- paste(file_prefix, "_both_strand_", sprintf(fmt, i), ext, sep="")
				if (plot_pdf) pdf(plotNM, pointsize=15, height=4*n_row, width=24) else bitmap(plotNM, type='png256', pointsize=15, height=4*n_row, width=24) #png(filename=plotNM,height=800,width=1600)
				par(mfrow=c(n_row,1), cex=0.66, cex.axis=1, cex.lab=1, cex.main=1.2, cex.sub=1)
				dev_on <<- TRUE}
			if (bac_cgh) {
				#col <- sapply(abs(M[idx_reg]), function(x) if (x>=thresh_3) 'green' else if(x>=thresh_2) 'black' else if (x>=thresh_1) "blue" else "indianred1")
				#col <- sapply(M[idx_reg], function(x) if (x>=thresh_3) 'green' else if(x>=thresh_2) 'black' else if (x>=thresh_1) "blue" else "indianred1")
				col <- sapply(M[idx_reg], function(x) if (x>=thresh_3) 'green' else if(x>=thresh_2) 'grey' else if (x>=thresh_1) "blue" else "indianred1")
				#plot(probe_pos[idx_reg], M[idx_reg], pch=19, xlab=sprintf("Genome location (RED: M < log2(%s); BLUE: M < log2(%s); BLACK: M < log2(%s); GREEN: M >= log2(%s) )", txt_m1, txt_m2, txt_m3, txt_m3), ylab="Log2(Ratio)", ylim=c(-3, 6.5), main=if(is.null(arynm)) "RATIO" else paste('RATIO:', arynm), type='h', col=col, xlim=c(reg_start,reg_end))
				plot(probe_pos[idx_reg], M[idx_reg], pch=19, xlab=sprintf("Genome location (RED: M < log2(%s); BLUE: M < log2(%s); BLACK: M < log2(%s); GREEN: M >= log2(%s) )", txt_m1, txt_m2, txt_m3, txt_m3), ylab="Log2(Ratio)", ylim=c(min_M, max_M), main=if(is.null(arynm)) "RATIO" else paste('RATIO:', arynm), col=col, xlim=c(reg_start,reg_end))
				}
			else {
				col <- rep('red', length(idxPM))
				col[which(A[idxPM] < A_half)] <- 'lightpink' #'grey'
				plot(probe_pos[idxPM], M[idxPM], pch=19, xlab="Genome location (RED: positive strand; BLUE: negative strand; FAINT COLOR: with A values below the median)", ylab="Log2(Ratio)", ylim=c(min_M, max_M), main="RATIO", col=col, xlim=c(reg_start,reg_end))
				col <- rep('blue', length(idxNM))
				col[which(A[idxNM] < A_half)] <- 'lightblue' #'lightblue' #'grey'
				points(probe_pos[idxNM], M[idxNM], col=col, pch=19)
				}
			abline(h=0, col="dark grey")
			if (n_gene > 0) {
				gene_color <- ifelse(gene_strand_sec == '+', 'red', 'blue') 
				ys <- rep(c(5.7*max_M/6.5, 4.8*max_M/6.5), length=n_gene)
				if (is_first) points(gene_start, ys, col=gene_color, pch=pch_start) 
				else { imin <- which(gene_start == min(gene_start)); points(gene_start[-imin], ys[-imin], col=gene_color[-imin], pch=pch_start) }
				if (is_last) points(gene_end, ys, col=gene_color, pch=pch_end) 
				else { imax <- which(gene_end == max(gene_end)); points(gene_end[-imax], ys[-imax], col=gene_color[-imax], pch=pch_end) }
				gname <- gsub('STMsR0*|PSLT0*|STM0*', '', gene_name_sec)
				ys <- rep(c(6.1*max_M/6.5, 4.4*max_M/6.5), length=n_gene)
				text(rowMeans(cbind(gene_start, gene_end)), ys, gname, col=gene_color)
				}
			}

		if (bac_cgh) {
			if (is.null(dim(M)) || ncol(M)==1) {
				n_chart <- n_chart + 1
				plotRatio(M, plotNM=paste(file_prefix, "_both_strand_", sprintf(fmt, i), ext, sep=""))
				if (dev_on && (n_chart %% n_row) == 0) {dev.off(); dev_on <- FALSE}
				}
			else {
				clnm <- colnames(M)
				for (cl in seq(ncol(M))) {
					n_chart <- n_chart + 1
					plotRatio(M=M[,cl], plotNM=paste(file_prefix, "_both_strand_", sprintf(fmt, i), '_', sprintf(fmtcol, cl), ext, sep=""), arynm=clnm[cl])
					if (dev_on && (n_chart %% n_row) == 0) {dev.off(); dev_on <- FALSE}
					}
				}
			}
		else {
			n_chart <- n_chart + 1
			if (!is.null(M)) plotRatio(M, plotNM=paste(file_prefix, "_both_strand_", sprintf(fmt, i), ext, sep=""))
			else {
				plotNM <- paste(file_prefix, "_both_strand_", sprintf(fmt, i), ext, sep="")
				if (plot_pdf) pdf(plotNM, pointsize=15, height=4*2, width=24) else bitmap(plotNM, type='png256', pointsize=15, height=4*2, width=24) #png(filename=plotNM,height=800,width=1600)
				par(mfrow=c(2,1), cex=0.66, cex.axis=1, cex.lab=1, cex.main=1.2, cex.sub=1)
				}
			plotOneSect(idxP, strand='+', main_title="INTENSITY - POSITIVE STRAND", reg_start, reg_end, n_gene, gene_name_sec, gene_strand_sec, gene_start, gene_end, colorP='red', colorN='pink', tn_val=1, is_first=is_first, is_last=is_last, pch_start=pch_start, pch_end=pch_end)
			plotOneSect(idxN, strand='-', main_title="INTENSITY - NEGATIVE STRAND", reg_start, reg_end, n_gene, gene_name_sec, gene_strand_sec, gene_start, gene_end, colorP='blue', colorN='lightblue', tn_val=-1, is_first=is_first, is_last=is_last, pch_start=pch_start, pch_end=pch_end)
			dev.off()
			dev_on <- FALSE
			}
		}
	if (dev_on) dev.off()
	if (bac_cgh) return()

	# plot one strand
	plotOneStrand <- function(strand='+', file_token='_pos_strand_', main_title='INTENSITY - POSITIVE STRAND', colorP='red', colorN='pink', tn_val=1, pch_start=24, pch_end=25) {
		n_sectlot <- n_chart <- 0
		for(i in 1: n_sect){
			if (!is.null(max_chart) && n_chart >= max_chart) break		
			is_first <- i == 1
			is_last <- i == n_sect
			reg_start <- (i-1)*len_sect
			reg_end   <-  i*len_sect
			
			idx_reg <- sort(intersect(which(probe_pos >= reg_start),which(probe_pos < reg_end)))
			idx <- idx_reg[which(probe_strand[idx_reg] == strand)]
			if(length(idx) ==  0) {
				if(n_sect == i) try(dev.off(), silent=TRUE)
				next}
			
			vals <- getGeneLoc(idx_reg, getGeneIdx, gene_name, probe_pos, gene_strand)
			gene_name_sec <- rownames(vals)
			n_gene <- nrow(vals)
			gene_start <- vals$gene_start #unlist(vals[, 'gene_start'])
			gene_end <- vals$gene_end #unlist(vals[, 'gene_end'])
			gene_strand_sec <- vals$gene_strand_sec #unlist(vals[, 'gene_strand_sec'])
			
			if(n_sectlot == 4){	dev.off(); 	n_sectlot <- 0; n_chart <- n_chart + 1; if (!is.null(max_chart) && n_chart >= max_chart) break }
			if(n_sectlot == 0){
				n_pic <- min(4, n_sect-i+1)
				plotNM <- paste(file_prefix, file_token, sprintf(fmt, i), ext, sep="")
				if (plot_pdf) pdf(plotNM, pointsize=15, height=16.5*n_pic/4, width=24) else bitmap(plotNM, type='png256', pointsize=15, height=16.5*n_pic/4, width=24) 
				par(mfrow=c(n_pic,1), cex=0.66, cex.axis=1, cex.lab=1, cex.main=1.2, cex.sub=1) #4,1))
				}
			n_sectlot <- n_sectlot + 1
					
			#if(length(idx) ==  0) next
			plotOneSect(idx, strand, main_title, reg_start, reg_end, n_gene, gene_name_sec, gene_strand_sec, gene_start, gene_end, colorP, colorN, tn_val, draw_both=FALSE, is_first=is_first, is_last=is_last, pch_start=pch_start, pch_end=pch_end)
			if(n_sect == i) dev.off()
			}
		}	
	# plot for positive strand
	#plotOneStrand(strand='+', file_token='_pos_strand_', main_title='INTENSITY - POSITIVE STRAND', colorP='red', colorN='pink', tn_val=1, pch_start=pch_start, pch_end=pch_end) 
	# plot for Negative strand
	#plotOneStrand(strand='-', file_token='_neg_strand_', main_title='INTENSITY - NEGATIVE STRAND', colorP='blue', colorN='light blue', tn_val=-1, pch_start=pch_start, pch_end=pch_end) 
	
	}


