#!/usr/bin/env python

from types import *

def NoneStr(obj): return 'NULL'

def BoolStr(obj): return obj and 'TRUE' or 'FALSE'

def ReprStr(obj): return repr(obj)

def LongStr(obj):  
	rtn = repr(obj)
	if rtn[-1] == 'L': rtn = rtn[:-1]
	return rtn

def SeqStr(obj, head='c(', tail=')'):
	if not obj: return head+tail
	# detect types
	tp0 = type(obj[0])
	simple_types = [str, int, long, float]
	num_types = [int, long, float]
	if tp0 not in simple_types: head = 'list('
	else:
		tps = (tp0 == StringType) and [StringType] or num_types
		for i in obj[1:]:
			if type(i) not in tps:
				head = 'list('
				break
	# convert
	return head + ', '.join(map(getStr, obj)) + tail

def DictStr(obj):
	return 'list(' + ', '.join(map(lambda a:'%s=%s' % (getStr(a[0]), getStr(a[1])), obj.items())) + ')'

str_func = {NoneType:NoneStr, bool:BoolStr, long:LongStr, list:SeqStr, tuple:SeqStr, dict:DictStr}

def getStr(obj):  
	return str_func.get(type(obj), repr)(obj) 

