function HideShow(dv, obj) {
	if (typeof(dv) == 'string') dv = document.getElementById(dv)
	if (!dv) return
	//dv.style.visibility = dv.style.visibility!='hidden' ? 'hidden' : 'visible'
	dv.style.display = dv.style.display!='none' ? 'none' : 'inline'
	if (obj != undefined) obj.value = dv.style.display=='none' ? 'Show advanced options' : 'Hide advanced options'
	}

function updateDisplay() {
	chkMatchBy(document.getElementsByName(match_method)[0])
	chkNormXpf(document.getElementsByName(norm_x_pf)[0])
	var mtd = document.anaform[mtd_dif]
	mtd = mtd.options[mtd.selectedIndex].value
	chkDifMethod(mtd)
	chkMetaMethod()
	}

function chkRelatives(obj) {
	var i, nobj, relatives = ['tn_analysis', 'bac_cgh']
	if(obj.checked) 
		for (i in relatives) {
			nobj = document.getElementsByName(relatives[i])[0]
			if (nobj.name != obj.name && nobj.checked) nobj.checked =  false
			}
	}

function changeMethod(nm_obj, nm_ratio_by, nm_use_ratio) {
	// need to use global variable "use_ratio_changed
	var obj = document.anaform[nm_obj] //.analysis_method
	var val = obj.options[obj.selectedIndex].value
	var i, ratio_by = document.anaform[nm_ratio_by] //.ratio_by
	if (val == 'LIMMA') { // disable other options
		for (i=0; i<ratio_by.length; i++) {
			if (ratio_by[i].value == 'array') ratio_by[i].checked = true
			else ratio_by[i].disabled = true
			}
		}
	else { //enable other options
		for (i=0; i<ratio_by.length; i++) 
			if (ratio_by[i].disabled) ratio_by[i].disabled = false
		}
	
	// change option display
	chkDifMethod(val)
	// now set default values
	if (use_ratio_changed) return
	var vals_dic = {'LIMMA':'yes', 'ttest':'no', 'ANOVA':'no', 'nonPara':'no', 'SAM':'no'}
	var val = vals_dic[obj.options[obj.selectedIndex].value]
	var obj_ratio = document.anaform[nm_use_ratio] //.use_ratio
	for (i=0; i<obj_ratio.length; i++) {
		if (obj_ratio[i].value == val) {
			obj_ratio[i].checked = true
			break
			}
		}
	}

function chkDifMethod(val) {
	var dv_block = document.getElementById('dv_block')
	var dv_anova = document.getElementById('dv_anova')
	if (val == 'none' || val == 'get_data' || val == 'fold') {
		dv_anova.style.display = 'none'
		dv_block.style.display = 'none'
		}
	else if (val == 'ANOVA') {
		dv_anova.style.display = 'inline'
		dv_block.style.display = 'inline'
		}
	else {
		dv_anova.style.display = 'none'
		dv_block.style.display = 'inline'
		}
	}

function chkMatchBy(sel) {
	// need to use global variable "use_ratio_changed
	dv_pbf = document.getElementById('match_by_mapping_file')
	dv_ucl = document.getElementById('match_by_user_cols')
	if (sel.value == 'probe-mapping file') {
		dv_pbf.style.display = 'inline'
		dv_ucl.style.display = 'none'
		}
	else if (sel.value == 'user-specified columns') {
		dv_pbf.style.display = 'none'
		dv_ucl.style.display = 'inline'
		}
	else {
		dv_pbf.style.display = 'none'
		dv_ucl.style.display = 'none'
		}	
	}

function showDivByIds(dvid, ids) { // By ID or name of "checkbox" or "radio"
	//debugger;
	var aid, obj, objs, i, j
	var dv = document.getElementById(dvid)
	if (dv == null) {
		dv = getElementsByName(dvid)
		if (dv.length != 1) return
		dv = dv[0]
		}
	var disp = 'none', goon=true
	for (i=0; i<ids.length; i++) {
		aid = ids[i]
		objs = document.getElementById(aid)
		if (objs == null) {
			objs = document.getElementsByName(aid)
			if (objs.length == 0) continue
			}
		else objs = [objs]
		for (j=0; j<objs.length; j++) {
			obj = objs[j]
			if (obj.type=='checkbox') {
				if (obj.checked) {
					disp = 'inline'
					goon = false
					break}	 
				}
			else if (obj.type=='radio') {
				if (obj.value == 'yes' && obj.checked) {
					disp = 'inline'
					goon = false
					break}	 
				}
			}
		if (!goon) break
		}
	dv.style.display = disp
	}

function chkMetaMethod() {
	showDivByIds("dv_clust", ["clust_chs", "clust_grps"])
	showDivByIds("dv_heatmap", ["plot_heatmap_chs", "plot_heatmap_grps"])
	showDivByIds("dv_coa", ["coa_analysis"])
	showDivByIds("dv_bga", ["bga_analysis"])
	showDivByIds("dv_genome", ["plot_genome"])
	}

function chkNormXpf(sel) {
	dv_bin = document.getElementById('NumberOfBin')
	if (sel.value == 'qd') dv_bin.style.display = 'inline'
	else dv_bin.style.display = 'none'
	}

function addArrays() {
	waiting_selection = document.getElementById(src_arrays)
	//waiting_names = user_cols[tbnm]
	//window.open(script_path_url+'/ui/dbs_search_adb_long.pih:{"choose_db":1,"obj_tb":"array","return_value":1}', 'Add_arrays', 'scrollbars=yes,menubar=no,height=480,width=900,resizable=yes,toolbar=no,location=no,status=no')
	target_win=window.open(script_path_url+'/ui/dbs_search_tbs.pih:{"choose_db":1,"obj_tb":"array","return_value":1}', 'Add_arrays', 'scrollbars=yes,menubar=no,height=480,width=900,resizable=yes,toolbar=no,location=no,status=no')
	// or window.open('<%=script_path_url%>/ui/dbs_search_adb.pih:{"choose_db":1,"obj_tb":"array","return_value":1}', 'Add_arrays', 'scrollbars=yes,menubar=no,height=360,width=250,resizable=no,toolbar=no,location=no,status=no')
	setTimeout('target_win.focus()', 1)
	}

function addOption(sel, val, txt) {
	sel.options[sel.length++].value = val
	sel.options[sel.length-1].text = txt
	}

function delSels(sel) {
	// delete selected items from multiple selection
	var i
	for (i=sel.length-1; i>=0; i--)
		if (sel.options[i].selected) sel.options[i] = null
	}


function addOneRow(tbid) {
	var mytb = (typeof(tbid)=='object') ? tbid : document.getElementById(tbid)
	var mytbbd = mytb.getElementsByTagName('tbody').item(0) //.appendChild(mytb.item[0])
	var myrow = mytbbd.getElementsByTagName('tr').item(0)
	var mytds = myrow.getElementsByTagName('td')
	var newrow = document.createElement('tr')
	//newrow.innerHTML = myrow.innerHTML
	mytbbd.appendChild(newrow)
	for (i=0; i < mytds.length; i++) {
		var newtd = document.createElement('td')
		newtd.innerHTML = mytds.item(i).innerHTML
		newtd.width = mytds.item(i).width
		newrow.appendChild(newtd)
		}
	//mytbbd.appendChild(newrow)
	return(newrow)
	}

function findItemByName(items, nm) {
	var i, obj
	for (i=0; i<items.length; i++) {
		obj = items[i].attributes
		if (obj && obj.getNamedItem('name') && obj.getNamedItem('name').value==nm) return(i)
		}
	return(-1)
	}

function getDbpfs(within) {
	// return a list: [ [dbid_pfid, ...], [dbnm::pfnm, ...] ]
	if (within == undefined) within = document
	var i, j, ids=[], nms=[], sels=within.getElementsByTagName('SELECT')
	var opts, val, txt, vtdic={}
	var reval=/^(.+_\d+)_\d+_\d+$/ // dbnm_pfid_arrayid_chN     match[1] will get dbnm_pfid
	var retxt=/^.+\s+\((.+::.+)\)$/ // arrayname [- ChN/Ration ](pfnm::dbnm)    match[1] get pfnm::dbnm
	for (i=0; i<sels.length; i++) {
		opts = sels[i].options
		for (j=0; j<opts.length; j++) {
			val = opts[j].value.match(reval)[1]
			txt = opts[j].text.match(retxt)[1]
			vtdic[val] = txt
			}
		}
	for (k in vtdic) {
		ids.push(k)
		nms.push(vtdic[k])
		}
	return [ids, nms]
	}

function delPfOpt(tr){
	var tby = tr.parentNode
	tby.removeChild(tr)
	if (tby.rows.length == 1) tby.removeChild(tby.rows[0])
	}

function updateDbpfs(sel) {
	var dbpfs = getDbpfs(document.getElementById('tbgrp'))
	var dbpfids =  dbpfs[0], dbpfnms = dbpfs[1]
	var i, new_i=0, val, val_old=sel.options[sel.selectedIndex].value
	//sel.options.length = 0 // clean it first
	sel.options.length = dbpfids.length // clean it first: keep a length is better!!!
	for (i=0; i<dbpfids.length; i++) {
		val = dbpfids[i]
		//sel.options[sel.options.length++].value = val
		sel.options[i].value = val
		sel.options[i].text = dbpfnms[i]
		if (val == val_old) new_i= i //sel.options[i].selected = true
		}
	sel.selectedIndex = new_i
	}

function addNewPfOpts() { // add opts for using pfs. called after added items to groups
	// find selected dbpf in groups
	var dbpfs = getDbpfs(document.getElementById('tbgrp'))
	//if (!dbpfs) return
	var dbpfids =  dbpfs[0], dbpfnms = dbpfs[1]
	if (!dbpfids.length) return
	// find dbpf with normalization options already
	var i, optids={}, optdbpfs = document.getElementsByName(db_pf)
	// make pfid:1 dict
	for (i=0; i<optdbpfs.length; i++) optids[optdbpfs[i].value] = 1
	// find new pfs and add them for options
	var tb = document.getElementById("pf_opt")
	var tbmap = document.getElementById("tb_mapcols")
	for (i=0; i<dbpfids.length; i++) {
		if (optids[dbpfids[i]] == 1) continue
		// new pf, add it
		//addPfOpt(tb, dbpfids[i], 'none', 'none', 'none', dbpfnms[i])
		addPfOpt(tb, dbpfids[i], 'half', 'median', 'quantile', dbpfnms[i])
		addPfCols(tbmap, dbpfids[i], undefined, dbpfnms[i])
		}
	}

function rmExtraPfOpts() { // remove opts for unused pfs. called before submit
	// find selected dbpf in groups
	var i, optids={}, dbpfs = getDbpfs(document.getElementById('tbgrp'))
	//if (!dbpfs) return
	var dbpfids =  dbpfs[0], dbpfnms = dbpfs[1]
	// make pfid:1 dict
	for (i=0; i<dbpfids.length; i++) optids[dbpfids[i]] = 1
	// find dbpf with normalization options already
	//var optdbpfs = document.getElementsByName(db_pf)
	//if (!optdbpfs.length) return
	//for (i=0; i<optdbpfs.length; i++) optids[optdbpfs[i].value] = 1
	// find pfs that are not used in groups and remove them
	var obj, tr, tb = document.getElementById("pf_opt")
	for (i=1; i<tb.rows.length; i++) {
		tr = tb.rows[i]
		obj = tr.getElementsByTagName('INPUT')[0] // the first INPUT
		if (optids[obj.value] == 1) continue
		delPfOpt(tr)
		}
	var obj, tr, tb = document.getElementById("tb_mapcols")
	for (i=1; i<tb.rows.length; i++) {
		tr = tb.rows[i]
		obj = tr.getElementsByTagName('INPUT')[0] // the first INPUT
		if (optids[obj.value] == 1) continue
		delPfOpt(tr)
		}
	}

function addPfOpt(tb, pfval, bgc, normary, normpf, dbpfnm) {
	var i, rtxts = [] // innerHTML for each td
	// add empty string at the beginning
	//dbpfids.unshift('')
	//dbpfnms.unshift('')

	if (dbpfnm == undefined) { // find it
		var dbpfs = getDbpfs(document.getElementById('tbgrp'))
		var dbpfids =  dbpfs[0], dbpfnms = dbpfs[1]
		for (var i=0; i<dbpfids.length; i++) {
			if (dbpfids[i] == pfval) {
				dbpfnm = dbpfnms[i]
				break
				}
			}
		}

	rtxts.push('&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;')
	rtxts.push('<INPUT TYPE="hidden" NAME="' + db_pf + '" VALUE="' + pfval + '">' + dbpfnm)
	// make background correction
	rtxts.push('<SELECT NAME="' + bg_correct + '"><OPTION VALUE=none>none</OPTION><OPTION VALUE=subtract>subtract</OPTION><OPTION VALUE=half>half</OPTION><OPTION VALUE=minimum>minimum</OPTION><OPTION VALUE=movingmin>movingmin</OPTION><OPTION VALUE=edwards>edwards</OPTION><OPTION VALUE=normexp>normexp</OPTION></SELECT>')  // '"rma"'
	rtxts.push('<SELECT NAME="' + norm_in_array + '"><OPTION VALUE=none>none</OPTION><OPTION VALUE=median>median</OPTION><OPTION VALUE=loess>loess</OPTION><OPTION VALUE=printtiploess>Print-tip loess</OPTION><OPTION VALUE=composite>composite</OPTION><OPTION VALUE=control>control</OPTION><OPTION VALUE=robustspline>Robust Spline</OPTION></SELECT>') // '"composite"', '"control"' and '"robustspline"'
	rtxts.push('<SELECT NAME="' + norm_in_pf + '"><OPTION VALUE=none>none</OPTION><OPTION VALUE=scale>scale</OPTION><OPTION VALUE=quantile>quantile</OPTION><OPTION VALUE=Aquantile>Aquantile</OPTION><OPTION VALUE=Gquantile>Gquantile</OPTION><OPTION VALUE=Rquantile>Rquantile</OPTION><OPTION VALUE=Tquantile>Tquantile</OPTION><OPTION VALUE=PCA>PCA</OPTION><OPTION VALUE=vsn>vsn</OPTION></SELECT>') // '"Aquantile"', '"Gquantile"', '"Rquantile"', '"Tquantile"'
	//rtxts.push('<INPUT TYPE=button VALUE=Remove onClick="JavaScript:delPfOpt(this.parentNode.parentNode)" >')

	// make row
	var nd, nr, tby = tb.getElementsByTagName('TBODY')
	if (tby.length > 0) tby = tby.item(0)
	else { // make tbody
		tby = document.createElement('TBODY')
		tb.appendChild(tby)
		}
	if (tby.rows.length < 1) { // add title first
		var ths = ['&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;',
			'<i>Platform</i>', 
			'<i><a href=#overhere onClick="HLP(\'' + base_dir_url + '/webarray_hlp.html#HLP_20\')">Background</a></i>', 
			'<i><a href=#overhere onClick="HLP(\'' + base_dir_url + '/webarray_hlp.html#HLP_29\')">Within array</a></i>', 
			'<i><a href=#overhere onClick="HLP(\'' + base_dir_url + '/webarray_hlp.html#HLP_36\')">Between arrays</a></i>']
		nr = document.createElement('TR')
		//nr.bgcolor = 'gray'
		for (i in ths) {
			nd = document.createElement('TD') // 'TH'
			nd.align='center'
			if (i>0) nd.bgColor='#9db3b3'
			nd.innerHTML = ths[i]
			nr.appendChild(nd)
			}
		tby.appendChild(nr)
		}
	nr = document.createElement('TR')
	for (i in rtxts) {
		nd = document.createElement('TD')
		nd.innerHTML = rtxts[i]
		nr.appendChild(nd)
		}
	tby.appendChild(nr)

	// select option
	var sel, sels = nr.getElementsByTagName('SELECT')
	var j, val, vals = [bgc, normary, normpf]
	for (i in vals) {
		val = vals[i]
		if (val == undefined) continue 
		sel = sels[i]
		if (sel.options[sel.selectedIndex].value == val) continue
		// update selection
		for (j=0; j<sel.options.length; j++) {
			if (sel.options[j].value != val) continue
			sel.options[j].selected = true
			break
			}
		}
	}

function addPfCols(tb, pfval, colval, dbpfnm) {
	// tb is a table object, pfval is "dbnm_pfid", colval is the value for the select, dbpfnm is "pfnm::dbnm"
	var i, rtxts = [] // innerHTML for each td

	if (dbpfnm == undefined) { // find it
		var dbpfs = getDbpfs(document.getElementById('tbgrp'))
		var dbpfids =  dbpfs[0], dbpfnms = dbpfs[1]
		for (var i=0; i<dbpfids.length; i++) {
			if (dbpfids[i] == pfval) {
				dbpfnm = dbpfnms[i]
				break
				}
			}
		}

	i = pfval.lastIndexOf('_')
	var dbnm = pfval.substring(0,i), pfid = pfval.substring(i+1,pfval.length)
	var dest = script_path_url + '/getPfCols?{"db":"' + dbnm + '","rec":' + pfid + '}';
	var pfcols = askSrv(dest);
	if (pfcols == 'failed') pfcols = ''
	else {
		pfcols = eval(pfcols)
		for (i in pfcols) {
			if (i==0) pfcols[i] = '<option value="' + pfcols[i] + '" selected>' + pfcols[i] + '</option>'
			else pfcols[i] = '<option value="' + pfcols[i] + '">' + pfcols[i] + '</option>' }
		pfcols = pfcols.join('')
		}
	rtxts.push('&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;')
	rtxts.push('<INPUT TYPE="hidden" NAME="' + map_db_pf + '" VALUE="' + pfval + '">' + dbpfnm)
	// make background correction
	rtxts.push('<SELECT NAME="' + mapcols + '">' + pfcols + '</SELECT>')  // '"rma"'

	// make row
	var nd, nr, tby = tb.getElementsByTagName('TBODY')
	if (tby.length > 0) tby = tby.item(0)
	else { // make tbody
		tby = document.createElement('TBODY')
		tb.appendChild(tby)
		}
	if (tby.rows.length < 1) { // add title first
		var ths = ['&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;',
			'<i>Platform</i>', 
			'<i>Column</i>']
		nr = document.createElement('TR')
		//nr.bgcolor = 'gray'
		for (i in ths) {
			nd = document.createElement('TD') // 'TH'
			nd.align='center'
			if (i>0) nd.bgColor='#9db3b3'
			nd.innerHTML = ths[i]
			nr.appendChild(nd)
			}
		tby.appendChild(nr)
		}
	nr = document.createElement('TR')
	for (i in rtxts) {
		nd = document.createElement('TD')
		nd.innerHTML = rtxts[i]
		nr.appendChild(nd)
		}
	tby.appendChild(nr)

	// select option
	var sel, sels = nr.getElementsByTagName('SELECT')
	var j, val, vals = [colval]
	for (i in vals) {
		val = vals[i]
		if (val == undefined) continue 
		sel = sels[i]
		if (sel.options[sel.selectedIndex].value == val) continue
		// update selection
		for (j=0; j<sel.options.length; j++) {
			if (sel.options[j].value != val) continue
			sel.options[j].selected = true
			break
			}
		}
	}

function chkFirstFactor(tb) {
	var btn_rm = '<input type=button value=remove onClick="delOneFactor(this.parentNode.parentNode)">'
	var tby = tb.getElementsByTagName('TBODY').item(0)
	var r_num = tby.rows.length
	if (r_num < 2) return
	var r1 = tby.rows[1]
	var cell = r1.cells[r1.cells.length-1]
	if (r_num == 2) cell.innerHTML = ''
	else cell.innerHTML = btn_rm
	}

function addOneFactor(tb, fname, ftype, fdtype, fvalue) {
	// cell content first
	if (tb == undefined) tb = document.getElementById('tb_user_factor')
	if (fname == undefined) fname = ''
	if (ftype == undefined) ftype = 'fixed'
	if (fdtype == undefined) fdtype = 'string'
	if (fvalue == undefined) fvalue = ''
	var i, btn_rm = '<input type=button value=remove onClick="delOneFactor(this.parentNode.parentNode)">'
	var rtxts = ['',
		'<INPUT TYPE="text" NAME="' + uf_name + '" VALUE="' + fname + '" size=8>',
		'<SELECT NAME="' + uf_type + '"><option value="fixed"' + (ftype=='fixed'?' selected>fixed</option>':'>fixed</option>') + '<option value="random"' + (ftype=='random'?' selected>random</option></SELECT>':'>random</option></SELECT>'),
		'<SELECT NAME="' + uf_dtype + '"><option value="float"' + (fdtype=='float'?' selected>float</option>':'>float</option>') + '<option value="integer"' + (fdtype=='integer'?' selected>integer</option>':'>integer</option>')+ '<option value="string"' + (fdtype=='string'?' selected>string</option></SELECT>':'>string</option></SELECT>'),
		'<INPUT TYPE="text" NAME="' + uf_value + '" VALUE="' + fvalue + '" size=50>',
		btn_rm]
	// make row
	var nd, nr, tby = tb.getElementsByTagName('TBODY')
	if (tby.length > 0) tby = tby.item(0)
	else { // make tbody
		tby = document.createElement('TBODY')
		tb.appendChild(tby)
		}
	var r_num = tby.rows.length
	//.if (r_num == 0) rtxts.push('') else rtxts.push(btn_rm)
	nr = document.createElement('TR')
	for (i in rtxts) {
		nd = document.createElement('TD')
		nd.innerHTML = rtxts[i]
		nr.appendChild(nd)
		}
	tby.appendChild(nr)
	chkFirstFactor(tb)
	}

function delOneFactor(r) {
	var tby = r.parentNode
	tby.removeChild(r)
	chkFirstFactor(tby.parentNode)
	}

function addPfOpt_old(tb, pfval, bgc, normary, normpf) {
	var i, tmp=[], rtxts = [] // innerHTML for each td
	// make dbpf select
	tmp.push('<SELECT NAME="' + db_pf + '" onFocus="JavaScript:updateDbpfs(this)">') //tmp[0] = '<SELECT NAME=db_pf>' // have to increase its length attribute manually
	var dbpfs = getDbpfs(document.getElementById('tbgrp'))
	//if (!dbpfs) return
	var dbpfids =  dbpfs[0], dbpfnms = dbpfs[1]
	if (!dbpfids.length) return
	// add empty string at the beginning
	//dbpfids.unshift('')
	//dbpfnms.unshift('')

	for (i in dbpfids) tmp.push('<OPTION VALUE=' + dbpfids[i] + '>' + dbpfnms[i] + '</OPTION>')
	tmp.push('</SELECT>')
	rtxts.push(tmp.join(''))
	// make background correction
	rtxts.push('<SELECT NAME="' + bg_correct + '"><OPTION>none</OPTION><OPTION>subtract</OPTION><OPTION>half</OPTION><OPTION>minimum</OPTION><OPTION>movingmin</OPTION><OPTION>edwards</OPTION><OPTION>normexp</OPTION></SELECT>')  // '"rma"'
	rtxts.push('<SELECT NAME="' + norm_in_array + '"><OPTION>none</OPTION><OPTION>median</OPTION><OPTION>loess</OPTION><OPTION VALUE=printtiploess>Print-tip loess</OPTION><OPTION VALUE=composite>composite</OPTION><OPTION VALUE=control>control</OPTION><OPTION VALUE=robustspline>Robust Spline</OPTION></SELECT>') // '"composite"', '"control"' and '"robustspline"'
	rtxts.push('<SELECT NAME="' + norm_in_pf + '"><OPTION>none</OPTION><OPTION>scale</OPTION><OPTION>quantile</OPTION><OPTION>Aquantile</OPTION><OPTION>Gquantile</OPTION><OPTION>Rquantile</OPTION><OPTION>Tquantile</OPTION><OPTION>PCA</OPTION><OPTION>vsn</OPTION></SELECT>') // '"Aquantile"', '"Gquantile"', '"Rquantile"', '"Tquantile"'
	rtxts.push('<INPUT TYPE=button VALUE=Remove onClick="JavaScript:delPfOpt(this.parentNode.parentNode)" >')

	// make row
	var nd, nr, tby = tb.getElementsByTagName('TBODY')
	if (tby.length > 0) tby = tby.item(0)
	else { // make tbody
		tby = document.createElement('TBODY')
		tb.appendChild(tby)
		}
	if (tby.rows.length < 1) { // add title first
		var ths = ['<font size=-1>Platform</font>', '<font size=-1>Background</font>', '<font size=-1>Within array</font>', '<font size=-1>Between arrays</font>']
		nr = document.createElement('TR')
		for (i in ths) {
			nd = document.createElement('TD') // 'TH'
			nd.align='center'
			nd.innerHTML = ths[i]
			nr.appendChild(nd)
			}
		tby.appendChild(nr)
		}
	nr = document.createElement('TR')
	for (i in rtxts) {
		nd = document.createElement('TD')
		nd.innerHTML = rtxts[i]
		nr.appendChild(nd)
		}
	tby.appendChild(nr)

	// select option
	var sel, sels = nr.getElementsByTagName('SELECT')
	var j, val, vals = [pfval, bgc, normary, normpf]
	for (i in vals) {
		val = vals[i]
		if (val == undefined) continue 
		sel = sels[i]
		if (sel.options[sel.selectedIndex].value == val) continue
		// update selection
		for (j=0; j<sel.options.length; j++) {
			if (sel.options[j].value != val) continue
			sel.options[j].selected = true
			break
			}
		}
	}

function addGrp(tb) {
	// enable the remove button
	if (!tb) tb = document.getElementById('tbgrp')
	var i, obj, divs, rnum = tb.getElementsByTagName('tbody').item(0).rows.length
	if (rnum==1) {
		divs = tb.getElementsByTagName('div')
		i = findItemByName(divs, 'rm_btn')
		if (i>=0) divs[i].innerHTML = "<input type='button' value='Remove' onClick='javascript:delRow(this.parentNode.parentNode.parentNode)' />"
		}
	// make new row
	var nr = addOneRow(tb)
	// clear selection content
	var sel = nr.getElementsByTagName("select")[0]
	sel.length = 0
	sel.name = grp_prefix + (rnum+1)
	// increase the group number
	divs = nr.getElementsByTagName('div')
	i = findItemByName(divs, 'grp_title')
	if (i>=0) divs[i].innerHTML = 'group' + (rnum + 1)
	}

function delRow(tr) {
	var tbd = tr.parentNode
	var rs = tbd.rows, divs = tr.getElementsByTagName('div')
	var i, i_btn, i_nm = findItemByName(divs, 'grp_title')
	// decrease the group number
	foundme = false
	for (i=0; i<rs.length; i++) {
		if (foundme) { //decrease number
			rs[i].getElementsByTagName('select')[0].name = grp_prefix + i
			rs[i].getElementsByTagName('div')[i_nm].innerHTML = 'group' + i
			//continue
			}
		else if (rs[i]==tr) foundme = true
		}
	// delete the row
	tbd.removeChild(tr)
	// disable remove button
	if (tbd.rows.length == 1) {
		divs = tbd.rows[0].getElementsByTagName('div')
		i_btn = findItemByName(divs, 'rm_btn')
		divs[i_btn].innerHTML = "<input type='hidden' value='Remove' onClick='javascript:delRow(this.parentNode.parentNode.parentNode)' />"
		} 
	}

function addToGrp(selsrc, selobj) {
	// add options from selsrc to the group selobj
	var i, vals={}, add_new=false
	for (i=0; i<selobj.length; i++) vals[selobj.options[i].value] = true
	for (i=0; i<selsrc.length; i++) 
		if (selsrc.options[i].selected && !(selsrc.options[i].value in vals)) {
			selobj.options[selobj.length++].value = selsrc.options[i].value
			selobj.options[selobj.length-1].text = selsrc.options[i].text 
			add_new = true}
	if (add_new) addNewPfOpts()
	}

function selAll() {
	// select all items for all selection
	var i, j , sel
	arys = {'array':1, 'grps_':1}
	sels = document.getElementsByTagName('select')
	for (j=0; j<sels.length; j++) {
		sel = sels[j]
		if (sel.name.slice(0,5) in arys) {
			for (i=0; i<sel.length; i++) sel.options[i].selected = true
			}
		}
	}

function saveText() {
	// create hidden input to store selection text
	var i, j, sel, txt, newinput
	var arys = {'array':1, 'grps_':1}
	var sels = document.getElementsByTagName('select')
	for (j=0; j<sels.length; j++) {
		sel = sels[j]
		if (sel.name.slice(0,5) in arys) {
			txt = []
			for (i=0; i<sel.length; i++) txt[i] = sel.options[i].text // or txt.push(sel.options[i].text)
			//
			newinput = document.anaform[sel.name + '_text']
			if (newinput == undefined) { // if (!newinput) {
				newinput = document.createElement('input') //make new input
				newinput.setAttribute('type', 'hidden')
				newinput.setAttribute('name', sel.name + '_text') 
				document.anaform.appendChild(newinput)
				}
			newinput.setAttribute('value', txt.join(array_sep) )
			//alert(newinput.name + ' : ' + newinput.value)
			}
		}
	}


function fillForm() {
	// fill selections
	var i, j, n, arys, ary_vals, has_text, ary_texts, tb, sels, vals, txts, grp_nm, grp_vals, grp_texts, grp, idnmdic={} 
	if (arrays in my_values) {
		arys = document.getElementById(src_arrays)
		ary_vals = my_values[arrays]
		if ((arrays+'_text') in my_values) ary_texts = my_values[arrays+'_text'][0].split(array_sep)
		else ary_texts = ary_vals
		//alert('ary_texts is ' + ary_texts)
		arys.options.length = 0
		for (i in ary_vals) {
			arys.options[arys.options.length++].value = ary_vals[i]
			arys.options[arys.options.length-1].text = ary_texts[i]
			}
		}
	if (grp_num in my_values) { // has grps
		n = my_values[grp_num]
		tb = document.getElementById('tbgrp')
		// add grps first
		for (i=1; i<n; i++) addGrp(tb)
		sels = tb.getElementsByTagName('select')
		if (!('groups' in my_values)) return
		vals = my_values['groups']
		if ('groups_text' in my_values) {
			txts = my_values['groups_text']
			for (i=0; i<n; i++) {
				if (txts[i].length > 0) txts[i] = txts[i][0].split(array_sep) 
				//else txts[i] = []
				}
			}
		else txts = vals
		for (i=0; i<n; i++) { 
			grp_nm = grps_ + i
			//grp_vals = my_values[grp_nm]
			//if ((grp_nm + '_text') in my_values) grp_texts =  my_values[grp_nm + '_text'][0].split(array_sep)
			//else grp_texts = grp_vals
			grp_vals = vals[i]
			grp_texts = txts[i]
			//alert(grp_nm + '_text is ' + grp_texts)

			grp = sels[i]
			grp.options.length = 0
			for (j in grp_vals) {
				grp.options[grp.options.length++].value = grp_vals[j]
				grp.options[grp.options.length-1].text = grp_texts[j]
				}
			}
		}

	// add and fill platform-related options
	if (db_pf in my_values) { // must have bg_correct, norm_in_array and norm_in_pf as well
		var db_pf_loc=my_values[db_pf], bg=my_values[bg_correct], nmary=my_values[norm_in_array], nmpf=my_values[norm_in_pf] // have to use a different name here (db_pf_log), otherwise it will destroy the global variable "db_pf"
		var mapcol = my_values[mapcols]
		// find dbpfnms
		var dbpfs = getDbpfs(document.getElementById('tbgrp'))
		var idnms={}, dbpfids =  dbpfs[0], dbpfnms = dbpfs[1]
		for (var i=0; i<dbpfids.length; i++) idnms[dbpfids[i]] = dbpfnms[i]

		var tbopt = document.getElementById("pf_opt")
		var tbmap = document.getElementById("tb_mapcols")
		for (i=0; i<db_pf_loc.length; i++) {
			addPfOpt(tbopt, db_pf_loc[i], bg[i], nmary[i], nmpf[i], idnms[db_pf_loc[i]])
			addPfCols(tbmap, db_pf_loc[i], mapcol==undefined ? undefined : mapcol[i], idnms[db_pf_loc[i]])
			}
		}

	var tbuf = document.getElementById('tb_user_factor')
	if (uf_name in my_values) {
		var ufnms=my_values[uf_name], uftps=my_values[uf_type], ufdtps=my_values[uf_dtype], ufvals=my_values[uf_value]
		for (i=0; i<ufnms.length; i++) addOneFactor(tbuf, ufnms[i], uftps[i], ufdtps[i], ufvals[i])
		}
	else addOneFactor(tbuf, '', 'fixed', 'string', '')

	// fill other simple items:
	var nm, items = [match_method]
	for (i in items) {
		nm = items[i]
		if (nm in my_values) {
			document.getElementsByName(nm)[0].value = my_values[nm]
			}
		}
	// update display style for div(s) related to match_by
	//chkMatchBy(document.getElementsByName(match_method)[0])
	updateDisplay()
	}

function trim(st) {return st.replace(/^\s*/g,"").replace(/\s*$/g,""); }

function checkName(fm){
	var parth = /^[a-zA-Z0-9_]+$/;
	var old_name = request_name_old;
	var new_name = trim(fm.value); //trim(document.anaform.<%= request_name %>.value); //<!--%= request_name %-->
	//var new_name = fm.request_name.value; // This line doesn't work, I don't know why
	if (new_name != '') {
		//var parth = /^[a-zA-Z0-9_]+$/;
		if (!parth.test(new_name)) {alert("Illegal characters in request name"); return false;}
		}
	if (old_name != '' && new_name == old_name && req_user == username) {
		if (!confirm('The request name is same to the old one, the new results will overwrite the old one, is it OK?\notherwise, click Cancel to change it.')) return false;
		}
	return true;
	}

function checkMtd(fm) {
	var i, j, v='no', objs, yesno_nms = output_opt //[save_data, plot_chart, clust_chs, plot_heatmap, plot_genome]
	for (j in yesno_nms) {
		objs=fm[yesno_nms[j]]
		//for (i in objs) { // IE works incorrectly with this line
		for (i=0; i<objs.length; i++) 
			if (objs[i].checked) {
				v = objs[i].value
				break}
		if (v=='yes') return true
		}
	// check differential analysis
	if (fm[mtd_dif].value != 'none' && fm[mtd_dif].value != 'get_data') return true
	return confirm('No output of significance will be produced, are you sure to continue?')
	}

function checkForm(fm){
	//if (!checkName(fm.<%= request_name %>)) return false;
	if (!checkMtd(fm)) return false
	if (!checkName(fm[request_name])) return false;
	selAll()
	saveText()
	// rm extro options
	rmExtraPfOpts()
	document.getElementById('grp_num').value = document.getElementById('tbgrp').getElementsByTagName('tbody').item(0).rows.length
	return true;
	}


