function findPrevious(obj, ymd, val) {
	while (1) {
		obj = obj.previousSibling
		if (!obj) return false
		if (!obj.attributes || !obj.attributes.getNamedItem(ymd) || obj.attributes.getNamedItem(ymd).value != val) continue
		return obj
		}
	}

function findNext(obj, ymd, val) {
	while (1) {
		obj = obj.nextSibling
		if (!obj) return false
		if (!obj.attributes || !obj.attributes.getNamedItem(ymd) || obj.attributes.getNamedItem(ymd).value != val) continue
		return obj
		}
	}

function toDate(obj, year_dir, month_dir, day_dir) {
	var year, month, day
	debugger;
	if (year_dir == 'this') year = obj
	else if (year_dir == 'previous') year = findPrevious(obj, 'ymd', 'year')
	else year = findNext(obj, 'ymd', 'year')
	if (month_dir == 'this') month = obj
	else if (month_dir == 'previous') month = findPrevious(obj, 'ymd', 'month')
	else month = findNext(obj, 'ymd', 'month')
	if (day_dir == 'this') day = obj
	else if (day_dir == 'previous') day = findPrevious(obj, 'ymd', 'day')
	else day = findNext(obj, 'ymd', 'day')
	
	var vYear=parseInt(year.options[year.selectedIndex].text)
	var vMonth=parseInt(month.options[month.selectedIndex].text)
	var sel = day.selectedIndex
	day.length=0;
	for(var i=0;i<(new Date(vYear,vMonth,0)).getDate();i++){
		day.options[day.length++].value=day.length;
		day.options[day.length-1].text=day.length; 
		}
	day.selectedIndex = sel+1 > day.length ? 0 : sel
	}

function mkDateStr(obj, ynm, mnm, dnm, yval, mval, dval, indent) { //, yid, mid, did
	// ynm is then item name for year, yid, is the item id for year, yval is the selected value for year
	indent = indent==undefined ? '' : indent
	var newdate = new Date()
	yval = yval==undefined ? newdate.getYear()+1900 : yval
	mval = mval==undefined ? newdate.getMonth()+1 : mval
	dval = dval==undefined ? newdate.getDate() : dval

	var i;
	var date_str = indent + '<select name="' + ynm + '" value=' + yval + ' ymd="year" onchange="toDate(this, \'this\', \'next\', \'next\')">\n';
	for (i=2007; i<2027; i++) 
		if (i == yval) date_str += indent + '	<option value=' + i + ' selected>' + i + '</option>\n'
		else date_str += indent + '	<option>' + i + '</option>\n' 	
	date_str += indent + '</select>\n'
	date_str += indent + '<select name="' + mnm + '" value=' + mval + ' ymd="month" onchange="toDate(this, \'previous\',\'this\', \'next\')">\n'
	for (i=1; i<13; i++) 
		if (i==mval) date_str += indent + '	<option value=' + i + ' selected>' + i + '</option>\n'
		else date_str += indent + '	<option value=' + i + '>' + i + '</option>\n'
	date_str += indent + '</select>\n'
	date_str += indent + '<select name="' + dnm + '" value=' + dval + ' ymd="day">\n'
	for (i=1; i<=(new Date(yval, mval, 0)).getDate(); i++) 
		if (i==dval) date_str += indent + '	<option value=' + i + ' selected>' + i + '</option>\n'
		else date_str += indent + '	<option value=' + i + '>' + i + '</option>\n'
	date_str += indent + '</select>\n'
	if (obj) obj.innerHTML = date_str
	return(date_str) 
	}

function mkDate(obj, ynm, mnm, dnm, y_start, y_end, yval, mval, dval, indent) { //, yid, mid, did
	// ynm is then item name for year, yid, is the item id for year, yval is the selected value for year
	indent = indent==undefined ? '' : indent
	var newdate = new Date()
	//yval = yval==undefined ? newdate.getYear()+1900 : yval
	yval = yval==undefined ? newdate.getFullYear() + 2 : yval
	mval = mval==undefined ? newdate.getMonth()+1 : mval
	dval = dval==undefined ? newdate.getDate() : dval

	var i;
	var date_obj = document.createElement('select')
	date_obj.setAttribute('name', ynm)
	date_obj.setAttribute('value', yval)
	date_obj.setAttribute('ymd', 'year')
	date_obj.setAttribute('onChange', 'toDate(this, \'this\', \'next\', \'next\')')
	for (i=y_start; i<y_end; i++) {
		date_obj.options[date_obj.length++].value = i 
		date_obj.options[date_obj.length-1].text = i
		if (i == yval) date_obj.options[date_obj.length-1].selected = true 
		}
	if (obj) obj.appendChild(date_obj)

	date_obj = document.createElement('select')
	date_obj.setAttribute('name', mnm)
	date_obj.setAttribute('value', mval)
	date_obj.setAttribute('ymd', 'month')
	date_obj.setAttribute('onChange', 'toDate(this, \'previous\', \'this\', \'next\')')
	for (i=1; i<13; i++) {
		date_obj.options[date_obj.length++].value = i 
		date_obj.options[date_obj.length-1].text = i
		if (i==mval) date_obj.options[date_obj.length-1].selected = true
		}
	if (obj) obj.appendChild(date_obj)

	date_obj = document.createElement('select')
	date_obj.setAttribute('name', dnm)
	date_obj.setAttribute('value', dval)
	date_obj.setAttribute('ymd', 'day')
	for (i=1; i<=(new Date(yval, mval, 0)).getDate(); i++) {
		date_obj.options[date_obj.length++].value = i 
		date_obj.options[date_obj.length-1].text = i
		if (i==dval) date_obj.options[date_obj.length-1].selected = true
		}
	if (obj) obj.appendChild(date_obj)
	// if (obj) obj.innerHTML = date_str  // IE doesn't work properly with this
	//return(date_str) 
	}

function addOneRowCol(tbid, col) {
	// append one row, and copy the content of the col from the last row
	// tbid can be a table object or table id
	var mytb = (typeof(tbid)=='object') ? tbid : document.getElementById(tbid) // or "string"
	var mytbbd = mytb.getElementsByTagName('tbody')[0]
	var myrows = mytbbd.getElementsByTagName('tr')
	var myrow = myrows[myrows.length - 1] // use the last row
	var mytds = myrow.getElementsByTagName('td')

	var newrow = document.createElement('tr')
	for (var i=0; i < mytds.length; i++) newrow.appendChild(document.createElement('td'))

	var newtds = newrow.getElementsByTagName('td')
	var newtd = newtds.item(col-1)
	newtd.rowSpan = mytds[col-1].rowSpan
	newtd.colSpan = mytds[col-1].colSpan
	newtd.innerHTML = mytds[col-1].innerHTML
	mytbbd.appendChild(newrow)
	
	}

var spaces = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'

function addDiv(div_id, div_title) {
	// add a div in the divid
	var i, obj, objs
	var dv = document.getElementById(div_id)

	// get all child "div" units, each "div" unit is an collection of entity.for inputting data
	var units = []
	for (i=0; i<dv.childNodes.length; i++) {
		if (dv.childNodes[i].tagName=='DIV') units.push(dv.childNodes[i]) }

	// enable "remove" button for the first unit
	if (units.length == 1) { 
		for (i=0; i<units[0].childNodes.length; i++) {
			obj = units[0].childNodes[i].attributes
			if (obj && obj.getNamedItem('name') && obj.getNamedItem('name').value=='remove_unit') {
				units[0].childNodes[i].innerHTML = '<input type="button" value="remove" onClick="delDiv(this.parentNode.parentNode)">'
				break
				}
			}
		}
	
	// create new div
	//var new_unit = document.createElement('div')
	//new_unit.innerHTML = units[0].innerHTML
	//var new_attr = document.createAttribute('name')
	//new_attr.nodeValue = 'unit'
	//new_unit.setAttributeNode(new_attr)
	// create new div by cloneNode(true)
	var new_unit = units[units.length-1].cloneNode(true)
	// copy values that havn't been copied automatically, 'SELECT'
	var vold = units[units.length-1].getElementsByTagName('SELECT')
	var vnew = new_unit.getElementsByTagName('SELECT')
	for (i=0; i<vold.length; i++) 
		vnew[i].value = vold[i].value // IE can work with this, maybe it is because this is done before added (appendChild) to DOM?
		//selOpt(vnew[i], vold[i].value)

	// change No. 
	for (i=0; i<new_unit.childNodes.length; i++){
		obj = new_unit.childNodes[i]
		if (obj.attributes && obj.attributes.getNamedItem('name') && obj.attributes.getNamedItem('name').value=='unit_index') {
			obj.innerHTML = units.length+1
			break
			}
		} 

	// clear the first text input: the name
	var inputs = new_unit.getElementsByTagName('input')
	for (i=0; i<inputs.length; i++) {
		obj = inputs[i]
		if (obj.attributes && obj.attributes.getNamedItem('type') && obj.attributes.getNamedItem('type').value.toUpperCase()=='TEXT') {
			obj.value = ''
			break
			}
		}

	dv.appendChild(new_unit)

	// update the item names in channels for the new array
	var myop = {'array':'updateChNames(new_unit)'}
	if (myop[div_id]) eval(myop[div_id])
	}

function delDiv(unit, parentName) {
	// remove the unit
	var i, j, obj
	//if (!unit) return 
	if (parentName)
		while (unit.attributes.getNamedItem('name').value != parentName) unit = unit.parentNode 
	var dv = unit.parentNode

	// find the next unit
	var next_unit = unit.nextSibling
	while (1) {
		if (!next_unit) break // the end of the div
		if (!next_unit.attributes || !next_unit.attributes.getNamedItem('name') || next_unit.attributes.getNamedItem('name').value != 'unit') next_unit= next_unit.nextSibling
		else break
		}

	var mytp = dv.attributes.getNamedItem('id').value
	var myop = {'array':'updateChNames(next_unit)', 'samp':'onChangeSamps()', 'protocol':'onChangeProts()', 'MA_platform':'onChangePfs()'}
	//delete the unit
	dv.removeChild(unit)
	// update options (or item names in channels for array)
	if (myop[mytp]) eval(myop[mytp])

	// get all DIV children
	var units = []
	for (i=0; i<dv.childNodes.length; i++) if (dv.childNodes[i].tagName=='DIV') units.push(dv.childNodes[i])

	// disable "remove button"
	if (units.length <= 1) {
		for (i=0; i<units[0].childNodes.length; i++) {
			obj = units[0].childNodes[i].attributes
			if (obj && obj.getNamedItem('name') && obj.getNamedItem('name').value=='remove_unit') {
				units[0].childNodes[i].innerHTML = ''
				break
				}
			}		
		}

	// change No
	for (i=0; i<units.length; i++) {
		unit = units[i]
		for (j=0; j<unit.childNodes.length; j++) {
			obj = unit.childNodes[j]
			if (obj.attributes && obj.attributes.getNamedItem('name') && obj.attributes.getNamedItem('name').value=='unit_index') {
				obj.innerHTML = i+1
				break
				}
			}
		}
	}

function getOptions(opts, sel) {
	// return a array of '' + pf_db + pf_new
	var rlt = ''
	sel = sel == undefined ? '' : sel
	for (var a in opts) {
		if (sel == opts[a] || (a==0 && sel=='') ) rlt += '<option value="' + opts[a] + '" selected>' + opts[a] + '</option>'
		else rlt += '<option value="' + opts[a] + '">' + opts[a] + '</option>'
		}
	return(rlt)
	}

function getPfs() {
	// return pf_all -- a array of pf_db + pf_new
	var v_all = pf_db.slice(), v_mine = pf_db_mine.slice()
	var i, v_dic = {}
	for (i in v_all) v_dic[v_all[i]] = true
	for (i in pf_new) 
		if (!v_dic[pf_new[i]]) {
			v_all.push(pf_new[i])
			v_mine.push(pf_new[i])}
	v_all.sort()
	v_mine.sort()
	return([v_all, v_mine])
	}

function getSamps(){ 
	var v_all = samp_db.slice(), v_mine = samp_db_mine.slice()
	var i, v_dic = {}
	for (i in v_all) v_dic[v_all[i]] = true
	for (i in samp_new) 
		if (!v_dic[samp_new[i]]) {
			v_all.push(samp_new[i])
			v_mine.push(samp_new[i]) }
	v_all.sort()
	v_mine.sort()
	return([v_all, v_mine])
	}

function getProts(tpnm) { // shoud put it in correct variable according to protocol category (6)
	// tpnm is one of 'prot_hyb', 'prot_img', 'prot_data', 'prot_proc', 'prot_tech', or 'prot_label'
	var v_all = eval(tpnm + '_db.slice()'), v_mine = eval(tpnm + '_db_mine.slice()')
	var v_new = eval(tpnm + '_new')
	var i, v_dic = {}
	for (i in v_all) v_dic[v_all[i]] = true
	for (i in v_new) 
		if (!v_dic[v_new[i]]) {
			v_all.push(v_new[i])
			v_mine.push(v_new[i])}
	v_all.sort()
	v_mine.sort()
	return([v_all, v_mine])
	}

function PrjNameErrs(prj) {
	var errs = []
	if (prj_db_dic[prj.value]) errs.push('The project name "' + prj.value + '" already exists in database')
	return errs
	}

function ArrayNameErrs(arrays) {
	var i,j, ar_new_dic={}, errs=[]
	// make ar_new_dic
	for (i=0; i<arrays.length; i++) 
		if (arrays[i].value) {
			if (ar_new_dic[arrays[i].value]) ar_new_dic[arrays[i].value] += 1
			else ar_new_dic[arrays[i].value] = 1 
			}
	// check replicate name
	for (i in ar_new_dic) {
		if (array_db_dic[i]) errs.push('The array name "' + i + '" already exists in database')
		if (ar_new_dic[i]>1) errs.push('The array name "' + i + '" was used ' + ar_new_dic[i] + ' times in the form')
		}
	return errs
	}

function PfNameErrs(pfs) {
	var i,j, pf_new_dic={}, errs=[]
	// make pf_new
	pf_new = [] //new Array(pfs.length)
	for (i=0; i < pfs.length; i++) if (pfs[i].value != undefined && trim(pfs[i].value)) pf_new[i] = pfs[i].value
	// count name in pf_new
	for (i=0; i<pf_new.length; i++)
		if (pf_new_dic[pf_new[i]]) pf_new_dic[pf_new[i]] += 1
		else pf_new_dic[pf_new[i]] = 1

	// check replicate name 
	for (i in pf_new_dic) {
		if (pf_db_dic[i]) 
			errs[errs.length++] = 'The platform name "' + i + '" already exists in database'
		if (pf_new_dic[i] > 1) 
			errs.push('The platform name "' + i + '" was used ' + pf_new_dic[i] + ' times in the form')
		}
	return(errs)
	}

function SampNameErrs(samps) {
	var i, j, samp_new_dic={}, errs=[]
	// make samp_new
	samp_new = []
	for (i=0; i<samps.length; i++) if (samps[i].value != undefined && trim(samps[i].value)) samp_new[i] = samps[i].value
	// count name in samp_new
	for (i=0; i<samp_new.length; i++) 
		samp_new_dic[samp_new[i]] = samp_new_dic[samp_new[i]] ? samp_new_dic[samp_new[i]] + 1 : 1
	// check replicate name
	for (i in samp_new_dic) {
		if (samp_db_dic[i]) errs.push('The sample name "' + i + '" already exists in database')
		if (samp_new_dic[i]>1) errs.push('The sample name "' + i + '" was used ' + samp_new_dic[i] + ' times in the form')
		}
	return errs
	}

function ProtNameErrs(prots) {
	var i, j, prot_new_dic={}, errs=[]
	// make prot_new_dic
	for (i=0; i<prots.length; i++)
		if (prots[i].value != undefined && trim(prots[i].value)) prot_new_dic[prots[i].value] = prot_new_dic[prots[i].value] ? prot_new_dic[prots[i].value] + 1 : 1
	// check replicate name
	for (i in prot_new_dic) {
		if (prot_db_dic[i]) errs.push('The protocol name "' + i + '" already exists in database')
		if (prot_new_dic[i]>1) errs.push('The protocol name "' + i + '" was used ' + prot_new_dic[i] + ' times in the forms')
		}
	return errs
	}


function onChangePrjName(item) {
	if (prj_db_dic[item.value]) {
		alert('The project name "' + item.value + '" already exists in database! please use another name.')
		return false }
	return true
	}

function onChangeArrayNames() {
	var errs = ArrayNameErrs(document.getElementsByName(array_id))
	if (errs.length > 0) {
		alert(errs.join(';\n') + '\n\nPlease correct it.')
		return(false)}
	}

function onChangePfs(first_time) { 
	// called by platform change event
	first_time = first_time==undefined ? false : first_time
	var i, j, v, v_i, opt_dic, errs
	var pfs = document.getElementsByName(pf_name)

	// update pf_new and check name validity
	errs = PfNameErrs(pfs)
	if (errs.length > 0 && !first_time) {
		alert(errs.join(';\n') + '\n\nPlease correct it.')
		return(false)}

	// update pf_all
	pf_all = getPfs()
	pf_mine = pf_all[1]
	pf_all = pf_all[0]
	opt_dic = {}
	for (i in pf_all) opt_dic[pf_all[i]] = true
	// update Platform select options
	pfs = document.getElementsByName(pf)
	for (i=0; i<pfs.length; i++) {
		v = pfs[i].value
		v_i = pfs[i].selectedIndex
		pfs[i].length = 0
		pfs[i].options[pfs[i].length++].text = '' // add an empty item to make sure the page return a value to CGI
		pfs[i].options[pfs[i].length-1].value = '' // add an empty item to make sure the page return a value to CGI
		for (j in pf_mine) { //pf_all) {
			pfs[i].options[pfs[i].length++].text = pf_mine[j] //pf_all[j]
			pfs[i].options[pfs[i].length-1].value = pf_mine[j] //pf_all[j]
			}
		if (v && opt_dic[v]) pfs[i].value = v
		else if (v_i && v_i < pfs[i].length) pfs[i].selectedIndex = v_i
		else pfs[i].selectedIndex = 0 // '' is selected at last, so the page is definitely return a value to CGI
		}
	}

function getTagNumByName(tag_nm, item_nm) {
	var i, n=0, obj, objs = document.getElementsByTagName(tag_nm)
	for (i=0; i<objs.length; i++) {
		obj = objs[i].attributes
		if (obj && obj.getNamedItem('name') && obj.getNamedItem('name').value==item_nm) n++;
		}
	return(n)
	}

function onChangeSamps(first_time) {
	// called by sample change event
	first_time = first_time==undefined ? false : first_time
	var i,n, v, v_i, opt_dic, inputmp, errs
	var inputs = document.getElementsByName(samp_name)

	// update samp_new and check name validity
	errs = SampNameErrs(inputs)
	if (errs.length > 0 && !first_time) {
		alert(errs.join(';\n') + '\n\nPlease correct it.')
		return(false)}

	// update samp_all
	samp_all = getSamps()
	samp_mine = samp_all[1]
	samp_all = samp_all[0]
	opt_dic = {}
	for (i in samp_all) opt_dic[samp_all[i]] = true

	// update Platform select options
	inputs = []
	var array_n = getTagNumByName('div', 'array_body_div')
	for (n=1; n<=array_n; n++) {
		inputmp = document.getElementsByName(samp_head + n) // names were tagged with array No.
		for (i=0; i<inputmp.length; i++) inputs[inputs.length++] = inputmp[i]
		}
	for (i=0; i<inputs.length; i++) {
		v = inputs[i].value
		v_i = inputs[i].selectedIndex
		inputs[i].length = 0
		inputs[i].options[inputs[i].length++].text = '' // add an empty item to make sure the page return a value to CGI
		inputs[i].options[inputs[i].length-1].value = '' // add an empty item to make sure the page return a value to CGI
		for (j in samp_mine) { //samp_all) {
			inputs[i].options[inputs[i].length++].text = samp_mine[j] //samp_all[j]
			inputs[i].options[inputs[i].length-1].value = samp_mine[j] //samp_all[j]
			}
		if (opt_dic[v]) inputs[i].value = v
		else if (v_i < inputs[i].length) inputs[i].selectedIndex = v_i
		else inputs[i].selectedIndex = 0 // '' is selected at last, so the page is definitely return a value to CGI
		}
	}

function onChangeProts(first_time) { 
	// called by protocol change event
	// there are many different type of protocols. // use this to find which one is changed? Do nothing if cat is not changed.
	first_time = first_time==undefined ? false : first_time
	var i, j, n, p, v, v_i, opt_dic, pynms, jnms, jnms_dic, alltmp, inputmp, errs
	var inputs = document.getElementsByName(prot_name)
 	var cats = document.getElementsByName(prot_cat)
	// update prot_XXX_new and validate names
	errs = ProtNameErrs(inputs)
	if (errs.length > 0 && !first_time) {
		alert(errs.join(';\n') + '\n\nPlease correct it.')
		return false}
	jnms = prot_nms //['prot_hyb', 'prot_img', 'prot_data', 'prot_proc', 'prot_tech', 'prot_label']
	jnms_dic = prot_nms_dic 
	for (i in jnms) eval(jnms[i] + '_new = []')
	//for (i=0; i < inputs.length; i++) eval(jnms_dic[cats[i].value] + '_new[i] = inputs[i].value')
	for (i=0; i < inputs.length; i++) 
		if (trim(inputs[i].value)!='') eval(jnms_dic[cats[i].value] + '_new[i] = inputs[i].value')

	// update prot_XXXX_all, prot_XXXX_mine
	opt_dic = {}
	for (i in jnms) {
		eval(jnms[i] + '_all = getProts("' + jnms[i] + '"); ' + jnms[i] + '_mine=' + jnms[i] + '_all[1]; ' + jnms[i] + '_all=' + jnms[i] + '_all[0]') 
		opt_dic[jnms[i]] = {} 
		for (j in eval(jnms[i] + '_all')) eval('opt_dic[jnms[i]][' + jnms[i] + '_all[j]] = true')
		}

	// update Platform select options
	pynms = pynms_global
	var array_n = getTagNumByName('div', 'array_body_div')
	for (p in pynms) { //]) {
		if (p<3) inputs = document.getElementsByName(pynms[p])
		else { // get inputs for channels
			inputs = []
			for (n=1; n<=array_n; n++) {
				inputmp = document.getElementsByName(pynms[p] + n)
				for (i=0; i<inputmp.length; i++) inputs[inputs.length++] = inputmp[i] 
				}
			}
		for (i=0; i<inputs.length; i++) {
			v = inputs[i].value
			v_i = inputs[i].selectedIndex
			inputs[i].length = 0
			inputs[i].options[inputs[i].length++].text = '' // add an empty item to make sure the page return a value to CGI
			inputs[i].options[inputs[i].length-1].value = '' // add an empty item to make sure the page return a value to CGI
			alltmp = eval(jnms[p] + '_mine') //'_all')
			for (j in alltmp) {
				if (alltmp[j] == '') continue
				inputs[i].options[inputs[i].length++].text = alltmp[j]
				inputs[i].options[inputs[i].length-1].value = alltmp[j]
				}
			if (opt_dic[jnms[p]][v]) inputs[i].value = v
			else if (v_i >= 0 && v_i < inputs[i].length) inputs[i].selectedIndex = v_i
			else inputs[i].selectedIndex = 0 // '' is selected at last, so the page is definitely return a value to CGI
			}
		}
	}

function addOneCh(dv) {
	var i, j, obj, array_No 
	var chdv = getNamedTags(dv, 'div', 'name', 'channels')[0]
	// get unit_idix -- the unit_index of the dv
	array_No = parseInt(getNamedTags(dv, 'b', 'name', 'unit_index')[0].innerHTML)

	// get the data table
	var chtb = document.createElement('table') 
	var tbs = chdv.getElementsByTagName('table')
	var ch_No = tbs.length + 1 // justsome channel tables in chdv
	var wid = wid_global 
	for (i in wid) {
		obj = document.createElement('colgroup')
		obj.width = wid[i]
		chtb.appendChild(obj)
		}

	var tbbd = document.createElement('tbody')
	chtb.appendChild(tbbd)
	var newtr, newtd, newtds;
	var lines = [
			{1:'<!--input type="hidden" name="Channel_No" value=' + ch_No + '-->&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<font size=-1><b><i>Channel <div style="display:inline">' + ch_No + '</div></i></b></font>', 3:'<input type="' + (ch_No==1?'hidden':'button') + '" value="Remove this channel" onclick=removeCh(this)>'},
			//{1:"* Sample:", 3:"<select name='" + samp_head + array_No + "' >" + getOptions([''].concat(samp_all)) + "</select>", 5:"Dye:", 7:"<input type='text' size=" + text_wid + " name='" + dye_head + array_No + "' ></td>"},
			//{1:"* Sample:", 3:"<select name='" + samp_head + array_No + "' >" + getOptions([''].concat(samp_all)) + "</select>", 5:"Dye:", 7:"<select name='" + dye_head + array_No + "' >" + dye_options_str + "</select><input type='button' name='btn_add_dye' value='New dye' class=\"hintanchor\" onMouseover=\"showhint('Define a new dye if you cannot find the one you are using.', this, event, '300px')\" onClick='JavaScript:newDye(this)'> </td>"},
			{1:"* Sample:", 3:"<select name='" + samp_head + array_No + "' >" + getOptions([''].concat(samp_mine)) + "</select>", 5:"Dye:", 7:"<select name='" + dye_head + array_No + "' >" + dye_options_str + "</select><input type='button' name='btn_add_dye' value='New dye' class=\"hintanchor\" onMouseover=\"showhint('Define a new dye if you cannot find the one you are using.', this, event, '300px')\" onClick='JavaScript:newDye(this)'> </td>"},
			//{1:"Protocol for sample growth/treatment/separation:", 3:"<select name='" + prot_proc_head + array_No + "' >" + getOptions([''].concat(prot_proc_all)) + "</select>", 5:"Protocol for DNA/RNA/protein extraction/purification:", 7:"<select name='" + prot_tech_head + array_No + "' >" + getOptions([''].concat(prot_tech_all)) + "</select>"},
			{1:"Protocol for sample growth/treatment/separation:", 3:"<select name='" + prot_proc_head + array_No + "' >" + getOptions([''].concat(prot_proc_mine)) + "</select>", 5:"Protocol for DNA/RNA/protein extraction/purification:", 7:"<select name='" + prot_tech_head + array_No + "' >" + getOptions([''].concat(prot_tech_mine)) + "</select>"},
			//{1:"Protocol for DNA/RNA/protein labeling:", 3:"<select name='" + prot_label_head + array_No + "' >" + getOptions([''].concat(prot_label_all)) + "</select>", 5:"Experimental factor:", 7:"<input type='text' size=" + text_wid + " name='" + exp_factor_head + array_No + "' >"},
			{1:"Protocol for DNA/RNA/protein labeling:", 3:"<select name='" + prot_label_head + array_No + "' >" + getOptions([''].concat(prot_label_mine)) + "</select>", 5:"Experimental factor:", 7:"<input type='text' size=" + text_wid + " name='" + exp_factor_head + array_No + "' >"},
			{1:"Image file:", 3:img_str.replace('%d', array_No), 5:"Image file format:", 7:img_fmt_str.replace('%d', array_No)}
			];
	// add lines
	for (i in lines) {
		newtr = document.createElement('tr')
		newtr.appendChild(document.createElement('td'))
		newtd = document.createElement('td')
		newtd.align = 'left'
		newtr.appendChild(newtd)
		newtr.appendChild(document.createElement('td'))
		newtr.appendChild(document.createElement('td')) 

		newtr.appendChild(document.createElement('td'))
		newtd = document.createElement('td')
		newtd.align = 'left'
		newtr.appendChild(newtd)
		newtr.appendChild(document.createElement('td'))
		newtr.appendChild(document.createElement('td'))

		newtds = newtr.getElementsByTagName('td')
		for (j in lines[i]) newtds[j].innerHTML = lines[i][j]; 
		if (false && i==1) {
			thetd = newtds[3]
			thenodes = thetd.childNodes
			for (var k in thenodes) {
				thenode = thetd.childNodes[k]
				if (thenode.nodeName=='SELECT') {
					alert('innerHTML is ' + thetd.innerHTML)
					for (var a in thenode) alert(a + ' is ' + thenode[a])
					}
				}
			}
			
		tbbd.appendChild(newtr)
		}
	// add the new channel table
	chdv.appendChild(chtb)
	
	// enable the "remove" button for the first channel
	if (ch_No == 2) {
		tbs[0].rows[0].cells[3].innerHTML = '<input type="button" value="Remove this channel" onclick=removeCh(this)>'
		}
	// update (increase) the channel number 
	updateChnum(chdv) //, ch_No)
	}

function updateChnum(dv) {
	// update the Channel number
	var i, obj
	var ch_No = dv.getElementsByTagName('table').length
	var pdv = dv.parentNode
	pdv = pdv.parentNode
	for (i=0; i<pdv.childNodes.length; i++) {
		obj = pdv.childNodes[i].attributes
		if (obj && obj.getNamedItem('name') && obj.getNamedItem('name').value==ch_num) {
			pdv.childNodes[i].value = ch_No
			break }
		}
	}

function removeCh(tb) {
	while (tb.tagName != 'TABLE' && tb.tagName != 'DOCUMENT') tb = tb.parentNode
	if (tb.tagName != 'TABLE') return
	var dv = tb.parentNode
	var tbs = dv.getElementsByTagName('table')
	var i, j, idx, nm, found=false
	// find the index of the channel && remove this table from dv
	for (idx=0; idx<tbs.length; idx++) 
		if (tb == tbs[idx]) {
			dv.removeChild(tb)
			found=true; 
			break
			}
	if (!found) return
	// disable the "remove" button
	tbs = dv.getElementsByTagName('table')
	if (tbs.length == 1) {  
		tbs[0].rows[0].cells[3].innerHTML = '<input type="hidden" value="Remove this channel" onclick=removeCh(this)>'
		}
	// change names of input elements in the channel tables below
	for (i=idx; i<tbs.length; i++) {
		tb = tbs[i]
		// change the channel name first
		tb.rows[0].cells[1].getElementsByTagName('DIV')[0].innerHTML = i+1
		}

	// update (decrease) the channel number 
	updateChnum(dv)
	}

function getNamedTags(dv, tg, att, val) {
	// dv is an object, tg is tag name, att is attribute name, val is atribute value
	var i, units=[]
	var kids = dv.getElementsByTagName(tg)
	val = val.toUpperCase()
	for (i=0; i < kids.length; i++) {
		if (kids[i].attributes && kids[i].attributes.getNamedItem(att) && kids[i].attributes.getNamedItem(att).value.toUpperCase() == val) units.push(kids[i])
		}
	return units
	}

function updateChNames(unit) {
	// rename the item names of channels for the following arrays (from unit to end) after remove an array
	if (!unit) return
	var i, j, k, idx, chdv, kid, kids, m, re=ch_item_name, nm, tgnm, tgnms = {'INPUT':1, 'SELECT':1}
	var units = getNamedTags(unit.parentNode, 'div', 'name', 'unit')
	for(idx=0; idx<units.length; idx++) if (unit == units[idx]) break
	if (idx == units.length) return // return if no matching unit
	// change names
	for (i=idx; i<units.length; i++) {
		unit = units[i]
		chdv = getNamedTags(unit, 'div', 'name', 'channels')[0]
		for (tgnm in tgnms) {
			kids = chdv.getElementsByTagName(tgnm)
			for (j=0; j<kids.length; j++) {
				kid = kids[j]
				m = kid.name.match(re)
				if (m) {
					kid.name = m[1] + (i + 1)
					}
				}
			}
		}
	}

function ArrayNo(nm) {
	var re = /^.*?_array_(\d+)$/;
	var m = nm.match(re)
	if (m == null) return(false)
	return(parseInt(m[1])) // m[0] is the whole match, m[1] is the sub match
	}

function HideShow(dv, obj) {
	if (typeof(dv) == 'string') dv = document.getElementById(dv)
	if (!dv) return
	//dv.style.visibility = dv.style.visibility!='hidden' ? 'hidden' : 'visible'
	dv.style.display = dv.style.display!='none' ? 'none' : 'inline'
	if (obj != undefined) obj.value = dv.style.display=='none' ? 'Show' : 'Hide'
	}

function HideShowArray(pdv, obj) {
	var dv, dvs = pdv.getElementsByTagName('div') 
	for (var i=0; i<dvs.length; i++) {
		dv = dvs[i]
		if (dv.getAttribute('name') == 'array_body_div') // dv.attributes.getNamedItem('name').value
			break
		}
	if (!dv) return
	//dv.style.visibility = dv.style.visibility!='hidden' ? 'hidden' : 'visible'
	dv.style.display = dv.style.display!='none' ? 'none' : 'inline'
	if (obj != undefined) obj.value = dv.style.display=='none' ? 'Show' : 'Hide'
	}

function selOpt(sel, opt) {
	var opts = sel.options
	for (var i=0; i<opts.length; i++) 
		if (opts[i] != undefined && opts[i].value == opt) {
			opts[i].selected = true
			break
			}
	}

function updateOpt(obj, opts, blank) {
	var i, val = obj.options[obj.selectedIndex].value
	obj.length = 0
	if (blank != undefined) opts.unshift(blank)
	for (i=0; i<opts.length; i++) {
		obj.options[obj.length++].value = opts[i]
		obj.options[obj.length-1].text = opts[i]
		if (val == opts[i]) obj.options[obj.length-1].selected = true
		}
	}

function updateFileOpts() {
	var url = cgi_dir + '/findFiles.py'
	eval('var fns = ' + askSrv(url)) // url is a list, not a simple string, so use eval
	// update global variable img_str
	var img_head = 'image_file_array_'
	var i, j, opts = fns['image']
	img_str = ['<select name="' + img_head + '%d">']
	for (i=0; i<opts.length; i++) img_str.push('<option value="' + opts[i] + '">' + opts[i] + '</option>')
	img_str.push('</select>')
	img_str = img_str.join(' ')
	// find objs
	var nm, nms = {'prjanno':'prjanno_file', 'intensity':'intensity_file', 'probe':'probe_file', 'protocol':'prot_file'}
	var obj, objs = {}
	for (nm in nms) objs[nm] = document.getElementsByName(nms[nm])
	// find image file selects
	var ary_n = document.getElementsByName('identifier').length
	var imgs = []
	for (i=1; i<=ary_n; i++) {
		obj = document.getElementsByName(img_head + i)
		//for (j=0; j<obj.length; j++) imgs[imgs.length++] = obj[j]
		imgs = imgs.concat(convertToArray(obj, 0)) 
		}
	objs['image'] = imgs
	// update options
	for (nm in objs) 
		for (i=0; i<objs[nm].length; i++) 
			updateOpt(objs[nm][i], fns[nm])
	alert('File lists have been updated!')
	}

function convertToArray(obj, n) {
	if (! obj.length) {return [];} // length must be set on the object, or it is not iterable
	var a = [];
	try {
		a = Array.prototype.slice.call(obj, n);
		}
	catch(e) { // IE 6 and posssibly other browsers will throw an exception, so catch it and use brute force
		//Core.batch(obj, function(o, i) { // C
		//	if (n <= i) a[i - n] = o; });
		for (var j=n; j<obj.length; j++) a[a.length++] = obj[j]
		}
	return a;
	}


function newDye_by_win(loc) {
	if (loc == undefined) { // called by the window that defines new dye
		if (new_dye_val != undefined) {
			// check if it is a new dye value
			var nv_lower = new_dye_val.toLowerCase()
			var is_new = true
			var idx = new_dye_channel.length
			for (var i=0; i<new_dye_channel.length; i++) if (nv_lower == new_dye_channel.options[i].value.toLowerCase()) {
				is_new = false
				idx = i

				break; //return
				}
			if (is_new) {
				// update the new_dyes entry value using global variable "new_dye_val"
				var obj = document.getElementById(new_dyes);
				var val = obj.value;
				if (val.length > 0) obj.value = val + dye_sep + new_dye_val
				else obj.value = new_dye_val
				// update the global variable "dye_options_str"
				dye_options_str = dye_options_str + '<option value="' + new_dye_val + '">' + new_dye_val + '</option>'
				// update all options
				var objs = document.getElementsByName('btn_add_dye')
				for (i=0; i<objs.length; i++) {
					obj = objs[i].previousSibling
					obj[obj.length++] = new Option(new_dye_val, new_dye_val, false)
					}
				}
			// update the option for the dye-entry that called fore new dye "new_dye_channel"
			new_dye_channel.options[idx].selected = true
			}
		}
	else { 
		// get the dye-entry from loc and open a window to define new dye, set it as global variable
		new_dye_channel = loc.previousSibling
		target_win = window.open(base_dir_url+'/dbs_new_dye.html', 'User_added_Columns', 'scrollbars=yes,menubar=no,height=160,width=360,resizable=yes,toolbar=no,location=no,status=no')
		setTimeout('target_win.focus()', 1)
		}
	}

function newDye(loc) {
	// get the dye-entry from loc and open a window to define new dye, set it as global variable
	new_dye_channel = loc.previousSibling
	var new_dye_str = prompt('New dye name:', '')
	if (new_dye_str == null) return
	new_dye_val = trim(new_dye_str)
	if (new_dye_val.length == 0) return
	newDye_by_win()
	}

function fillTables(){
	var val=page_values
	var nm, v, i, item, tp
	var browser=(navigator.appName.indexOf("Microsoft")!=-1) ? "IE" : (!navigator.appName.indexOf("Netscape")) ? "NS" : "Not IE nor NS"
	var isNS = browser=='NS'
	for (nm in val) {
		//if (nm == 'platform') debugger
		v = val[nm]
		tp = typeof(v)
		if (tp == 'boolean') { // one of "number", "string", "boolean", "object", "function" and "undefined"
			// should be a checkbox
			item = document.getElementsByName(nm)[0]
			item.checked = true
			}
		else if (tp != 'object') { 
			item = document.getElementsByName(nm)[0]
			if (item) item.value = v
			else if (!isNS) { // try to find SELECTs since IE cannot get SELECT by name
				item = document.getElementsByTagName('SELECT')
				if (item.length>0) {
					for (i=0; i<item.length; i++) 
						if (item[i].name == nm) {
							item[i].value=v //selOpt(item[i], v)
							break
							}
					}
				}		
			}
		else { // should be a list or a dict
			item =  document.getElementsByName(nm)
			if (item.length>0) {
				//for (i=0; i<item.length; i++)
				for (i=0; i<v.length; i++) 
					if (typeof(v[i]) == 'boolean') item[i].checked = true
					else {
						if (isNS || item[i].tagName!='SELECT')
							{if (item[i] != undefined) item[i].value = v[i] }
						else selOpt(item[i], v[i])

						//try {item[i].value = v[i]}
						//catch(err) {continue; alert(nm + ' : ' + v[i] + ' i is ' + i + ' and item.length is ' + item.length) }
						}
				}
			else if (!isNS) {  // try to find SELECTs since (sometimes?) IE cannot get SELECT by name
				item = document.getElementsByTagName('SELECT')
				if (item.length>0) {
					var j=0
					for (i=0; i<item.length; i++) 
						if (item[i].name == nm) {
							item[i].value=v[j++] //selOpt(item[i], v)
							if (j >= v.length) break
							}
					}
				}
			}
		}
	}

function showTitle(obj, info) {
	obj.title = info.join(', ')
	}

function mkDates() {
	//'prj_date_entry'
	var i, obj = document.getElementById('prj_date_entry')
	mkDate(obj, rel_year, rel_mon, rel_day, 2007, 2027)
	// 'hyb_date_entry'
	var objs = document.getElementsByName('hyb_date_entry')
	//for (i=0; i<objs.length; i++) mkDate(obj[i].parentNode, hyb_year, hyb_mon, hyb_day)  // This doesn't work in IE, because obj was destroyed by changing its parentNode's innerHTML, so objs was changed before rest cycles.
	var parents = []
	for (i=0; i<objs.length; i++) parents[i] = objs[i].parentNode
	for (i in parents) mkDate(parents[i], hyb_year, hyb_mon, hyb_day, 1990, 2027)
	//var txts = [] 
	//for (i=0; i<objs.length; i++) txts[i] = mkDate(undefined, hyb_year, hyb_mon, hyb_day)
	//for (i in txts) parents[i].innerHTML = txts[i]
	}

function fillForm() {
	// make date items
	mkDates()

	// fill table for the first time. Some <select> cannot be filled correctly since no valid options offered
	fillTables()

	// update selection options
	onChangePfs(first_time=true)
	onChangeSamps(first_time=true)
	onChangeProts(first_time=true)

	// fill table again (for <select> items)
	fillTables()
	}


function selTbCols(obj, tbnm) {
	waiting_entry = obj
	waiting_names = user_cols[tbnm]
	waiting_types = user_types[tbnm]
	target_win = window.open(base_dir_url+'/dbs_select_cols.html', 'User_added_Columns', 'scrollbars=yes,menubar=no,height=440,width=250,resizable=yes,toolbar=no,location=no,status=no')
	setTimeout('target_win.focus()', 1)
	}

function trim(st) {return st.replace(/^\s*/g,"").replace(/\s*$/g,""); }

function checkProject(fm) {
	var errs = [];
	if (ii<2) {
		alert(fm[prj_name].value) 
		fm[prj_name].focus()
		}
	else {
		ii = 0
		}
	}

function checkName(fm){
	var parth = /^[a-zA-Z0-9_]+$/;
	var new_name = trim(fm[request_name].value); 
	if (new_name != '') {
		if (!parth.test(new_name)) { return(["Illegal characters in request name"]);}
		}
	return []
	}

function confirmName(fm){
	var old_name = req_nm_val;
	var new_name = trim(fm[request_name].value); 
	if (old_name != '' && new_name == old_name) {
		if (!confirm('The request name is same to the old one, the new results will overwrite the old one, is it OK?\notherwise, click Cancel to change it.')) return false;
		}
	return true;
	}

function checkRequired(fm) {
	return [];
	}

function checkForm(fm){
	var errs = []
	if (new_project) errs = errs.concat(PrjNameErrs(fm[prj_name]))
	errs = errs.concat(ArrayNameErrs(document.getElementsByName(array_id)))
	errs = errs.concat(PfNameErrs(document.getElementsByName(pf_name)))
	errs = errs.concat(SampNameErrs(document.getElementsByName(samp_name)))
	errs = errs.concat(ProtNameErrs(document.getElementsByName(prot_name)))
	//errs = errs.concat(checkName(fm))
	errs = errs.concat(checkRequired(fm))
	if (!errs.length) return true; //return confirmName(fm); //return true;
	alert(errs.join(';\n') + '\n\nPlease correct it.')
	return false
	}

